/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.google.android.datatransport.TransportFactory;
import com.google.firebase.FirebaseApp;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.ktx.Firebase;
import com.google.firebase.ktx.FirebaseKt;
import com.google.firebase.sessions.ApplicationInfo;
import com.google.firebase.sessions.EventGDTLogger;
import com.google.firebase.sessions.FirebaseSessions;
import com.google.firebase.sessions.SessionCoordinator;
import com.google.firebase.sessions.SessionDetails;
import com.google.firebase.sessions.SessionEvents;
import com.google.firebase.sessions.SessionGenerator;
import com.google.firebase.sessions.SessionInitiateListener;
import com.google.firebase.sessions.SessionInitiator;
import com.google.firebase.sessions.Time;
import com.google.firebase.sessions.TimeProvider;
import com.google.firebase.sessions.api.FirebaseSessionsDependencies;
import com.google.firebase.sessions.api.SessionSubscriber;
import com.google.firebase.sessions.settings.SessionsSettings;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 #2\u00020\u0001:\u0001#B5\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006$"}, d2={"Lcom/google/firebase/sessions/FirebaseSessions;", "", "firebaseApp", "Lcom/google/firebase/FirebaseApp;", "firebaseInstallations", "Lcom/google/firebase/installations/FirebaseInstallationsApi;", "backgroundDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "blockingDispatcher", "transportFactoryProvider", "Lcom/google/firebase/inject/Provider;", "Lcom/google/android/datatransport/TransportFactory;", "(Lcom/google/firebase/FirebaseApp;Lcom/google/firebase/installations/FirebaseInstallationsApi;Lkotlinx/coroutines/CoroutineDispatcher;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/google/firebase/inject/Provider;)V", "applicationInfo", "Lcom/google/firebase/sessions/ApplicationInfo;", "eventGDTLogger", "Lcom/google/firebase/sessions/EventGDTLogger;", "sessionCoordinator", "Lcom/google/firebase/sessions/SessionCoordinator;", "sessionGenerator", "Lcom/google/firebase/sessions/SessionGenerator;", "sessionSettings", "Lcom/google/firebase/sessions/settings/SessionsSettings;", "timeProvider", "Lcom/google/firebase/sessions/TimeProvider;", "initiateSessionStart", "", "sessionDetails", "Lcom/google/firebase/sessions/SessionDetails;", "(Lcom/google/firebase/sessions/SessionDetails;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "register", "subscriber", "Lcom/google/firebase/sessions/api/SessionSubscriber;", "shouldCollectEvents", "", "Companion", "com.google.firebase-firebase-sessions"})
public final class FirebaseSessions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirebaseApp firebaseApp;
    @NotNull
    private final ApplicationInfo applicationInfo;
    @NotNull
    private final SessionsSettings sessionSettings;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final SessionGenerator sessionGenerator;
    @NotNull
    private final EventGDTLogger eventGDTLogger;
    @NotNull
    private final SessionCoordinator sessionCoordinator;
    @NotNull
    private static final String TAG = "FirebaseSessions";

    public FirebaseSessions(@NotNull FirebaseApp firebaseApp, @NotNull FirebaseInstallationsApi firebaseInstallations, @NotNull CoroutineDispatcher backgroundDispatcher, @NotNull CoroutineDispatcher blockingDispatcher, @NotNull Provider<TransportFactory> transportFactoryProvider) {
        Intrinsics.checkNotNullParameter((Object)firebaseApp, (String)"firebaseApp");
        Intrinsics.checkNotNullParameter((Object)firebaseInstallations, (String)"firebaseInstallations");
        Intrinsics.checkNotNullParameter((Object)backgroundDispatcher, (String)"backgroundDispatcher");
        Intrinsics.checkNotNullParameter((Object)blockingDispatcher, (String)"blockingDispatcher");
        Intrinsics.checkNotNullParameter(transportFactoryProvider, (String)"transportFactoryProvider");
        this.firebaseApp = firebaseApp;
        this.applicationInfo = SessionEvents.INSTANCE.getApplicationInfo(this.firebaseApp);
        Context context = this.firebaseApp.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"firebaseApp.applicationContext");
        this.sessionSettings = new SessionsSettings(context, (CoroutineContext)blockingDispatcher, (CoroutineContext)backgroundDispatcher, firebaseInstallations, this.applicationInfo);
        this.timeProvider = new Time();
        this.eventGDTLogger = new EventGDTLogger(transportFactoryProvider);
        this.sessionCoordinator = new SessionCoordinator(firebaseInstallations, this.eventGDTLogger);
        this.sessionGenerator = new SessionGenerator(this.shouldCollectEvents(), this.timeProvider, null, 4, null);
        SessionInitiateListener sessionInitiateListener2 = new SessionInitiateListener(this){
            final /* synthetic */ FirebaseSessions this$0;
            {
                this.this$0 = $receiver;
            }

            @Nullable
            public Object onInitiateSession(@NotNull SessionDetails sessionDetails, @NotNull Continuation<? super Unit> $completion) {
                Object object = FirebaseSessions.access$initiateSessionStart(this.this$0, sessionDetails, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        };
        SessionInitiator sessionInitiator = new SessionInitiator(this.timeProvider, (CoroutineContext)backgroundDispatcher, sessionInitiateListener2, this.sessionSettings, this.sessionGenerator);
        Context appContext = this.firebaseApp.getApplicationContext().getApplicationContext();
        if (appContext instanceof Application) {
            ((Application)appContext).registerActivityLifecycleCallbacks(sessionInitiator.getActivityLifecycleCallbacks$com_google_firebase_firebase_sessions());
        } else {
            Log.e((String)TAG, (String)("Failed to register lifecycle callbacks, unexpected context " + appContext.getClass() + '.'));
        }
    }

    public final void register(@NotNull SessionSubscriber subscriber) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        FirebaseSessionsDependencies.INSTANCE.register$com_google_firebase_firebase_sessions(subscriber);
        Log.d((String)TAG, (String)("Registering Sessions SDK subscriber with name: " + (Object)((Object)subscriber.getSessionSubscriberName()) + ", data collection enabled: " + subscriber.isDataCollectionEnabled()));
        if (this.sessionGenerator.getHasGenerateSession()) {
            subscriber.onSessionChanged(new SessionSubscriber.SessionDetails(this.sessionGenerator.getCurrentSession().getSessionId()));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object initiateSessionStart(SessionDetails var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof initiateSessionStart.1)) ** GOTO lbl-1000
        var11_3 = var2_2;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ FirebaseSessions this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return FirebaseSessions.access$initiateSessionStart(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = sessionDetails;
                $continuation.label = 1;
                v0 = FirebaseSessionsDependencies.INSTANCE.getRegisteredSubscribers$com_google_firebase_firebase_sessions((Continuation<? super Map<SessionSubscriber.Name, ? extends SessionSubscriber>>)$continuation);
                if (v0 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                sessionDetails = (SessionDetails)$continuation.L$1;
                this = (FirebaseSessions)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if ((subscribers = (Map)v0).isEmpty()) {
                    Log.d((String)"FirebaseSessions", (String)"Sessions SDK did not have any dependent SDKs register as dependencies. Events will not be sent.");
                    return Unit.INSTANCE;
                }
                $this$forEach$iv = subscribers.values();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    subscriber = (SessionSubscriber)element$iv;
                    $i$a$-forEach-FirebaseSessions$initiateSessionStart$2 = false;
                    subscriber.onSessionChanged(new SessionSubscriber.SessionDetails(sessionDetails.getSessionId()));
                }
                $this$none$iv = subscribers.values();
                $i$f$none = false;
                if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) ** GOTO lbl41
                v1 = true;
                ** GOTO lbl48
lbl41:
                // 2 sources

                for (T element$iv : $this$none$iv) {
                    it = (SessionSubscriber)element$iv;
                    $i$a$-none-FirebaseSessions$initiateSessionStart$3 = false;
                    if (!it.isDataCollectionEnabled()) continue;
                    v1 = false;
                    ** GOTO lbl48
                }
                v1 = true;
lbl48:
                // 3 sources

                if (v1) {
                    Log.d((String)"FirebaseSessions", (String)"Data Collection is disabled for all subscribers. Skipping this Session Event");
                    return Unit.INSTANCE;
                }
                Log.d((String)"FirebaseSessions", (String)"Data Collection is enabled for at least one Subscriber");
                $continuation.L$0 = this;
                $continuation.L$1 = sessionDetails;
                $continuation.label = 2;
                v2 = this.sessionSettings.updateSettings((Continuation<? super Unit>)$continuation);
                if (v2 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl66
            }
            case 2: {
                sessionDetails = (SessionDetails)$continuation.L$1;
                this = (FirebaseSessions)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl66:
                // 2 sources

                if (!this.sessionSettings.getSessionsEnabled()) {
                    Log.d((String)"FirebaseSessions", (String)"Sessions SDK disabled. Events will not be sent.");
                    return Unit.INSTANCE;
                }
                if (!this.sessionGenerator.getCollectEvents()) {
                    Log.d((String)"FirebaseSessions", (String)"Sessions SDK has dropped this session due to sampling.");
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 3;
                v3 = this.sessionCoordinator.attemptLoggingSessionEvent(SessionEvents.INSTANCE.startSession(this.firebaseApp, sessionDetails, this.sessionSettings), (Continuation<? super Unit>)$continuation);
                if (v3 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl84
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl84:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean shouldCollectEvents() {
        double randomValue = Math.random();
        return randomValue <= this.sessionSettings.getSamplingRate();
    }

    @NotNull
    public static final FirebaseSessions getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final FirebaseSessions getInstance(@NotNull FirebaseApp app) {
        return Companion.getInstance(app);
    }

    public static final /* synthetic */ Object access$initiateSessionStart(FirebaseSessions $this, SessionDetails sessionDetails, Continuation $completion) {
        return $this.initiateSessionStart(sessionDetails, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/google/firebase/sessions/FirebaseSessions$Companion;", "", "()V", "TAG", "", "instance", "Lcom/google/firebase/sessions/FirebaseSessions;", "getInstance$annotations", "getInstance", "()Lcom/google/firebase/sessions/FirebaseSessions;", "app", "Lcom/google/firebase/FirebaseApp;", "com.google.firebase-firebase-sessions"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FirebaseSessions getInstance() {
            return this.getInstance(FirebaseKt.getApp((Firebase)Firebase.INSTANCE));
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @JvmStatic
        @NotNull
        public final FirebaseSessions getInstance(@NotNull FirebaseApp app) {
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            Object object = app.get(FirebaseSessions.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"app.get(FirebaseSessions::class.java)");
            return (FirebaseSessions)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

