/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.Encoding;
import com.google.android.datatransport.Event;
import com.google.android.datatransport.TransportFactory;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.installations.FirebaseInstallations;
import com.google.firebase.messaging.FirebaseMessaging;
import com.google.firebase.messaging.NotificationParams;
import com.google.firebase.messaging.reporting.MessagingClientEvent;
import com.google.firebase.messaging.reporting.MessagingClientEventExtension;
import java.util.concurrent.ExecutionException;

public class MessagingAnalytics {
    private static final String REENGAGEMENT_SOURCE = "Firebase";
    private static final String REENGAGEMENT_MEDIUM = "notification";
    private static final String FCM_PREFERENCES = "com.google.firebase.messaging";
    private static final String DELIVERY_METRICS_EXPORT_TO_BIG_QUERY_PREF = "export_to_big_query";
    private static final String MANIFEST_DELIVERY_METRICS_EXPORT_TO_BIG_QUERY_ENABLED = "delivery_metrics_exported_to_big_query_enabled";

    public static void logNotificationReceived(Intent intent) {
        if (MessagingAnalytics.shouldUploadScionMetrics(intent)) {
            MessagingAnalytics.logToScion("_nr", intent.getExtras());
        }
        if (MessagingAnalytics.shouldUploadFirelogAnalytics(intent)) {
            MessagingAnalytics.logToFirelog(MessagingClientEvent.Event.MESSAGE_DELIVERED, intent, FirebaseMessaging.getTransportFactory());
        }
    }

    public static void logNotificationOpen(Bundle extras) {
        MessagingAnalytics.setUserPropertyIfRequired(extras);
        MessagingAnalytics.logToScion("_no", extras);
    }

    public static void logNotificationDismiss(Intent intent) {
        MessagingAnalytics.logToScion("_nd", intent.getExtras());
    }

    public static void logNotificationForeground(Intent intent) {
        MessagingAnalytics.logToScion("_nf", intent.getExtras());
    }

    public static boolean shouldUploadScionMetrics(Intent intent) {
        if (intent == null || MessagingAnalytics.isDirectBootMessage(intent)) {
            return false;
        }
        return MessagingAnalytics.shouldUploadScionMetrics(intent.getExtras());
    }

    public static boolean shouldUploadScionMetrics(Bundle extras) {
        if (extras == null) {
            return false;
        }
        return "1".equals(extras.getString("google.c.a.e"));
    }

    public static boolean shouldUploadFirelogAnalytics(Intent intent) {
        if (intent == null || MessagingAnalytics.isDirectBootMessage(intent)) {
            return false;
        }
        return MessagingAnalytics.deliveryMetricsExportToBigQueryEnabled();
    }

    private static boolean isDirectBootMessage(Intent intent) {
        return "com.google.firebase.messaging.RECEIVE_DIRECT_BOOT".equals(intent.getAction());
    }

    static boolean deliveryMetricsExportToBigQueryEnabled() {
        try {
            FirebaseApp.getInstance();
        }
        catch (IllegalStateException e) {
            Log.i((String)"FirebaseMessaging", (String)"FirebaseApp has not being initialized. Device might be in direct boot mode. Skip exporting delivery metrics to Big Query");
            return false;
        }
        Context context = FirebaseApp.getInstance().getApplicationContext();
        SharedPreferences preferences = context.getSharedPreferences(FCM_PREFERENCES, 0);
        if (preferences.contains(DELIVERY_METRICS_EXPORT_TO_BIG_QUERY_PREF)) {
            return preferences.getBoolean(DELIVERY_METRICS_EXPORT_TO_BIG_QUERY_PREF, false);
        }
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = context.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey(MANIFEST_DELIVERY_METRICS_EXPORT_TO_BIG_QUERY_ENABLED)) {
                return applicationInfo.metaData.getBoolean(MANIFEST_DELIVERY_METRICS_EXPORT_TO_BIG_QUERY_ENABLED, false);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private static void setUserPropertyIfRequired(Bundle extras) {
        if (extras == null) {
            return;
        }
        String shouldTrackConversions = extras.getString("google.c.a.tc");
        if ("1".equals(shouldTrackConversions)) {
            AnalyticsConnector analytics = (AnalyticsConnector)FirebaseApp.getInstance().get(AnalyticsConnector.class);
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)"Received event with track-conversion=true. Setting user property and reengagement event");
            }
            if (analytics != null) {
                String composerId = extras.getString("google.c.a.c_id");
                analytics.setUserProperty("fcm", "_ln", (Object)composerId);
                Bundle params = new Bundle();
                params.putString("source", REENGAGEMENT_SOURCE);
                params.putString("medium", REENGAGEMENT_MEDIUM);
                params.putString("campaign", composerId);
                analytics.logEvent("fcm", "_cmp", params);
            } else {
                Log.w((String)"FirebaseMessaging", (String)"Unable to set user property for conversion tracking:  analytics library is missing");
            }
        } else if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Received event with track-conversion=false. Do not set user property");
        }
    }

    @VisibleForTesting
    static void logToScion(String event, Bundle extras) {
        AnalyticsConnector analytics;
        String useDeviceTime;
        String messageTime;
        String topic;
        String messageChannel;
        String messageLabel;
        String composerLabel;
        try {
            FirebaseApp.getInstance();
        }
        catch (IllegalStateException e) {
            Log.e((String)"FirebaseMessaging", (String)"Default FirebaseApp has not been initialized. Skip logging event to GA.");
            return;
        }
        if (extras == null) {
            extras = new Bundle();
        }
        Bundle scionPayload = new Bundle();
        String composerId = MessagingAnalytics.getComposerId(extras);
        if (composerId != null) {
            scionPayload.putString("_nmid", composerId);
        }
        if ((composerLabel = MessagingAnalytics.getComposerLabel(extras)) != null) {
            scionPayload.putString("_nmn", composerLabel);
        }
        if (!TextUtils.isEmpty((CharSequence)(messageLabel = MessagingAnalytics.getMessageLabel(extras)))) {
            scionPayload.putString("label", messageLabel);
        }
        if (!TextUtils.isEmpty((CharSequence)(messageChannel = MessagingAnalytics.getMessageChannel(extras)))) {
            scionPayload.putString("message_channel", messageChannel);
        }
        if ((topic = MessagingAnalytics.getTopic(extras)) != null) {
            scionPayload.putString("_nt", topic);
        }
        if ((messageTime = MessagingAnalytics.getMessageTime(extras)) != null) {
            try {
                scionPayload.putInt("_nmt", Integer.parseInt(messageTime));
            }
            catch (NumberFormatException e) {
                Log.w((String)"FirebaseMessaging", (String)"Error while parsing timestamp in GCM event", (Throwable)e);
            }
        }
        if ((useDeviceTime = MessagingAnalytics.getUseDeviceTime(extras)) != null) {
            try {
                scionPayload.putInt("_ndt", Integer.parseInt(useDeviceTime));
            }
            catch (NumberFormatException e) {
                Log.w((String)"FirebaseMessaging", (String)"Error while parsing use_device_time in GCM event", (Throwable)e);
            }
        }
        String messageType = MessagingAnalytics.getMessageTypeForScion(extras);
        if ("_nr".equals(event) || "_nf".equals(event)) {
            scionPayload.putString("_nmc", messageType);
        }
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)("Logging to scion event=" + event + " scionPayload=" + scionPayload));
        }
        if ((analytics = (AnalyticsConnector)FirebaseApp.getInstance().get(AnalyticsConnector.class)) != null) {
            analytics.logEvent("fcm", event, scionPayload);
        } else {
            Log.w((String)"FirebaseMessaging", (String)"Unable to log event: analytics library is missing");
        }
    }

    private static void logToFirelog(MessagingClientEvent.Event event, Intent intent, @Nullable TransportFactory transportFactory) {
        if (transportFactory == null) {
            Log.e((String)"FirebaseMessaging", (String)"TransportFactory is null. Skip exporting message delivery metrics to Big Query");
            return;
        }
        MessagingClientEvent clientEvent = MessagingAnalytics.eventToProto(event, intent);
        if (clientEvent == null) {
            return;
        }
        try {
            transportFactory.getTransport("FCM_CLIENT_EVENT_LOGGING", MessagingClientEventExtension.class, Encoding.of((String)"src/main/proto"), MessagingClientEventExtension::toByteArray).send(Event.ofTelemetry((Object)MessagingClientEventExtension.newBuilder().setMessagingClientEvent(clientEvent).build()));
        }
        catch (RuntimeException e) {
            Log.w((String)"FirebaseMessaging", (String)"Failed to send big query analytics payload.", (Throwable)e);
        }
    }

    static void setDeliveryMetricsExportToBigQuery(boolean enable) {
        SharedPreferences.Editor editor = FirebaseApp.getInstance().getApplicationContext().getSharedPreferences(FCM_PREFERENCES, 0).edit();
        editor.putBoolean(DELIVERY_METRICS_EXPORT_TO_BIG_QUERY_PREF, enable).apply();
    }

    @NonNull
    static int getTtl(Bundle extras) {
        Object ttl = extras.get("google.ttl");
        if (ttl instanceof Integer) {
            return (Integer)ttl;
        }
        if (ttl instanceof String) {
            try {
                return Integer.parseInt((String)ttl);
            }
            catch (NumberFormatException e) {
                Log.w((String)"FirebaseMessaging", (String)("Invalid TTL: " + ttl));
            }
        }
        return 0;
    }

    @Nullable
    static String getCollapseKey(Bundle extras) {
        return extras.getString("collapse_key");
    }

    @Nullable
    static String getComposerId(Bundle extras) {
        return extras.getString("google.c.a.c_id");
    }

    @Nullable
    static String getComposerLabel(Bundle extras) {
        return extras.getString("google.c.a.c_l");
    }

    @Nullable
    static String getMessageLabel(Bundle extras) {
        return extras.getString("google.c.a.m_l");
    }

    @Nullable
    static String getMessageChannel(Bundle extras) {
        return extras.getString("google.c.a.m_c");
    }

    @Nullable
    static String getMessageTime(Bundle extras) {
        return extras.getString("google.c.a.ts");
    }

    @Nullable
    static String getMessageId(Bundle extras) {
        String messageId = extras.getString("google.message_id");
        if (messageId == null) {
            messageId = extras.getString("message_id");
        }
        return messageId;
    }

    @NonNull
    static String getPackageName() {
        return FirebaseApp.getInstance().getApplicationContext().getPackageName();
    }

    @NonNull
    static String getInstanceId(Bundle extras) {
        String to = extras.getString("google.to");
        if (!TextUtils.isEmpty((CharSequence)to)) {
            return to;
        }
        try {
            return (String)Tasks.await((Task)FirebaseInstallations.getInstance((FirebaseApp)FirebaseApp.getInstance()).getId());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    static String getMessageTypeForScion(Bundle extras) {
        return extras != null && NotificationParams.isNotification(extras) ? "display" : "data";
    }

    @NonNull
    static MessagingClientEvent.MessageType getMessageTypeForFirelog(Bundle extras) {
        return extras != null && NotificationParams.isNotification(extras) ? MessagingClientEvent.MessageType.DISPLAY_NOTIFICATION : MessagingClientEvent.MessageType.DATA_MESSAGE;
    }

    @Nullable
    static String getTopic(Bundle extras) {
        String from = extras.getString("from");
        return from != null && from.startsWith("/topics/") ? from : null;
    }

    @Nullable
    static String getUseDeviceTime(Bundle extras) {
        if (extras.containsKey("google.c.a.udt")) {
            return extras.getString("google.c.a.udt");
        }
        return null;
    }

    @NonNull
    static int getPriority(Bundle extras) {
        String priority = extras.getString("google.delivered_priority");
        if (priority == null) {
            if ("1".equals(extras.getString("google.priority_reduced"))) {
                return 2;
            }
            priority = extras.getString("google.priority");
        }
        return MessagingAnalytics.getMessagePriority(priority);
    }

    @NonNull
    private static int getMessagePriority(String priority) {
        if ("high".equals(priority)) {
            return 1;
        }
        if ("normal".equals(priority)) {
            return 2;
        }
        return 0;
    }

    static int getMessagePriorityForFirelog(Bundle extras) {
        int priority = MessagingAnalytics.getPriority(extras);
        if (priority == 2) {
            return 5;
        }
        if (priority == 1) {
            return 10;
        }
        return 0;
    }

    @Nullable
    static long getProjectNumber(Bundle extras) {
        String appId;
        FirebaseApp app;
        String senderId;
        if (extras.containsKey("google.c.sender.id")) {
            try {
                return Long.parseLong(extras.getString("google.c.sender.id"));
            }
            catch (NumberFormatException ex) {
                Log.w((String)"FirebaseMessaging", (String)"error parsing project number", (Throwable)ex);
            }
        }
        if ((senderId = (app = FirebaseApp.getInstance()).getOptions().getGcmSenderId()) != null) {
            try {
                return Long.parseLong(senderId);
            }
            catch (NumberFormatException ex) {
                Log.w((String)"FirebaseMessaging", (String)"error parsing sender ID", (Throwable)ex);
            }
        }
        if (!(appId = app.getOptions().getApplicationId()).startsWith("1:")) {
            try {
                return Long.parseLong(appId);
            }
            catch (NumberFormatException ex) {
                Log.w((String)"FirebaseMessaging", (String)"error parsing app ID", (Throwable)ex);
            }
        } else {
            String[] parts = appId.split(":");
            if (parts.length < 2) {
                return 0L;
            }
            String projectId = parts[1];
            if (projectId.isEmpty()) {
                return 0L;
            }
            try {
                return Long.parseLong(projectId);
            }
            catch (NumberFormatException ex) {
                Log.w((String)"FirebaseMessaging", (String)"error parsing app ID", (Throwable)ex);
            }
        }
        return 0L;
    }

    static MessagingClientEvent eventToProto(MessagingClientEvent.Event event, Intent intent) {
        long projectNumber;
        String composerLabel;
        String messageLabel;
        String collapseKey;
        String topic;
        if (intent == null) {
            return null;
        }
        Bundle extras = intent.getExtras();
        if (extras == null) {
            extras = Bundle.EMPTY;
        }
        MessagingClientEvent.Builder builder = MessagingClientEvent.newBuilder().setTtl(MessagingAnalytics.getTtl(extras)).setEvent(event).setInstanceId(MessagingAnalytics.getInstanceId(extras)).setPackageName(MessagingAnalytics.getPackageName()).setSdkPlatform(MessagingClientEvent.SDKPlatform.ANDROID).setMessageType(MessagingAnalytics.getMessageTypeForFirelog(extras));
        String messageId = MessagingAnalytics.getMessageId(extras);
        if (messageId != null) {
            builder.setMessageId(messageId);
        }
        if ((topic = MessagingAnalytics.getTopic(extras)) != null) {
            builder.setTopic(topic);
        }
        if ((collapseKey = MessagingAnalytics.getCollapseKey(extras)) != null) {
            builder.setCollapseKey(collapseKey);
        }
        if ((messageLabel = MessagingAnalytics.getMessageLabel(extras)) != null) {
            builder.setAnalyticsLabel(messageLabel);
        }
        if ((composerLabel = MessagingAnalytics.getComposerLabel(extras)) != null) {
            builder.setComposerLabel(composerLabel);
        }
        if ((projectNumber = MessagingAnalytics.getProjectNumber(extras)) > 0L) {
            builder.setProjectNumber(projectNumber);
        }
        return builder.build();
    }
}

