/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.util.Log;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.firebase.messaging.WakeLockHolder;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public class ServiceStarter {
    public static final int SUCCESS = -1;
    @KeepForSdk
    public static final int ERROR_UNKNOWN = 500;
    static final int ERROR_NOT_FOUND = 404;
    static final int ERROR_SECURITY_EXCEPTION = 401;
    static final int ERROR_ILLEGAL_STATE_EXCEPTION = 402;
    static final int ERROR_ILLEGAL_STATE_EXCEPTION_FALLBACK_TO_BIND = 403;
    static final String ACTION_MESSAGING_EVENT = "com.google.firebase.MESSAGING_EVENT";
    private static final String EXTRA_WRAPPED_INTENT = "wrapped_intent";
    private static final String PERMISSIONS_MISSING_HINT = "this should normally be included by the manifest merger, but may needed to be manually added to your manifest";
    private static ServiceStarter instance;
    @GuardedBy(value="this")
    @Nullable
    private String firebaseMessagingServiceClassName = null;
    private Boolean hasWakeLockPermission = null;
    private Boolean hasAccessNetworkStatePermission = null;
    private final Queue<Intent> messagingEvents = new ArrayDeque<Intent>();

    static synchronized ServiceStarter getInstance() {
        if (instance == null) {
            instance = new ServiceStarter();
        }
        return instance;
    }

    private ServiceStarter() {
    }

    @MainThread
    Intent getMessagingEvent() {
        return this.messagingEvents.poll();
    }

    @MainThread
    public int startMessagingService(Context context, Intent intent) {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Starting service");
        }
        this.messagingEvents.offer(intent);
        Intent serviceIntent = new Intent(ACTION_MESSAGING_EVENT);
        serviceIntent.setPackage(context.getPackageName());
        return this.doStartService(context, serviceIntent);
    }

    private int doStartService(Context context, Intent intent) {
        String className = this.resolveServiceClassName(context, intent);
        if (className != null) {
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)("Restricting intent to a specific service: " + className));
            }
            intent.setClassName(context.getPackageName(), className);
        }
        try {
            ComponentName service;
            if (this.hasWakeLockPermission(context)) {
                service = WakeLockHolder.startWakefulService(context, intent);
            } else {
                service = context.startService(intent);
                Log.d((String)"FirebaseMessaging", (String)"Missing wake lock permission, service start may be delayed");
            }
            if (service == null) {
                Log.e((String)"FirebaseMessaging", (String)"Error while delivering the message: ServiceIntent not found.");
                return 404;
            }
            return -1;
        }
        catch (SecurityException ex) {
            Log.e((String)"FirebaseMessaging", (String)"Error while delivering the message to the serviceIntent", (Throwable)ex);
            return 401;
        }
        catch (IllegalStateException e) {
            Log.e((String)"FirebaseMessaging", (String)("Failed to start service while in background: " + e));
            return 402;
        }
    }

    @Nullable
    private synchronized String resolveServiceClassName(Context context, Intent intent) {
        if (this.firebaseMessagingServiceClassName != null) {
            return this.firebaseMessagingServiceClassName;
        }
        ResolveInfo resolveInfo = context.getPackageManager().resolveService(intent, 0);
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            Log.e((String)"FirebaseMessaging", (String)"Failed to resolve target intent service, skipping classname enforcement");
            return null;
        }
        ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        if (!context.getPackageName().equals(serviceInfo.packageName) || serviceInfo.name == null) {
            Log.e((String)"FirebaseMessaging", (String)("Error resolving target intent service, skipping classname enforcement. Resolved service was: " + serviceInfo.packageName + "/" + serviceInfo.name));
            return null;
        }
        this.firebaseMessagingServiceClassName = serviceInfo.name.startsWith(".") ? context.getPackageName() + serviceInfo.name : serviceInfo.name;
        return this.firebaseMessagingServiceClassName;
    }

    boolean hasWakeLockPermission(Context context) {
        if (this.hasWakeLockPermission == null) {
            this.hasWakeLockPermission = context.checkCallingOrSelfPermission("android.permission.WAKE_LOCK") == 0;
        }
        if (!this.hasWakeLockPermission.booleanValue() && Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Missing Permission: android.permission.WAKE_LOCK this should normally be included by the manifest merger, but may needed to be manually added to your manifest");
        }
        return this.hasWakeLockPermission;
    }

    boolean hasAccessNetworkStatePermission(Context context) {
        if (this.hasAccessNetworkStatePermission == null) {
            this.hasAccessNetworkStatePermission = context.checkCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0;
        }
        if (!this.hasWakeLockPermission.booleanValue() && Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Missing Permission: android.permission.ACCESS_NETWORK_STATE this should normally be included by the manifest merger, but may needed to be manually added to your manifest");
        }
        return this.hasAccessNetworkStatePermission;
    }

    @VisibleForTesting
    public static void setForTesting(ServiceStarter serviceStarter) {
        instance = serviceStarter;
    }
}

