/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import java.util.regex.Pattern;

final class TopicOperation {
    private static final Pattern TOPIC_NAME_REGEXP = Pattern.compile("[a-zA-Z0-9-_.~%]{1,900}");
    private final String topic;
    private final String operation;
    private final String serializedString;

    private TopicOperation(String string, String string2) {
        this.topic = TopicOperation.normalizeTopicOrThrow(string2, string);
        this.operation = string;
        this.serializedString = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("!").append(string2).toString();
    }

    @NonNull
    private static String normalizeTopicOrThrow(String string, String string2) {
        if (string != null && string.startsWith("/topics/")) {
            Log.w((String)"FirebaseMessaging", (String)String.format("Format /topics/topic-name is deprecated. Only 'topic-name' should be used in %s.", string2));
            string = string.substring(8);
        }
        if (string == null || !TOPIC_NAME_REGEXP.matcher(string).matches()) {
            throw new IllegalArgumentException(String.format("Invalid topic name: %s does not match the allowed format %s.", string, "[a-zA-Z0-9-_.~%]{1,900}"));
        }
        return string;
    }

    public static TopicOperation subscribe(@NonNull String string) {
        return new TopicOperation("S", string);
    }

    public static TopicOperation unsubscribe(@NonNull String string) {
        return new TopicOperation("U", string);
    }

    @Nullable
    static TopicOperation from(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String[] stringArray = string.split("!", -1);
        if (stringArray.length != 2) {
            return null;
        }
        return new TopicOperation(stringArray[0], stringArray[1]);
    }

    public final String getTopic() {
        return this.topic;
    }

    public final String getOperation() {
        return this.operation;
    }

    public final String serialize() {
        return this.serializedString;
    }

    public final boolean equals(@Nullable Object object) {
        if (!(object instanceof TopicOperation)) {
            return false;
        }
        TopicOperation topicOperation = (TopicOperation)object;
        return this.topic.equals(topicOperation.topic) && this.operation.equals(topicOperation.operation);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.operation, this.topic});
    }
}

