/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.datatransport.TransportFactory;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.events.Event;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.Metadata;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.messaging.FcmExecutors;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$0;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$1;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$2;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$3;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$4;
import com.google.firebase.messaging.FirebaseMessaging$$Lambda$5;
import com.google.firebase.messaging.FirebaseMessaging$AutoInit$$Lambda$0;
import com.google.firebase.messaging.FirebaseMessaging$AutoInit$$Lambda$1;
import com.google.firebase.messaging.FirebaseMessaging$AutoInit$$Lambda$2;
import com.google.firebase.messaging.MessagingAnalytics;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.TopicsSubscriber;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

public class FirebaseMessaging {
    @Deprecated
    public static final String INSTANCE_ID_SCOPE = "FCM";
    private final Context context;
    private final FirebaseApp firebaseApp;
    private final FirebaseInstanceId iid;
    private final AutoInit autoInit;
    private final Executor fileIoExecutor;
    private final Task<TopicsSubscriber> topicsSubscriberTask;
    @Nullable
    @SuppressLint(value={"FirebaseUnknownNullness"})
    @VisibleForTesting
    static TransportFactory transportFactory;

    @NonNull
    public static synchronized FirebaseMessaging getInstance() {
        return FirebaseMessaging.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    @NonNull
    static synchronized FirebaseMessaging getInstance(@NonNull FirebaseApp firebaseApp) {
        FirebaseMessaging firebaseMessaging = (FirebaseMessaging)firebaseApp.get(FirebaseMessaging.class);
        Preconditions.checkNotNull((Object)firebaseMessaging, (Object)"Firebase Messaging component is not present");
        return firebaseMessaging;
    }

    FirebaseMessaging(FirebaseApp firebaseApp, FirebaseInstanceId firebaseInstanceId, Provider<UserAgentPublisher> provider, Provider<HeartBeatInfo> provider2, FirebaseInstallationsApi firebaseInstallationsApi, @Nullable TransportFactory transportFactory, Subscriber subscriber) {
        try {
            Class.forName("com.google.firebase.iid.FirebaseInstanceIdReceiver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("FirebaseMessaging and FirebaseInstanceId versions not compatible. Update to latest version of firebase-messaging.");
        }
        FirebaseMessaging.transportFactory = transportFactory;
        this.firebaseApp = firebaseApp;
        this.iid = firebaseInstanceId;
        this.autoInit = new AutoInit(subscriber);
        this.context = firebaseApp.getApplicationContext();
        this.fileIoExecutor = FcmExecutors.newInitExecutor();
        this.fileIoExecutor.execute(new FirebaseMessaging$$Lambda$0(this, firebaseInstanceId));
        this.topicsSubscriberTask = TopicsSubscriber.createInstance(firebaseApp, firebaseInstanceId, new Metadata(this.context), provider, provider2, firebaseInstallationsApi, this.context, FcmExecutors.newTopicsSyncExecutor());
        this.topicsSubscriberTask.addOnSuccessListener(FcmExecutors.newTopicsSyncTriggerExecutor(), (OnSuccessListener)new FirebaseMessaging$$Lambda$1(this));
    }

    public boolean isAutoInitEnabled() {
        return this.autoInit.isEnabled();
    }

    public void setAutoInitEnabled(boolean bl) {
        this.autoInit.setEnabled(bl);
    }

    @NonNull
    public boolean deliveryMetricsExportToBigQueryEnabled() {
        return MessagingAnalytics.deliveryMetricsExportToBigQueryEnabled();
    }

    public void setDeliveryMetricsExportToBigQuery(boolean bl) {
        MessagingAnalytics.setDeliveryMetricsExportToBigQuery(bl);
    }

    @NonNull
    public Task<String> getToken() {
        return this.iid.getInstanceId().continueWith(FirebaseMessaging$$Lambda$2.$instance);
    }

    @NonNull
    public Task<Void> deleteToken() {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        FcmExecutors.newNetworkIOExecutor().execute(new FirebaseMessaging$$Lambda$3(this, taskCompletionSource));
        return taskCompletionSource.getTask();
    }

    @NonNull
    public Task<Void> subscribeToTopic(@NonNull String string) {
        return this.topicsSubscriberTask.onSuccessTask((SuccessContinuation)new FirebaseMessaging$$Lambda$4(string));
    }

    @NonNull
    public Task<Void> unsubscribeFromTopic(@NonNull String string) {
        return this.topicsSubscriberTask.onSuccessTask((SuccessContinuation)new FirebaseMessaging$$Lambda$5(string));
    }

    public void send(@NonNull RemoteMessage remoteMessage) {
        if (TextUtils.isEmpty((CharSequence)remoteMessage.getTo())) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        Intent intent2 = new Intent();
        intent2.setPackage("com.google.example.invalidpackage");
        intent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)intent2, (int)0));
        intent.setPackage("com.google.android.gms");
        remoteMessage.populateSendMessageIntent(intent);
        this.context.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    @Nullable
    public static TransportFactory getTransportFactory() {
        return transportFactory;
    }

    static final /* synthetic */ Task lambda$unsubscribeFromTopic$5$FirebaseMessaging(String string, TopicsSubscriber topicsSubscriber) throws Exception {
        return topicsSubscriber.unsubscribeFromTopic(string);
    }

    static final /* synthetic */ Task lambda$subscribeToTopic$4$FirebaseMessaging(String string, TopicsSubscriber topicsSubscriber) throws Exception {
        return topicsSubscriber.subscribeToTopic(string);
    }

    final /* synthetic */ void lambda$deleteToken$3$FirebaseMessaging(TaskCompletionSource taskCompletionSource) {
        try {
            this.iid.deleteToken(Metadata.getDefaultSenderId((FirebaseApp)this.firebaseApp), INSTANCE_ID_SCOPE);
            taskCompletionSource.setResult(null);
            return;
        }
        catch (Exception exception) {
            taskCompletionSource.setException(exception);
            return;
        }
    }

    static final /* synthetic */ String lambda$getToken$2$FirebaseMessaging(Task task) throws Exception {
        return ((InstanceIdResult)task.getResult()).getToken();
    }

    final /* synthetic */ void lambda$new$1$FirebaseMessaging(TopicsSubscriber topicsSubscriber) {
        if (this.isAutoInitEnabled()) {
            topicsSubscriber.startTopicsSyncIfNecessary();
        }
    }

    final /* synthetic */ void lambda$new$0$FirebaseMessaging(FirebaseInstanceId firebaseInstanceId) {
        if (this.autoInit.isEnabled()) {
            firebaseInstanceId.getToken();
        }
    }

    private class AutoInit {
        private final Subscriber subscriber;
        @GuardedBy(value="this")
        private boolean initialized;
        @GuardedBy(value="this")
        @Nullable
        private EventHandler<DataCollectionDefaultChange> dataCollectionDefaultChangeEventHandler;
        @GuardedBy(value="this")
        @Nullable
        private Boolean autoInitEnabled;

        AutoInit(Subscriber subscriber) {
            this.subscriber = subscriber;
        }

        synchronized void initialize() {
            if (this.initialized) {
                return;
            }
            this.autoInitEnabled = this.readEnabled();
            if (this.autoInitEnabled == null) {
                this.dataCollectionDefaultChangeEventHandler = new FirebaseMessaging$AutoInit$$Lambda$0(this);
                this.subscriber.subscribe(DataCollectionDefaultChange.class, this.dataCollectionDefaultChangeEventHandler);
            }
            this.initialized = true;
        }

        synchronized boolean isEnabled() {
            this.initialize();
            if (this.autoInitEnabled != null) {
                return this.autoInitEnabled;
            }
            return FirebaseMessaging.this.firebaseApp.isDataCollectionDefaultEnabled();
        }

        synchronized void setEnabled(boolean bl) {
            this.initialize();
            if (this.dataCollectionDefaultChangeEventHandler != null) {
                this.subscriber.unsubscribe(DataCollectionDefaultChange.class, this.dataCollectionDefaultChangeEventHandler);
                this.dataCollectionDefaultChangeEventHandler = null;
            }
            SharedPreferences.Editor editor = FirebaseMessaging.this.firebaseApp.getApplicationContext().getSharedPreferences("com.google.firebase.messaging", 0).edit();
            editor.putBoolean("auto_init", bl);
            editor.apply();
            if (bl) {
                FirebaseMessaging.this.fileIoExecutor.execute(new FirebaseMessaging$AutoInit$$Lambda$1(this));
            }
            this.autoInitEnabled = bl;
        }

        @Nullable
        private Boolean readEnabled() {
            Context context = FirebaseMessaging.this.firebaseApp.getApplicationContext();
            SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.firebase.messaging", 0);
            if (sharedPreferences.contains("auto_init")) {
                return sharedPreferences.getBoolean("auto_init", false);
            }
            try {
                ApplicationInfo applicationInfo;
                PackageManager packageManager = context.getPackageManager();
                if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey("firebase_messaging_auto_init_enabled")) {
                    return applicationInfo.metaData.getBoolean("firebase_messaging_auto_init_enabled");
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            return null;
        }

        final /* synthetic */ void lambda$setEnabled$2$FirebaseMessaging$AutoInit() {
            FirebaseMessaging.this.iid.getToken();
        }

        final /* synthetic */ void lambda$initialize$1$FirebaseMessaging$AutoInit(Event event) {
            if (this.isEnabled()) {
                FirebaseMessaging.this.fileIoExecutor.execute(new FirebaseMessaging$AutoInit$$Lambda$2(this));
            }
        }

        final /* synthetic */ void lambda$initialize$0$FirebaseMessaging$AutoInit() {
            FirebaseMessaging.this.iid.getToken();
        }
    }
}

