/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.res.Resources;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.MissingFormatArgumentException;
import org.json.JSONArray;
import org.json.JSONException;

public final class zzt {
    @NonNull
    private final Bundle zza;

    public zzt(@NonNull Bundle bundle) {
        if (bundle == null) {
            throw new NullPointerException("data");
        }
        this.zza = new Bundle(bundle);
    }

    public final String zza(String string) {
        String string2;
        String string3 = string;
        zzt zzt2 = this;
        return this.zza.getString(!zzt2.zza.containsKey(string3) && string3.startsWith("gcm.n.") && zzt2.zza.containsKey(string2 = zzt.zzi(string3)) ? string2 : string3);
    }

    public final boolean zzb(String string) {
        String string2 = this.zza(string);
        return "1".equals(string2) || Boolean.parseBoolean(string2);
    }

    public final Integer zzc(String string) {
        String string2 = this.zza(string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                String string3 = zzt.zzh(string);
                Log.w((String)"NotificationParams", (String)new StringBuilder(38 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Couldn't parse value of ").append(string3).append("(").append(string2).append(") into an int").toString());
            }
        }
        return null;
    }

    public final Long zzd(String string) {
        String string2 = this.zza(string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                String string3 = zzt.zzh(string);
                Log.w((String)"NotificationParams", (String)new StringBuilder(38 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Couldn't parse value of ").append(string3).append("(").append(string2).append(") into a long").toString());
            }
        }
        return null;
    }

    @Nullable
    public final String zze(String string) {
        String string2 = String.valueOf(string);
        String string3 = String.valueOf("_loc_key");
        return this.zza(string3.length() != 0 ? string2.concat(string3) : new String(string2));
    }

    @Nullable
    public final Object[] zzf(String string) {
        String string2 = String.valueOf(string);
        String string3 = String.valueOf("_loc_args");
        JSONArray jSONArray = this.zzg(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        if (jSONArray == null) {
            return null;
        }
        Object[] objectArray = new String[jSONArray.length()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = jSONArray.optString(i);
        }
        return objectArray;
    }

    @Nullable
    private final JSONArray zzg(String string) {
        String string2 = this.zza(string);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return new JSONArray(string2);
            }
            catch (JSONException jSONException) {
                String string3 = zzt.zzh(string);
                Log.w((String)"NotificationParams", (String)new StringBuilder(50 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Malformed JSON for key ").append(string3).append(": ").append(string2).append(", falling back to default").toString());
            }
        }
        return null;
    }

    private static String zzh(String string) {
        if (string.startsWith("gcm.n.")) {
            return string.substring(6);
        }
        return string;
    }

    @Nullable
    public final Uri zza() {
        String string = this.zza("gcm.n.link_android");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = this.zza("gcm.n.link");
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return Uri.parse((String)string);
        }
        return null;
    }

    @Nullable
    public final String zzb() {
        String string = this.zza("gcm.n.sound2");
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = this.zza("gcm.n.sound");
        }
        return string;
    }

    @Nullable
    public final long[] zzc() {
        JSONArray jSONArray = this.zzg("gcm.n.vibrate_timings");
        if (jSONArray == null) {
            return null;
        }
        try {
            if (jSONArray.length() <= 1) {
                throw new JSONException("vibrateTimings have invalid length");
            }
            long[] lArray = new long[jSONArray.length()];
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = jSONArray.optLong(i);
            }
            return lArray;
        }
        catch (NumberFormatException | JSONException throwable) {
            String string = String.valueOf(jSONArray);
            Log.w((String)"NotificationParams", (String)new StringBuilder(74 + String.valueOf(string).length()).append("User defined vibrateTimings is invalid: ").append(string).append(". Skipping setting vibrateTimings.").toString());
            return null;
        }
    }

    @Nullable
    final int[] zzd() {
        JSONArray jSONArray = this.zzg("gcm.n.light_settings");
        if (jSONArray == null) {
            return null;
        }
        int[] nArray = new int[3];
        try {
            if (jSONArray.length() != 3) {
                throw new JSONException("lightSettings don't have all three fields");
            }
            int n = Color.parseColor((String)jSONArray.optString(0));
            if (n == -16777216) {
                throw new IllegalArgumentException("Transparent color is invalid");
            }
            nArray[0] = n;
            nArray[1] = jSONArray.optInt(1);
            nArray[2] = jSONArray.optInt(2);
            return nArray;
        }
        catch (JSONException jSONException) {
            String string = String.valueOf(jSONArray);
            Log.w((String)"NotificationParams", (String)new StringBuilder(58 + String.valueOf(string).length()).append("LightSettings is invalid: ").append(string).append(". Skipping setting LightSettings").toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = String.valueOf(jSONArray);
            String string2 = illegalArgumentException.getMessage();
            Log.w((String)"NotificationParams", (String)new StringBuilder(60 + String.valueOf(string).length() + String.valueOf(string2).length()).append("LightSettings is invalid: ").append(string).append(". ").append(string2).append(". Skipping setting LightSettings").toString());
        }
        return null;
    }

    public final Bundle zze() {
        Bundle bundle = new Bundle(this.zza);
        Iterator iterator = this.zza.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = (String)iterator.next();
            if (!(string.startsWith("google.c.") || string2.startsWith("gcm.n.") || string2.startsWith("gcm.notification."))) continue;
            bundle.remove(string);
        }
        return bundle;
    }

    public final Bundle zzf() {
        Bundle bundle = new Bundle(this.zza);
        Iterator iterator = this.zza.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = (String)iterator.next();
            if (string.startsWith("google.c.a.") || string2.equals("from")) continue;
            bundle.remove(string);
        }
        return bundle;
    }

    @Nullable
    private final String zzb(Resources resources, String string, String string2) {
        String string3 = this.zze(string2);
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return null;
        }
        int n = resources.getIdentifier(string3, "string", string);
        if (n == 0) {
            String string4 = String.valueOf(string2);
            String string5 = String.valueOf("_loc_key");
            String string6 = zzt.zzh(string5.length() != 0 ? string4.concat(string5) : new String(string4));
            Log.w((String)"NotificationParams", (String)new StringBuilder(49 + String.valueOf(string6).length() + String.valueOf(string2).length()).append(string6).append(" resource not found: ").append(string2).append(" Default value will be used.").toString());
            return null;
        }
        Object[] objectArray = this.zzf(string2);
        if (objectArray == null) {
            return resources.getString(n);
        }
        try {
            return resources.getString(n, objectArray);
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            String string7 = zzt.zzh(string2);
            String string8 = Arrays.toString(objectArray);
            Log.w((String)"NotificationParams", (String)new StringBuilder(58 + String.valueOf(string7).length() + String.valueOf(string8).length()).append("Missing format argument for ").append(string7).append(": ").append(string8).append(" Default value will be used.").toString(), (Throwable)missingFormatArgumentException);
            return null;
        }
    }

    public final String zza(Resources resources, String string, String string2) {
        String string3 = this.zza(string2);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            return string3;
        }
        return this.zzb(resources, string, string2);
    }

    public static boolean zza(Bundle bundle) {
        return "1".equals(bundle.getString("gcm.n.e")) || "1".equals(bundle.getString(zzt.zzi("gcm.n.e")));
    }

    private static String zzi(String string) {
        if (!string.startsWith("gcm.n.")) {
            return string;
        }
        return string.replace("gcm.n.", "gcm.notification.");
    }
}

