/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_messaging;

import android.app.PendingIntent;
import android.content.Intent;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.firebase_messaging.zzq;
import com.google.android.gms.internal.firebase_messaging.zzs;
import com.google.android.gms.internal.firebase_messaging.zzz;
import java.util.Arrays;
import java.util.MissingFormatArgumentException;

public final class zzaa
extends zzz {
    private final zzs zzfb;
    private final zzq zzfc;

    public zzaa(zzs zzs2, zzq zzq2) {
        this.zzfb = zzs2;
        this.zzfc = zzq2;
    }

    @Override
    @Nullable
    public final CharSequence zzbf() {
        String string = this.zzs("gcm.n.body");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        String string2 = this.zzt("gcm.n.body");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        return null;
    }

    @Override
    @Nullable
    public final CharSequence getTitle() {
        String string = this.zzs("gcm.n.title");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        String string2 = this.zzt("gcm.n.title");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        CharSequence charSequence = this.zzfb.getAppLabel();
        if (!TextUtils.isEmpty((CharSequence)charSequence)) {
            return charSequence;
        }
        return "";
    }

    @Override
    @Nullable
    public final String getTag() {
        String string = this.zzs("gcm.n.tag");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        String string2 = this.zzfb.zzbd();
        long l = SystemClock.uptimeMillis();
        return new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(":").append(l).toString();
    }

    @Override
    @Nullable
    public final String getChannelId() {
        String string;
        if (!PlatformVersion.isAtLeastO()) {
            return null;
        }
        if (this.zzfb.zzbc() < 26) {
            return null;
        }
        String string2 = this.zzs("gcm.n.android_channel_id");
        if (this.zzfb.zzl(string2)) {
            return string2;
        }
        String string3 = "com.google.firebase.messaging.default_notification_channel_id";
        if (!TextUtils.isEmpty((CharSequence)"com.google.firebase.messaging.default_notification_channel_id") && this.zzfb.zzl(string = this.zzfb.zzaz().getString(string3))) {
            return string;
        }
        string = this.zzfb.zzat();
        if (this.zzfb.zzl(string)) {
            return string;
        }
        return null;
    }

    @Override
    @Nullable
    public final Integer zzbg() {
        Integer n;
        int n2;
        Object object;
        String string = this.zzs("gcm.n.color");
        if (!TextUtils.isEmpty((CharSequence)string) && (object = zzaa.zzb(string)) != null) {
            return object;
        }
        object = "com.google.firebase.messaging.default_notification_color";
        if (!TextUtils.isEmpty((CharSequence)"com.google.firebase.messaging.default_notification_color") && (n2 = this.zzfb.zzaz().getInt((String)object, 0)) != 0 && (n = this.zzfb.zzb(n2)) != null) {
            return n;
        }
        return null;
    }

    private static Integer zzb(CharSequence charSequence) {
        try {
            return Color.parseColor((String)String.valueOf(charSequence));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    @Nullable
    public final PendingIntent zzbh() {
        String string;
        Intent intent;
        Object object;
        Intent intent2;
        zzaa zzaa2 = this;
        String string2 = zzaa2.zzs("gcm.n.click_action");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            String string3 = string2;
            zzaa zzaa3 = zzaa2;
            intent2 = new Intent(string3).setPackage(zzaa3.zzfb.getPackageName()).setFlags(0x10000000);
        } else {
            object = zzaa2.zzs("gcm.n.link_android");
            intent2 = !TextUtils.isEmpty((CharSequence)object) ? zzaa2.zzr((String)object) : (intent = !TextUtils.isEmpty((CharSequence)(string = zzaa2.zzs("gcm.n.link"))) ? zzaa2.zzr(string) : zzaa2.zzfb.zzba());
        }
        if (intent2 == null) {
            return null;
        }
        intent.addFlags(0x4000000);
        zzaa2 = this.zzfb.getData();
        string2 = new Bundle((Bundle)zzaa2);
        object = string2.keySet().iterator();
        while (object.hasNext()) {
            string = (String)object.next();
            if (string == null || !string.startsWith("google.c.") && !string.startsWith("gcm.n.") && !string.startsWith("gcm.notification.")) continue;
            object.remove();
        }
        intent.putExtras((Bundle)string2);
        return this.zzfb.zze(intent);
    }

    @Override
    @Nullable
    public final PendingIntent zzbi() {
        return this.zzfb.zzau();
    }

    private final Intent zzr(String string) {
        return new Intent("android.intent.action.VIEW").setPackage(this.zzfb.getPackageName()).setData(Uri.parse((String)string));
    }

    @Override
    @Nullable
    public final Integer zzbj() {
        int n;
        String[] stringArray;
        String string = this.zzs("gcm.n.icon");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringArray = new String[]{"drawable", "mipmap"};
            for (int i = 0; i < 2; ++i) {
                String string2 = stringArray[i];
                int n2 = this.zzfb.zzay().getIdentifier(string, string2, this.zzfb.getPackageName());
                if (!this.zze(n2)) continue;
                return n2;
            }
            Log.w((String)this.zzfc.zzeo, (String)new StringBuilder(61 + String.valueOf(string).length()).append("Icon resource ").append(string).append(" not found. Notification will use default icon.").toString());
        }
        stringArray = "com.google.firebase.messaging.default_notification_icon";
        if (!TextUtils.isEmpty((CharSequence)"com.google.firebase.messaging.default_notification_icon") && this.zze(n = this.zzfb.zzaz().getInt((String)stringArray, 0))) {
            return n;
        }
        n = this.zzfb.zzbb();
        if (this.zze(n)) {
            return n;
        }
        return 17301651;
    }

    private final boolean zze(int n) {
        return n != 0 && this.zzfc.zza(this.zzfb.zzay(), n);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public final Uri getSound() {
        block5: {
            block4: {
                var3_1 = this;
                var4_2 = var3_1.zzs("gcm.n.sound2");
                var1_3 = TextUtils.isEmpty((CharSequence)var4_2) == false ? var4_2 : var3_1.zzs("gcm.n.sound");
                if (TextUtils.isEmpty((CharSequence)var1_3)) {
                    return null;
                }
                var4_2 = var1_3;
                var3_1 = this;
                if (!TextUtils.isEmpty((CharSequence)var4_2)) break block4;
                v0 = null;
                break block5;
            }
            if ("default".equals(var4_2)) ** GOTO lbl-1000
            var7_4 = var4_2;
            var6_5 = var3_1;
            if (var6_5.zzfb.zzay().getIdentifier(var7_4, "raw", var6_5.zzfb.getPackageName()) != 0) {
                var5_6 = var3_1.zzfb.getPackageName();
                v0 = Uri.parse((String)new StringBuilder(24 + String.valueOf(var5_6).length() + String.valueOf(var4_2).length()).append("android.resource://").append(var5_6).append("/raw/").append(var4_2).toString());
            } else lbl-1000:
            // 2 sources

            {
                v0 = var2_7 = RingtoneManager.getDefaultUri((int)2);
            }
        }
        if (v0 != null) {
            return var2_7;
        }
        return RingtoneManager.getDefaultUri((int)2);
    }

    private final String zzs(String string) {
        String string2 = this.zzfb.getData().getString(string);
        if (string2 != null) {
            return string2;
        }
        return this.zzfb.getData().getString(string.replace("gcm.n.", "gcm.notification."));
    }

    private final String zzt(String string) {
        String string2 = String.valueOf(string);
        String string3 = String.valueOf("_loc_key");
        String string4 = this.zzs(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        if (TextUtils.isEmpty((CharSequence)string4)) {
            return null;
        }
        int n = this.zzfb.zzay().getIdentifier(string4, "string", this.zzfb.getPackageName());
        if (n == 0) {
            String string5 = String.valueOf(string);
            String string6 = String.valueOf("_loc_key");
            String string7 = (string6.length() != 0 ? string5.concat(string6) : new String(string5)).substring(6);
            Log.w((String)this.zzfc.zzeo, (String)new StringBuilder(49 + String.valueOf(string7).length() + String.valueOf(string).length()).append(string7).append(" resource not found: ").append(string).append(" Default value will be used.").toString());
            return null;
        }
        Object[] objectArray = this.zzfc.zzn(string);
        if (objectArray == null) {
            return this.zzfb.zzay().getString(n);
        }
        try {
            return this.zzfb.zzay().getString(n, objectArray);
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            String string8 = Arrays.toString(objectArray);
            Log.w((String)this.zzfc.zzeo, (String)new StringBuilder(58 + String.valueOf(string).length() + String.valueOf(string8).length()).append("Missing format argument for ").append(string).append(": ").append(string8).append(" Default value will be used.").toString(), (Throwable)missingFormatArgumentException);
            return null;
        }
    }
}

