/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.RemoteMessage;
import java.util.regex.Pattern;

public class FirebaseMessaging {
    public static final String INSTANCE_ID_SCOPE = "FCM";
    private static final Pattern zzbsq = Pattern.compile("[a-zA-Z0-9-_.~%]{1,900}");
    private static FirebaseMessaging zzbsr;
    private final FirebaseInstanceId zzbse;

    public static synchronized FirebaseMessaging getInstance() {
        if (zzbsr == null) {
            zzbsr = new FirebaseMessaging(FirebaseInstanceId.getInstance());
        }
        return zzbsr;
    }

    private FirebaseMessaging(FirebaseInstanceId firebaseInstanceId) {
        this.zzbse = firebaseInstanceId;
    }

    public boolean isAutoInitEnabled() {
        return this.zzbse.zzso();
    }

    public void setAutoInitEnabled(boolean bl) {
        this.zzbse.zzv(bl);
    }

    public void subscribeToTopic(String string) {
        if (string != null && string.startsWith("/topics/")) {
            Log.w((String)"FirebaseMessaging", (String)"Format /topics/topic-name is deprecated. Only 'topic-name' should be used in subscribeToTopic.");
            string = string.substring(8);
        }
        if (string == null || !zzbsq.matcher(string).matches()) {
            String string2 = string;
            throw new IllegalArgumentException(new StringBuilder(78 + String.valueOf(string2).length()).append("Invalid topic name: ").append(string2).append(" does not match the allowed format [a-zA-Z0-9-_.~%]{1,900}").toString());
        }
        String string3 = String.valueOf("S!");
        String string4 = String.valueOf(string);
        this.zzbse.zzev(string4.length() != 0 ? string3.concat(string4) : new String(string3));
    }

    public void unsubscribeFromTopic(String string) {
        if (string != null && string.startsWith("/topics/")) {
            Log.w((String)"FirebaseMessaging", (String)"Format /topics/topic-name is deprecated. Only 'topic-name' should be used in unsubscribeFromTopic.");
            string = string.substring(8);
        }
        if (string == null || !zzbsq.matcher(string).matches()) {
            String string2 = string;
            throw new IllegalArgumentException(new StringBuilder(78 + String.valueOf(string2).length()).append("Invalid topic name: ").append(string2).append(" does not match the allowed format [a-zA-Z0-9-_.~%]{1,900}").toString());
        }
        String string3 = String.valueOf("U!");
        String string4 = String.valueOf(string);
        this.zzbse.zzev(string4.length() != 0 ? string3.concat(string4) : new String(string3));
    }

    public void send(RemoteMessage remoteMessage) {
        if (TextUtils.isEmpty((CharSequence)remoteMessage.getTo())) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Context context = FirebaseApp.getInstance().getApplicationContext();
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        Intent intent2 = new Intent();
        intent2.setPackage("com.google.example.invalidpackage");
        intent.putExtra("app", (Parcelable)PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0));
        intent.setPackage("com.google.android.gms");
        Intent intent3 = intent;
        RemoteMessage remoteMessage2 = remoteMessage;
        intent3.putExtras(remoteMessage2.zzafw);
        context.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }
}

