/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.zzbfm;
import com.google.android.gms.internal.zzbfp;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zze;
import com.google.firebase.messaging.zzf;
import java.util.Map;

public final class RemoteMessage
extends zzbfm {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zzf();
    Bundle mBundle;
    private Map<String, String> zzdpq;
    private Notification zzoah;

    RemoteMessage(Bundle bundle) {
        this.mBundle = bundle;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        RemoteMessage remoteMessage = this;
        int n2 = zzbfp.zze((Parcel)parcel2);
        zzbfp.zza((Parcel)parcel2, (int)2, (Bundle)remoteMessage.mBundle, (boolean)false);
        zzbfp.zzai((Parcel)parcel2, (int)n2);
    }

    @Nullable
    public final String getFrom() {
        return this.mBundle.getString("from");
    }

    @Nullable
    public final String getTo() {
        return this.mBundle.getString("google.to");
    }

    public final Map<String, String> getData() {
        if (this.zzdpq == null) {
            this.zzdpq = new ArrayMap();
            for (String string2 : this.mBundle.keySet()) {
                Object object = this.mBundle.get(string2);
                if (!(object instanceof String)) continue;
                String string3 = (String)object;
                if (string2.startsWith("google.") || string2.startsWith("gcm.") || string2.equals("from") || string2.equals("message_type") || string2.equals("collapse_key")) continue;
                this.zzdpq.put(string2, string3);
            }
        }
        return this.zzdpq;
    }

    @Nullable
    public final String getCollapseKey() {
        return this.mBundle.getString("collapse_key");
    }

    @Nullable
    public final String getMessageId() {
        String string2 = this.mBundle.getString("google.message_id");
        if (string2 == null) {
            string2 = this.mBundle.getString("message_id");
        }
        return string2;
    }

    @Nullable
    public final String getMessageType() {
        return this.mBundle.getString("message_type");
    }

    public final long getSentTime() {
        Object object = this.mBundle.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string2).length()).append("Invalid sent time: ").append(string2).toString());
            }
        }
        return 0L;
    }

    public final int getTtl() {
        Object object = this.mBundle.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string2).length()).append("Invalid TTL: ").append(string2).toString());
            }
        }
        return 0;
    }

    @Nullable
    public final Notification getNotification() {
        if (this.zzoah == null && zza.zzag(this.mBundle)) {
            this.zzoah = new Notification(this.mBundle, null);
        }
        return this.zzoah;
    }

    public static class Notification {
        private final String zzemt;
        private final String zzoai;
        private final String[] zzoaj;
        private final String zzbtu;
        private final String zzoak;
        private final String[] zzoal;
        private final String zzoam;
        private final String zzoan;
        private final String mTag;
        private final String zzoao;
        private final String zzoap;
        private final Uri zzoaq;

        private Notification(Bundle bundle) {
            this.zzemt = zza.zze(bundle, "gcm.n.title");
            this.zzoai = zza.zzh(bundle, "gcm.n.title");
            this.zzoaj = Notification.zzk(bundle, "gcm.n.title");
            this.zzbtu = zza.zze(bundle, "gcm.n.body");
            this.zzoak = zza.zzh(bundle, "gcm.n.body");
            this.zzoal = Notification.zzk(bundle, "gcm.n.body");
            this.zzoam = zza.zze(bundle, "gcm.n.icon");
            this.zzoan = zza.zzai(bundle);
            this.mTag = zza.zze(bundle, "gcm.n.tag");
            this.zzoao = zza.zze(bundle, "gcm.n.color");
            this.zzoap = zza.zze(bundle, "gcm.n.click_action");
            this.zzoaq = zza.zzah(bundle);
        }

        private static String[] zzk(Bundle bundle, String string2) {
            Object[] objectArray = zza.zzi(bundle, string2);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String getTitle() {
            return this.zzemt;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.zzoai;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.zzoaj;
        }

        @Nullable
        public String getBody() {
            return this.zzbtu;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.zzoak;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.zzoal;
        }

        @Nullable
        public String getIcon() {
            return this.zzoam;
        }

        @Nullable
        public String getSound() {
            return this.zzoan;
        }

        @Nullable
        public String getTag() {
            return this.mTag;
        }

        @Nullable
        public String getColor() {
            return this.zzoao;
        }

        @Nullable
        public String getClickAction() {
            return this.zzoap;
        }

        @Nullable
        public Uri getLink() {
            return this.zzoaq;
        }

        /* synthetic */ Notification(Bundle bundle, zze zze2) {
            this(bundle);
        }
    }

    public static class Builder {
        private final Bundle mBundle = new Bundle();
        private final Map<String, String> zzdpq = new ArrayMap();

        public Builder(String string2) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = String.valueOf(string2);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid to: ".concat(string3) : new String("Invalid to: "));
            }
            this.mBundle.putString("google.to", string2);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzdpq.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.mBundle);
            this.mBundle.remove("from");
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string2, String string3) {
            this.zzdpq.put(string2, string3);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzdpq.clear();
            this.zzdpq.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzdpq.clear();
            return this;
        }

        public Builder setMessageId(String string2) {
            this.mBundle.putString("google.message_id", string2);
            return this;
        }

        public Builder setMessageType(String string2) {
            this.mBundle.putString("message_type", string2);
            return this;
        }

        public Builder setTtl(@IntRange(from=0L, to=86400L) int n) {
            this.mBundle.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string2) {
            this.mBundle.putString("collapse_key", string2);
            return this;
        }
    }
}

