/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.R;
import com.google.android.gms.common.util.zzt;
import com.google.firebase.iid.zzg;
import com.google.firebase.messaging.FirebaseMessagingService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.MissingFormatArgumentException;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;

class zza {
    static zza zzclI;
    private final Context mContext;
    private Bundle zzaDS;
    private Method zzclJ;
    private Method zzclK;
    private final AtomicInteger zzclL = new AtomicInteger((int)SystemClock.elapsedRealtime());

    static synchronized zza zzcy(Context context) {
        if (zzclI == null) {
            zzclI = new zza(context);
        }
        return zzclI;
    }

    static boolean zzE(Bundle bundle) {
        return "1".equals(zza.zzf(bundle, "gcm.n.e")) || zza.zzf(bundle, "gcm.n.icon") != null;
    }

    private boolean zzacc() {
        KeyguardManager keyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        if (keyguardManager.inKeyguardRestrictedInputMode()) {
            return false;
        }
        if (!zzt.zzzn()) {
            SystemClock.sleep((long)10L);
        }
        int n = Process.myPid();
        ActivityManager activityManager = (ActivityManager)this.mContext.getSystemService("activity");
        List list = activityManager.getRunningAppProcesses();
        if (list != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (runningAppProcessInfo.pid != n) continue;
                return runningAppProcessInfo.importance == 100;
            }
        }
        return false;
    }

    static String zzf(Bundle bundle, String string2) {
        String string3 = bundle.getString(string2);
        if (string3 == null) {
            string3 = bundle.getString(string2.replace("gcm.n.", "gcm.notification."));
        }
        return string3;
    }

    static String zzi(Bundle bundle, String string2) {
        String string3 = String.valueOf(string2);
        String string4 = String.valueOf("_loc_key");
        return zza.zzf(bundle, string4.length() != 0 ? string3.concat(string4) : new String(string3));
    }

    static Object[] zzj(Bundle bundle, String string2) {
        String string3 = String.valueOf(string2);
        String string4 = String.valueOf("_loc_args");
        String string5 = zza.zzf(bundle, string4.length() != 0 ? string3.concat(string4) : new String(string3));
        if (TextUtils.isEmpty((CharSequence)string5)) {
            return null;
        }
        try {
            JSONArray jSONArray = new JSONArray(string5);
            Object[] objectArray = new String[jSONArray.length()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = jSONArray.opt(i);
            }
            return objectArray;
        }
        catch (JSONException jSONException) {
            String string6 = String.valueOf(string2);
            String string7 = String.valueOf("_loc_args");
            String string8 = String.valueOf(zza.zzeA(string7.length() != 0 ? string6.concat(string7) : new String(string6)));
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(41 + String.valueOf(string8).length() + String.valueOf(string5).length()).append("Malformed ").append(string8).append(": ").append(string5).append("  Default value will be used.").toString());
            return null;
        }
    }

    @Nullable
    static Uri zzV(@NonNull Bundle bundle) {
        String string2 = zza.zzf(bundle, "gcm.n.link_android");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = zza.zzf(bundle, "gcm.n.link");
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return Uri.parse((String)string2);
        }
        return null;
    }

    private zza(Context context) {
        this.mContext = context.getApplicationContext();
    }

    boolean zzG(Bundle bundle) {
        if ("1".equals(zza.zzf(bundle, "gcm.n.noui"))) {
            return true;
        }
        if (this.zzacc()) {
            return false;
        }
        Notification notification = this.zzH(bundle);
        this.zza(zza.zzf(bundle, "gcm.n.tag"), notification);
        return true;
    }

    private Notification zzH(Bundle bundle) {
        CharSequence charSequence = this.zzk(bundle, "gcm.n.title");
        if (TextUtils.isEmpty((CharSequence)charSequence)) {
            charSequence = this.mContext.getApplicationInfo().loadLabel(this.mContext.getPackageManager());
        }
        String string2 = this.zzk(bundle, "gcm.n.body");
        int n = this.zzeB(zza.zzf(bundle, "gcm.n.icon"));
        Integer n2 = this.zzjD(zza.zzf(bundle, "gcm.n.color"));
        Uri uri = this.zzeC(zza.zzW(bundle));
        PendingIntent pendingIntent = this.zzI(bundle);
        PendingIntent pendingIntent2 = null;
        if (FirebaseMessagingService.zzZ(bundle)) {
            pendingIntent = this.zza(bundle, pendingIntent);
            pendingIntent2 = this.zzY(bundle);
        }
        if (zzt.zzzq() && this.mContext.getApplicationInfo().targetSdkVersion > 25) {
            String string3 = this.zzjE(zza.zzf(bundle, "gcm.n.android_channel_id"));
            return this.zza(charSequence, string2, n, n2, uri, pendingIntent, pendingIntent2, string3);
        }
        return this.zza(charSequence, string2, n, n2, uri, pendingIntent, pendingIntent2);
    }

    private Notification zza(CharSequence charSequence, String string2, int n, Integer n2, Uri uri, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        NotificationCompat.Builder builder = new NotificationCompat.Builder(this.mContext).setAutoCancel(true).setSmallIcon(n);
        if (!TextUtils.isEmpty((CharSequence)charSequence)) {
            builder.setContentTitle(charSequence);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            builder.setContentText((CharSequence)string2);
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)string2));
        }
        if (n2 != null) {
            builder.setColor(n2.intValue());
        }
        if (uri != null) {
            builder.setSound(uri);
        }
        if (pendingIntent != null) {
            builder.setContentIntent(pendingIntent);
        }
        if (pendingIntent2 != null) {
            builder.setDeleteIntent(pendingIntent2);
        }
        return builder.build();
    }

    @TargetApi(value=26)
    private Notification zza(CharSequence charSequence, String string2, int n, Integer n2, Uri uri, PendingIntent pendingIntent, PendingIntent pendingIntent2, String string3) {
        Notification.Builder builder = new Notification.Builder(this.mContext).setAutoCancel(true).setSmallIcon(n);
        if (!TextUtils.isEmpty((CharSequence)charSequence)) {
            builder.setContentTitle(charSequence);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            builder.setContentText((CharSequence)string2);
            builder.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)string2));
        }
        if (n2 != null) {
            builder.setColor(n2.intValue());
        }
        if (uri != null) {
            builder.setSound(uri);
        }
        if (pendingIntent != null) {
            builder.setContentIntent(pendingIntent);
        }
        if (pendingIntent2 != null) {
            builder.setDeleteIntent(pendingIntent2);
        }
        if (string3 != null) {
            try {
                if (this.zzclJ == null) {
                    this.zzclJ = builder.getClass().getMethod("setChannel", String.class);
                }
                this.zzclJ.invoke((Object)builder, string3);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)invocationTargetException);
            }
            catch (SecurityException securityException) {
                Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)securityException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)illegalArgumentException);
            }
            catch (LinkageError linkageError) {
                Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)linkageError);
            }
        }
        return builder.build();
    }

    private void zza(String string2, Notification notification) {
        if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
            Log.d((String)"FirebaseMessaging", (String)"Showing notification");
        }
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            long l = SystemClock.uptimeMillis();
            string2 = new StringBuilder(37).append("FCM-Notification:").append(l).toString();
        }
        notificationManager.notify(string2, 0, notification);
    }

    private String zzk(Bundle bundle, String string2) {
        String string3 = zza.zzf(bundle, string2);
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            return string3;
        }
        String string4 = zza.zzi(bundle, string2);
        if (TextUtils.isEmpty((CharSequence)string4)) {
            return null;
        }
        Resources resources = this.mContext.getResources();
        int n = resources.getIdentifier(string4, "string", this.mContext.getPackageName());
        if (n == 0) {
            String string5 = String.valueOf(string2);
            String string6 = String.valueOf("_loc_key");
            String string7 = String.valueOf(zza.zzeA(string6.length() != 0 ? string5.concat(string6) : new String(string5)));
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(49 + String.valueOf(string7).length() + String.valueOf(string4).length()).append(string7).append(" resource not found: ").append(string4).append(" Default value will be used.").toString());
            return null;
        }
        Object[] objectArray = zza.zzj(bundle, string2);
        if (objectArray == null) {
            return resources.getString(n);
        }
        try {
            return resources.getString(n, objectArray);
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
            String string8 = String.valueOf(Arrays.toString(objectArray));
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(58 + String.valueOf(string4).length() + String.valueOf(string8).length()).append("Missing format argument for ").append(string4).append(": ").append(string8).append(" Default value will be used.").toString(), (Throwable)missingFormatArgumentException);
            return null;
        }
    }

    private static String zzeA(String string2) {
        return string2.substring("gcm.n.".length());
    }

    private int zzeB(String string2) {
        int n;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            Resources resources = this.mContext.getResources();
            int n2 = resources.getIdentifier(string2, "drawable", this.mContext.getPackageName());
            if (n2 != 0) {
                return n2;
            }
            n2 = resources.getIdentifier(string2, "mipmap", this.mContext.getPackageName());
            if (n2 != 0) {
                return n2;
            }
            Log.w((String)"FirebaseMessaging", (String)new StringBuilder(61 + String.valueOf(string2).length()).append("Icon resource ").append(string2).append(" not found. Notification will use default icon.").toString());
        }
        if ((n = this.zzacd().getInt("com.google.firebase.messaging.default_notification_icon", 0)) == 0) {
            n = this.mContext.getApplicationInfo().icon;
        }
        if (n == 0) {
            n = 17301651;
        }
        return n;
    }

    private Integer zzjD(String string2) {
        int n;
        if (Build.VERSION.SDK_INT < 21) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Color.parseColor((String)string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(54 + String.valueOf(string2).length()).append("Color ").append(string2).append(" not valid. Notification will use default color.").toString());
            }
        }
        if ((n = this.zzacd().getInt("com.google.firebase.messaging.default_notification_color", 0)) != 0) {
            try {
                return ContextCompat.getColor((Context)this.mContext, (int)n);
            }
            catch (Resources.NotFoundException notFoundException) {
                Log.w((String)"FirebaseMessaging", (String)"Cannot find the color resource referenced in AndroidManifest.");
            }
        }
        return null;
    }

    @TargetApi(value=26)
    private String zzjE(String string2) {
        if (!zzt.zzzq()) {
            return null;
        }
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService(NotificationManager.class);
        try {
            String string3;
            if (this.zzclK == null) {
                this.zzclK = notificationManager.getClass().getMethod("getNotificationChannel", String.class);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                if (this.zzclK.invoke((Object)notificationManager, string2) != null) {
                    return string2;
                }
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(122 + String.valueOf(string2).length()).append("Notification Channel requested (").append(string2).append(") has not been created by the app. Manifest configuration, or default, value will be used.").toString());
            }
            if (!TextUtils.isEmpty((CharSequence)(string3 = this.zzacd().getString("com.google.firebase.messaging.default_notification_channel_id")))) {
                if (this.zzclK.invoke((Object)notificationManager, string3) != null) {
                    return string3;
                }
                Log.w((String)"FirebaseMessaging", (String)"Notification Channel set in AndroidManifest.xml has not been created by the app. Default value will be used.");
            } else {
                Log.w((String)"FirebaseMessaging", (String)"Missing Default Notification Channel metadata in AndroidManifest. Default value will be used.");
            }
            Object object = this.zzclK.invoke((Object)notificationManager, "fcm_fallback_notification_channel");
            if (object == null) {
                Class<?> clazz = Class.forName("android.app.NotificationChannel");
                Object obj = clazz.getConstructor(String.class, CharSequence.class, Integer.TYPE).newInstance("fcm_fallback_notification_channel", this.mContext.getString(R.string.fcm_fallback_notification_channel_label), 3);
                Method method = notificationManager.getClass().getMethod("createNotificationChannel", clazz);
                method.invoke((Object)notificationManager, obj);
            }
            return "fcm_fallback_notification_channel";
        }
        catch (InstantiationException instantiationException) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)classNotFoundException);
        }
        catch (SecurityException securityException) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)illegalArgumentException);
        }
        catch (LinkageError linkageError) {
            Log.e((String)"FirebaseMessaging", (String)"Error while setting the notification channel", (Throwable)linkageError);
        }
        return null;
    }

    static String zzW(Bundle bundle) {
        String string2 = zza.zzf(bundle, "gcm.n.sound2");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = zza.zzf(bundle, "gcm.n.sound");
        }
        return string2;
    }

    private Uri zzeC(String string2) {
        Resources resources;
        int n;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if (!"default".equals(string2) && (n = (resources = this.mContext.getResources()).getIdentifier(string2, "raw", this.mContext.getPackageName())) != 0) {
            String string3 = String.valueOf("android.resource://");
            String string4 = String.valueOf(this.mContext.getPackageName());
            return Uri.parse((String)new StringBuilder(5 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string2).length()).append(string3).append(string4).append("/raw/").append(string2).toString());
        }
        return RingtoneManager.getDefaultUri((int)2);
    }

    private PendingIntent zzI(Bundle bundle) {
        Intent intent = this.zzX(bundle);
        if (intent == null) {
            return null;
        }
        intent.addFlags(0x4000000);
        bundle = new Bundle(bundle);
        FirebaseMessagingService.zzD(bundle);
        intent.putExtras(bundle);
        for (String string2 : bundle.keySet()) {
            if (!string2.startsWith("gcm.n.") && !string2.startsWith("gcm.notification.")) continue;
            intent.removeExtra(string2);
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)this.zzGP(), (Intent)intent, (int)0x40000000);
    }

    private Intent zzX(Bundle bundle) {
        String string2 = zza.zzf(bundle, "gcm.n.click_action");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            Intent intent = new Intent(string2);
            intent.setPackage(this.mContext.getPackageName());
            intent.setFlags(0x10000000);
            return intent;
        }
        Uri uri = zza.zzV(bundle);
        if (uri != null) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setPackage(this.mContext.getPackageName());
            intent.setData(uri);
            return intent;
        }
        PackageManager packageManager = this.mContext.getPackageManager();
        Intent intent = packageManager.getLaunchIntentForPackage(this.mContext.getPackageName());
        if (intent == null) {
            Log.w((String)"FirebaseMessaging", (String)"No activity found to launch app");
        }
        return intent;
    }

    private PendingIntent zza(Bundle bundle, PendingIntent pendingIntent) {
        Intent intent = new Intent("com.google.firebase.messaging.NOTIFICATION_OPEN");
        this.zza(intent, bundle);
        intent.putExtra("pending_intent", (Parcelable)pendingIntent);
        return zzg.zzb((Context)this.mContext, (int)this.zzGP(), (Intent)intent, (int)0x40000000);
    }

    private PendingIntent zzY(Bundle bundle) {
        Intent intent = new Intent("com.google.firebase.messaging.NOTIFICATION_DISMISS");
        this.zza(intent, bundle);
        return zzg.zzb((Context)this.mContext, (int)this.zzGP(), (Intent)intent, (int)0x40000000);
    }

    private void zza(Intent intent, Bundle bundle) {
        for (String string2 : bundle.keySet()) {
            if (!string2.startsWith("google.c.a.") && !string2.equals("from")) continue;
            intent.putExtra(string2, bundle.getString(string2));
        }
    }

    private int zzGP() {
        return this.zzclL.incrementAndGet();
    }

    private Bundle zzacd() {
        if (this.zzaDS != null) {
            return this.zzaDS;
        }
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        if (applicationInfo != null && applicationInfo.metaData != null) {
            this.zzaDS = applicationInfo.metaData;
            return this.zzaDS;
        }
        return Bundle.EMPTY;
    }
}

