/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.messaging.zza;
import com.google.firebase.messaging.zze;
import java.util.Map;

public final class RemoteMessage
extends com.google.android.gms.common.internal.safeparcel.zza {
    public static final Parcelable.Creator<RemoteMessage> CREATOR = new zze();
    Bundle zzaic;
    private Map<String, String> zzacc;
    private Notification zzclO;

    RemoteMessage(Bundle bundle) {
        this.zzaic = bundle;
    }

    void zzK(Intent intent) {
        intent.putExtras(this.zzaic);
    }

    public void writeToParcel(Parcel parcel, int n) {
        zze.zza(this, parcel, n);
    }

    public String getFrom() {
        return this.zzaic.getString("from");
    }

    public String getTo() {
        return this.zzaic.getString("google.to");
    }

    public Map<String, String> getData() {
        if (this.zzacc == null) {
            this.zzacc = new ArrayMap();
            for (String string2 : this.zzaic.keySet()) {
                Object object = this.zzaic.get(string2);
                if (!(object instanceof String)) continue;
                String string3 = (String)object;
                if (string2.startsWith("google.") || string2.startsWith("gcm.") || string2.equals("from") || string2.equals("message_type") || string2.equals("collapse_key")) continue;
                this.zzacc.put(string2, string3);
            }
        }
        return this.zzacc;
    }

    public String getCollapseKey() {
        return this.zzaic.getString("collapse_key");
    }

    public String getMessageId() {
        String string2 = this.zzaic.getString("google.message_id");
        if (string2 == null) {
            string2 = this.zzaic.getString("message_id");
        }
        return string2;
    }

    public String getMessageType() {
        return this.zzaic.getString("message_type");
    }

    public long getSentTime() {
        Object object = this.zzaic.get("google.sent_time");
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof String) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(19 + String.valueOf(string2).length()).append("Invalid sent time: ").append(string2).toString());
            }
        }
        return 0L;
    }

    public int getTtl() {
        Object object = this.zzaic.get("google.ttl");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            try {
                return Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                String string2 = String.valueOf(object);
                Log.w((String)"FirebaseMessaging", (String)new StringBuilder(13 + String.valueOf(string2).length()).append("Invalid TTL: ").append(string2).toString());
            }
        }
        return 0;
    }

    public Notification getNotification() {
        if (this.zzclO == null && zza.zzE(this.zzaic)) {
            this.zzclO = new Notification(this.zzaic);
        }
        return this.zzclO;
    }

    public static class Notification {
        private final String zzamJ;
        private final String zzclP;
        private final String[] zzclQ;
        private final String zzGr;
        private final String zzclR;
        private final String[] zzclS;
        private final String zzclT;
        private final String zzclU;
        private final String mTag;
        private final String zzaQM;
        private final String zzclV;
        private final Uri zzclW;

        private Notification(Bundle bundle) {
            this.zzamJ = zza.zzf(bundle, "gcm.n.title");
            this.zzclP = zza.zzi(bundle, "gcm.n.title");
            this.zzclQ = this.zzl(bundle, "gcm.n.title");
            this.zzGr = zza.zzf(bundle, "gcm.n.body");
            this.zzclR = zza.zzi(bundle, "gcm.n.body");
            this.zzclS = this.zzl(bundle, "gcm.n.body");
            this.zzclT = zza.zzf(bundle, "gcm.n.icon");
            this.zzclU = zza.zzW(bundle);
            this.mTag = zza.zzf(bundle, "gcm.n.tag");
            this.zzaQM = zza.zzf(bundle, "gcm.n.color");
            this.zzclV = zza.zzf(bundle, "gcm.n.click_action");
            this.zzclW = zza.zzV(bundle);
        }

        private String[] zzl(Bundle bundle, String string2) {
            Object[] objectArray = zza.zzj(bundle, string2);
            if (objectArray == null) {
                return null;
            }
            String[] stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = String.valueOf(objectArray[i]);
            }
            return stringArray;
        }

        @Nullable
        public String getTitle() {
            return this.zzamJ;
        }

        @Nullable
        public String getTitleLocalizationKey() {
            return this.zzclP;
        }

        @Nullable
        public String[] getTitleLocalizationArgs() {
            return this.zzclQ;
        }

        @Nullable
        public String getBody() {
            return this.zzGr;
        }

        @Nullable
        public String getBodyLocalizationKey() {
            return this.zzclR;
        }

        @Nullable
        public String[] getBodyLocalizationArgs() {
            return this.zzclS;
        }

        @Nullable
        public String getIcon() {
            return this.zzclT;
        }

        @Nullable
        public String getSound() {
            return this.zzclU;
        }

        @Nullable
        public String getTag() {
            return this.mTag;
        }

        @Nullable
        public String getColor() {
            return this.zzaQM;
        }

        @Nullable
        public String getClickAction() {
            return this.zzclV;
        }

        @Nullable
        public Uri getLink() {
            return this.zzclW;
        }
    }

    public static class Builder {
        private final Bundle zzaic = new Bundle();
        private final Map<String, String> zzacc = new ArrayMap();

        public Builder(String string2) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = String.valueOf(string2);
                throw new IllegalArgumentException(string3.length() != 0 ? "Invalid to: ".concat(string3) : new String("Invalid to: "));
            }
            this.zzaic.putString("google.to", string2);
        }

        public RemoteMessage build() {
            Bundle bundle = new Bundle();
            for (Map.Entry<String, String> entry : this.zzacc.entrySet()) {
                bundle.putString(entry.getKey(), entry.getValue());
            }
            bundle.putAll(this.zzaic);
            String string2 = FirebaseInstanceId.getInstance().getToken();
            if (string2 != null) {
                this.zzaic.putString("from", string2);
            } else {
                this.zzaic.remove("from");
            }
            return new RemoteMessage(bundle);
        }

        public Builder addData(String string2, String string3) {
            this.zzacc.put(string2, string3);
            return this;
        }

        public Builder setData(Map<String, String> map) {
            this.zzacc.clear();
            this.zzacc.putAll(map);
            return this;
        }

        public Builder clearData() {
            this.zzacc.clear();
            return this;
        }

        public Builder setMessageId(String string2) {
            this.zzaic.putString("google.message_id", string2);
            return this;
        }

        public Builder setMessageType(String string2) {
            this.zzaic.putString("message_type", string2);
            return this;
        }

        public Builder setTtl(int n) {
            this.zzaic.putString("google.ttl", String.valueOf(n));
            return this;
        }

        public Builder setCollapseKey(String string2) {
            this.zzaic.putString("collapse_key", string2);
            return this;
        }
    }
}

