/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.firebase.FirebaseApp;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.zzf;
import com.google.firebase.messaging.RemoteMessage;
import java.util.regex.Pattern;

public class FirebaseMessaging {
    public static final String INSTANCE_ID_SCOPE = "FCM";
    private static final Pattern zzclI = Pattern.compile("[a-zA-Z0-9-_.~%]{1,900}");
    private static FirebaseMessaging zzclJ;
    private final FirebaseInstanceId zzclg;
    private PendingIntent zzclK;

    public static synchronized FirebaseMessaging getInstance() {
        if (zzclJ == null) {
            zzclJ = new FirebaseMessaging(FirebaseInstanceId.getInstance());
        }
        return zzclJ;
    }

    private FirebaseMessaging(FirebaseInstanceId firebaseInstanceId) {
        this.zzclg = firebaseInstanceId;
    }

    public void subscribeToTopic(String string) {
        if (string != null && string.startsWith("/topics/")) {
            Log.w((String)"FirebaseMessaging", (String)"Format /topics/topic-name is deprecated. Only 'topic-name' should be used in subscribeToTopic.");
            string = string.substring("/topics/".length());
        }
        if (string == null || !zzclI.matcher(string).matches()) {
            String string2 = string;
            String string3 = String.valueOf("[a-zA-Z0-9-_.~%]{1,900}");
            throw new IllegalArgumentException(new StringBuilder(55 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Invalid topic name: ").append(string2).append(" does not match the allowed format ").append(string3).toString());
        }
        String string4 = String.valueOf("S!");
        String string5 = String.valueOf(string);
        FirebaseInstanceId.getInstance().zzjt(string5.length() != 0 ? string4.concat(string5) : new String(string4));
    }

    public void unsubscribeFromTopic(String string) {
        if (string != null && string.startsWith("/topics/")) {
            Log.w((String)"FirebaseMessaging", (String)"Format /topics/topic-name is deprecated. Only 'topic-name' should be used in unsubscribeFromTopic.");
            string = string.substring("/topics/".length());
        }
        if (string == null || !zzclI.matcher(string).matches()) {
            String string2 = string;
            String string3 = String.valueOf("[a-zA-Z0-9-_.~%]{1,900}");
            throw new IllegalArgumentException(new StringBuilder(55 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Invalid topic name: ").append(string2).append(" does not match the allowed format ").append(string3).toString());
        }
        String string4 = String.valueOf("U!");
        String string5 = String.valueOf(string);
        FirebaseInstanceId.getInstance().zzjt(string5.length() != 0 ? string4.concat(string5) : new String(string4));
    }

    public void send(RemoteMessage remoteMessage) {
        if (TextUtils.isEmpty((CharSequence)remoteMessage.getTo())) {
            throw new IllegalArgumentException("Missing 'to'");
        }
        Context context = FirebaseApp.getInstance().getApplicationContext();
        String string = zzf.zzbA((Context)context);
        if (string == null) {
            Log.e((String)"FirebaseMessaging", (String)"Google Play services package is missing. Impossible to send message");
            return;
        }
        Intent intent = new Intent("com.google.android.gcm.intent.SEND");
        this.zzh(context, intent);
        intent.setPackage(string);
        remoteMessage.zzK(intent);
        context.sendOrderedBroadcast(intent, "com.google.android.gtalkservice.permission.GTALK_SERVICE");
    }

    private synchronized void zzh(Context context, Intent intent) {
        if (this.zzclK == null) {
            Intent intent2 = new Intent();
            intent2.setPackage("com.google.example.invalidpackage");
            this.zzclK = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent2, (int)0);
        }
        intent.putExtra("app", (Parcelable)this.zzclK);
    }
}

