/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations.lint;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.Dependencies;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.model.Variant;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001f\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0082\bJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013\u00a8\u0006\u0015"}, d2={"Lcom/google/firebase/installations/lint/IncompatibleIidVersionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "()V", "beforeCheckEachProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "catching", "block", "Lkotlin/Function0;", "getVariants", "", "Lcom/android/builder/model/Variant;", "project", "Lcom/android/tools/lint/detector/api/Project;", "isCompatibleVersion", "", "version", "", "isCompatibleVersion$customer_lint_checks", "Issues", "customer-lint-checks"})
public final class IncompatibleIidVersionDetector
extends Detector {
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue INCOMPATIBLE_IID_VERSION;
    @JvmField
    @NotNull
    public static final Issue IID_COMPATIBILITY_CHECK_FAILURE;
    public static final Issues Issues;

    public void beforeCheckEachProject(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        IncompatibleIidVersionDetector this_$iv = this;
        boolean $i$f$catching = false;
        try {
            boolean bl = false;
            for (Variant variant : this.getVariants(context.getProject())) {
                AndroidArtifact androidArtifact = variant.getMainArtifact();
                Intrinsics.checkExpressionValueIsNotNull((Object)androidArtifact, (String)"variant.mainArtifact");
                Dependencies dependencies = androidArtifact.getDependencies();
                Intrinsics.checkExpressionValueIsNotNull((Object)dependencies, (String)"variant.mainArtifact.dependencies");
                Iterator iterator = dependencies.getLibraries().iterator();
                while (iterator.hasNext()) {
                    MavenCoordinates coordinates;
                    AndroidLibrary lib;
                    AndroidLibrary androidLibrary = lib = (AndroidLibrary)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)androidLibrary, (String)"lib");
                    MavenCoordinates mavenCoordinates = coordinates = androidLibrary.getResolvedCoordinates();
                    Intrinsics.checkExpressionValueIsNotNull((Object)mavenCoordinates, (String)"coordinates");
                    if (!Intrinsics.areEqual((Object)mavenCoordinates.getGroupId(), (Object)"com.google.firebase") || !Intrinsics.areEqual((Object)coordinates.getArtifactId(), (Object)"firebase-iid")) continue;
                    String string = coordinates.getVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"coordinates.version");
                    if (this.isCompatibleVersion$customer_lint_checks(string)) continue;
                    Location location = Location.Companion.create(context.file);
                    StringBuilder stringBuilder = new StringBuilder().append("Incompatible IID version found in variant ").append(variant.getName()).append(": ");
                    String string2 = lib.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"lib.name");
                    Context.report$default((Context)context, (Issue)INCOMPATIBLE_IID_VERSION, (Location)location, (String)stringBuilder.append(StringsKt.removeSuffix((String)string2, (CharSequence)"@aar")).append(".\n").append("To resolve this issue, consider updating the build file to the latest firebase-iid version.").toString(), null, (int)8, null);
                }
            }
        }
        catch (Throwable ex$iv) {
            Context.report$default((Context)context, (Issue)IID_COMPATIBILITY_CHECK_FAILURE, (Location)Location.Companion.create(context.file), (String)("Check failed with exception: " + ex$iv), null, (int)8, null);
        }
    }

    private final List<Variant> getVariants(Project project) {
        Method variantsMethod;
        Method method;
        if (!project.isGradleProject()) {
            return CollectionsKt.emptyList();
        }
        Method method2 = method = project.getClass().getMethod("getGradleProjectModel", new Class[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"method");
        method2.setAccessible(true);
        Object model = method.invoke((Object)project, new Object[0]);
        Method method3 = variantsMethod = model.getClass().getMethod("getVariants", new Class[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)method3, (String)"variantsMethod");
        method3.setAccessible(true);
        Object object = variantsMethod.invoke(model, new Object[0]);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<com.android.builder.model.Variant>");
        }
        return (List)object;
    }

    public final boolean isCompatibleVersion$customer_lint_checks(@NotNull String version) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Object object = new char[]{'.'};
        boolean bl = false;
        int n = 3;
        Collection collection = $receiver$iv = (Collection)StringsKt.split$default((CharSequence)version, (char[])object, (boolean)bl, (int)n, (int)2, null);
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        int n2 = 20;
        String[] versionComponents = stringArray;
        object = versionComponents[0];
        int n3 = Integer.parseInt((String)object);
        if (n2 > n3) {
            return false;
        }
        n2 = 21;
        object = versionComponents[0];
        n3 = Integer.parseInt((String)object);
        if (n2 <= n3) {
            return true;
        }
        n2 = 1;
        object = versionComponents[1];
        n3 = Integer.parseInt((String)object);
        return n2 <= n3;
    }

    private final void catching(Context context, Function0<Unit> block) {
        int $i$f$catching = 0;
        try {
            block.invoke();
        }
        catch (Throwable ex) {
            Context.report$default((Context)context, (Issue)IID_COMPATIBILITY_CHECK_FAILURE, (Location)Location.Companion.create(context.file), (String)("Check failed with exception: " + ex), null, (int)8, null);
        }
    }

    static {
        Issues = new Issues(null);
        IMPLEMENTATION = new Implementation(IncompatibleIidVersionDetector.class, EnumSet.noneOf(Scope.class));
        INCOMPATIBLE_IID_VERSION = Issue.Companion.create("IncompatibleIidVersion", "FirebaseInstanceId version is not compatible with FirebaseInstallations", "\n           These versions of FirebaseInstanceId and FirebaseInstallations can not be used in parallel.\n           Please update your Firebase Instance ID to a version 20.1.1 or later.\n            ", Category.INTEROPERABILITY, 1, Severity.ERROR, IMPLEMENTATION);
        IID_COMPATIBILITY_CHECK_FAILURE = Issue.Companion.create("IidCompatibilityCheckFailure", "Firebase IID Compatibility Check Unable To Run", "\n                    The check failed to run as it encountered unknown failure.\n                    This is most likely caused by a new version of Android Gradle Plugin that this check does not support.\n                    Please make sure your build does not depend on firebase-iid version earlier than 20.1.1 as it will cause issues.\n                    ", Category.LINT, 1, Severity.INFORMATIONAL, IMPLEMENTATION);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/google/firebase/installations/lint/IncompatibleIidVersionDetector$Issues;", "", "()V", "IID_COMPATIBILITY_CHECK_FAILURE", "Lcom/android/tools/lint/detector/api/Issue;", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "INCOMPATIBLE_IID_VERSION", "customer-lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

