/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.inappmessaging.internal.Logging;
import com.google.firebase.inappmessaging.internal.SharedPreferencesUtils;
import com.google.internal.firebase.inappmessaging.v1.CampaignProto;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.FetchEligibleCampaignsResponse;
import java.util.List;
import javax.inject.Inject;

public class TestDeviceHelper {
    @VisibleForTesting
    static final String TEST_DEVICE_PREFERENCES = "test_device";
    @VisibleForTesting
    static final String FRESH_INSTALL_PREFERENCES = "fresh_install";
    @VisibleForTesting
    static final int MAX_FETCH_COUNT = 5;
    private final SharedPreferencesUtils sharedPreferencesUtils;
    private boolean isTestDevice;
    private boolean isFreshInstall;
    private int fetchCount = 0;

    @Inject
    public TestDeviceHelper(SharedPreferencesUtils sharedPreferencesUtils) {
        this.sharedPreferencesUtils = sharedPreferencesUtils;
        this.isFreshInstall = this.readFreshInstallStatusFromPreferences();
        this.isTestDevice = this.readTestDeviceStatusFromPreferences();
    }

    public boolean isDeviceInTestMode() {
        return this.isTestDevice;
    }

    public boolean isAppInstallFresh() {
        return this.isFreshInstall;
    }

    public void processCampaignFetch(FetchEligibleCampaignsResponse response) {
        if (!this.isTestDevice) {
            this.updateFreshInstallStatus();
            List<CampaignProto.ThickContent> messages = response.getMessagesList();
            for (CampaignProto.ThickContent message : messages) {
                if (!message.getIsTestCampaign()) continue;
                this.setTestDeviceStatus(true);
                Logging.logi("Setting this device as a test device");
                return;
            }
        }
    }

    private void updateFreshInstallStatus() {
        if (this.isFreshInstall) {
            ++this.fetchCount;
            if (this.fetchCount >= 5) {
                this.setFreshInstallStatus(false);
            }
        }
    }

    private void setTestDeviceStatus(boolean isEnabled) {
        this.isTestDevice = isEnabled;
        this.sharedPreferencesUtils.setBooleanPreference(TEST_DEVICE_PREFERENCES, isEnabled);
    }

    private void setFreshInstallStatus(boolean isEnabled) {
        this.isFreshInstall = isEnabled;
        this.sharedPreferencesUtils.setBooleanPreference(FRESH_INSTALL_PREFERENCES, isEnabled);
    }

    private boolean readTestDeviceStatusFromPreferences() {
        return this.sharedPreferencesUtils.getAndSetBooleanPreference(TEST_DEVICE_PREFERENCES, false);
    }

    private boolean readFreshInstallStatusFromPreferences() {
        return this.sharedPreferencesUtils.getAndSetBooleanPreference(FRESH_INSTALL_PREFERENCES, true);
    }
}

