/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.internal;

import com.google.firebase.inappmessaging.internal.Logging;
import com.google.firebase.inappmessaging.internal.ProtoStorageClient;
import com.google.firebase.inappmessaging.internal.injection.qualifiers.ImpressionStore;
import com.google.internal.firebase.inappmessaging.v1.CampaignProto;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.CampaignImpression;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.CampaignImpressionList;
import com.google.internal.firebase.inappmessaging.v1.sdkserving.FetchEligibleCampaignsResponse;
import com.google.protobuf.AbstractMessageLite;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ImpressionStorageClient {
    private static final CampaignImpressionList EMPTY_IMPRESSIONS = CampaignImpressionList.getDefaultInstance();
    private final ProtoStorageClient storageClient;
    private Maybe<CampaignImpressionList> cachedImpressionsMaybe = Maybe.empty();

    @Inject
    ImpressionStorageClient(@ImpressionStore ProtoStorageClient storageClient) {
        this.storageClient = storageClient;
    }

    private static CampaignImpressionList appendImpression(CampaignImpressionList campaignImpressions, CampaignImpression impression) {
        return (CampaignImpressionList)CampaignImpressionList.newBuilder(campaignImpressions).addAlreadySeenCampaigns(impression).build();
    }

    public Completable storeImpression(CampaignImpression impression) {
        return this.getAllImpressions().defaultIfEmpty((Object)EMPTY_IMPRESSIONS).flatMapCompletable(storedImpressions -> {
            CampaignImpressionList appendedImpressions = ImpressionStorageClient.appendImpression(storedImpressions, impression);
            return this.storageClient.write((AbstractMessageLite)appendedImpressions).doOnComplete(() -> this.initInMemCache(appendedImpressions));
        });
    }

    public Maybe<CampaignImpressionList> getAllImpressions() {
        return this.cachedImpressionsMaybe.switchIfEmpty((MaybeSource)this.storageClient.read(CampaignImpressionList.parser()).doOnSuccess(this::initInMemCache)).doOnError(ignored -> this.clearInMemCache());
    }

    private void initInMemCache(CampaignImpressionList campaignImpressions) {
        this.cachedImpressionsMaybe = Maybe.just((Object)campaignImpressions);
    }

    private void clearInMemCache() {
        this.cachedImpressionsMaybe = Maybe.empty();
    }

    public Single<Boolean> isImpressed(CampaignProto.ThickContent content) {
        String campaignId = content.getPayloadCase().equals((Object)CampaignProto.ThickContent.PayloadCase.VANILLA_PAYLOAD) ? content.getVanillaPayload().getCampaignId() : content.getExperimentalPayload().getCampaignId();
        return this.getAllImpressions().map(CampaignImpressionList::getAlreadySeenCampaignsList).flatMapObservable(Observable::fromIterable).map(CampaignImpression::getCampaignId).contains((Object)campaignId);
    }

    public Completable clearImpressions(FetchEligibleCampaignsResponse response) {
        HashSet<String> idsToClear = new HashSet<String>();
        for (CampaignProto.ThickContent content : response.getMessagesList()) {
            String id = content.getPayloadCase().equals((Object)CampaignProto.ThickContent.PayloadCase.VANILLA_PAYLOAD) ? content.getVanillaPayload().getCampaignId() : content.getExperimentalPayload().getCampaignId();
            idsToClear.add(id);
        }
        Logging.logd("Potential impressions to clear: " + idsToClear.toString());
        return this.getAllImpressions().defaultIfEmpty((Object)EMPTY_IMPRESSIONS).flatMapCompletable(storedImpressions -> {
            Logging.logd("Existing impressions: " + storedImpressions.toString());
            CampaignImpressionList.Builder clearedImpressionListBuilder = CampaignImpressionList.newBuilder();
            for (CampaignImpression storedImpression : storedImpressions.getAlreadySeenCampaignsList()) {
                if (idsToClear.contains(storedImpression.getCampaignId())) continue;
                clearedImpressionListBuilder.addAlreadySeenCampaigns(storedImpression);
            }
            CampaignImpressionList clearedImpressionList = (CampaignImpressionList)clearedImpressionListBuilder.build();
            Logging.logd("New cleared impression list: " + clearedImpressionList.toString());
            return this.storageClient.write((AbstractMessageLite)clearedImpressionList).doOnComplete(() -> this.initInMemCache(clearedImpressionList));
        });
    }
}

