/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal.bindingwrappers;

import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.firebase.inappmessaging.display.R;
import com.google.firebase.inappmessaging.display.internal.InAppMessageLayoutConfig;
import com.google.firebase.inappmessaging.display.internal.bindingwrappers.BindingWrapper;
import com.google.firebase.inappmessaging.display.internal.injection.scopes.InAppMessageScope;
import com.google.firebase.inappmessaging.display.internal.layout.FiamFrameLayout;
import com.google.firebase.inappmessaging.model.Action;
import com.google.firebase.inappmessaging.model.ImageOnlyMessage;
import com.google.firebase.inappmessaging.model.InAppMessage;
import com.google.firebase.inappmessaging.model.MessageType;
import java.util.Map;
import javax.inject.Inject;

@InAppMessageScope
public class ImageBindingWrapper
extends BindingWrapper {
    private FiamFrameLayout imageRoot;
    private ViewGroup imageContentRoot;
    private ImageView imageView;
    private Button collapseButton;

    @Inject
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public ImageBindingWrapper(InAppMessageLayoutConfig config, LayoutInflater inflater, InAppMessage message) {
        super(config, inflater, message);
    }

    @Override
    @Nullable
    public ViewTreeObserver.OnGlobalLayoutListener inflate(Map<Action, View.OnClickListener> actionListeners, View.OnClickListener dismissOnClickListener) {
        View v = this.inflater.inflate(R.layout.image, null);
        this.imageRoot = (FiamFrameLayout)v.findViewById(R.id.image_root);
        this.imageContentRoot = (ViewGroup)v.findViewById(R.id.image_content_root);
        this.imageView = (ImageView)v.findViewById(R.id.image_view);
        this.collapseButton = (Button)v.findViewById(R.id.collapse_button);
        this.imageView.setMaxHeight(this.config.getMaxImageHeight());
        this.imageView.setMaxWidth(this.config.getMaxImageWidth());
        if (this.message.getMessageType().equals((Object)MessageType.IMAGE_ONLY)) {
            ImageOnlyMessage msg = (ImageOnlyMessage)this.message;
            this.imageView.setVisibility(msg.getImageData() == null || TextUtils.isEmpty((CharSequence)msg.getImageData().getImageUrl()) ? 8 : 0);
            this.imageView.setOnClickListener(actionListeners.get(msg.getAction()));
        }
        this.imageRoot.setDismissListener(dismissOnClickListener);
        this.collapseButton.setOnClickListener(dismissOnClickListener);
        return null;
    }

    @Override
    @NonNull
    public ImageView getImageView() {
        return this.imageView;
    }

    @Override
    @NonNull
    public ViewGroup getRootView() {
        return this.imageRoot;
    }

    @Override
    @NonNull
    public View getDialogView() {
        return this.imageContentRoot;
    }

    @NonNull
    public View getCollapseButton() {
        return this.collapseButton;
    }
}

