/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.inappmessaging.display.internal.bindingwrappers;

import android.graphics.Color;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.inappmessaging.display.R;
import com.google.firebase.inappmessaging.display.internal.InAppMessageLayoutConfig;
import com.google.firebase.inappmessaging.display.internal.bindingwrappers.BindingWrapper;
import com.google.firebase.inappmessaging.display.internal.injection.scopes.InAppMessageScope;
import com.google.firebase.inappmessaging.display.internal.layout.BaseModalLayout;
import com.google.firebase.inappmessaging.display.internal.layout.FiamCardView;
import com.google.firebase.inappmessaging.model.Action;
import com.google.firebase.inappmessaging.model.CardMessage;
import com.google.firebase.inappmessaging.model.InAppMessage;
import com.google.firebase.inappmessaging.model.MessageType;
import java.util.Map;
import javax.inject.Inject;

@InAppMessageScope
public class CardBindingWrapper
extends BindingWrapper {
    private FiamCardView cardRoot;
    private BaseModalLayout cardContentRoot;
    private ScrollView bodyScroll;
    private Button primaryButton;
    private Button secondaryButton;
    private ImageView imageView;
    private TextView messageBody;
    private TextView messageTitle;
    private CardMessage cardMessage;
    private View.OnClickListener dismissListener;
    private ViewTreeObserver.OnGlobalLayoutListener layoutListener = new ScrollViewAdjustableListener();

    @Inject
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public CardBindingWrapper(InAppMessageLayoutConfig config, LayoutInflater inflater, InAppMessage message) {
        super(config, inflater, message);
    }

    @Override
    @NonNull
    public ViewTreeObserver.OnGlobalLayoutListener inflate(Map<Action, View.OnClickListener> actionListeners, View.OnClickListener dismissOnClickListener) {
        View root = this.inflater.inflate(R.layout.card, null);
        this.bodyScroll = (ScrollView)root.findViewById(R.id.body_scroll);
        this.primaryButton = (Button)root.findViewById(R.id.primary_button);
        this.secondaryButton = (Button)root.findViewById(R.id.secondary_button);
        this.imageView = (ImageView)root.findViewById(R.id.image_view);
        this.messageBody = (TextView)root.findViewById(R.id.message_body);
        this.messageTitle = (TextView)root.findViewById(R.id.message_title);
        this.cardRoot = (FiamCardView)root.findViewById(R.id.card_root);
        this.cardContentRoot = (BaseModalLayout)root.findViewById(R.id.card_content_root);
        if (this.message.getMessageType().equals((Object)MessageType.CARD)) {
            this.cardMessage = (CardMessage)this.message;
            this.setMessage(this.cardMessage);
            this.setImage(this.cardMessage);
            this.setButtons(actionListeners);
            this.setLayoutConfig(this.config);
            this.setDismissListener(dismissOnClickListener);
            this.setViewBgColorFromHex((View)this.cardContentRoot, this.cardMessage.getBackgroundHexColor());
        }
        return this.layoutListener;
    }

    @Override
    @NonNull
    public ImageView getImageView() {
        return this.imageView;
    }

    @NonNull
    public View getScrollView() {
        return this.bodyScroll;
    }

    @NonNull
    public View getTitleView() {
        return this.messageTitle;
    }

    @Override
    @NonNull
    public ViewGroup getRootView() {
        return this.cardRoot;
    }

    @Override
    @NonNull
    public View getDialogView() {
        return this.cardContentRoot;
    }

    @Override
    @NonNull
    public InAppMessageLayoutConfig getConfig() {
        return this.config;
    }

    @Override
    @NonNull
    public View.OnClickListener getDismissListener() {
        return this.dismissListener;
    }

    @NonNull
    public Button getPrimaryButton() {
        return this.primaryButton;
    }

    @NonNull
    public Button getSecondaryButton() {
        return this.secondaryButton;
    }

    private void setMessage(CardMessage message) {
        this.messageTitle.setText((CharSequence)message.getTitle().getText());
        this.messageTitle.setTextColor(Color.parseColor((String)message.getTitle().getHexColor()));
        if (message.getBody() != null && message.getBody().getText() != null) {
            this.bodyScroll.setVisibility(0);
            this.messageBody.setVisibility(0);
            this.messageBody.setText((CharSequence)message.getBody().getText());
            this.messageBody.setTextColor(Color.parseColor((String)message.getBody().getHexColor()));
        } else {
            this.bodyScroll.setVisibility(8);
            this.messageBody.setVisibility(8);
        }
    }

    private void setButtons(Map<Action, View.OnClickListener> actionListeners) {
        Action primaryAction = this.cardMessage.getPrimaryAction();
        Action secondaryAction = this.cardMessage.getSecondaryAction();
        CardBindingWrapper.setupViewButtonFromModel(this.primaryButton, primaryAction.getButton());
        this.setButtonActionListener(this.primaryButton, actionListeners.get(primaryAction));
        this.primaryButton.setVisibility(0);
        if (secondaryAction != null && secondaryAction.getButton() != null) {
            CardBindingWrapper.setupViewButtonFromModel(this.secondaryButton, secondaryAction.getButton());
            this.setButtonActionListener(this.secondaryButton, actionListeners.get(secondaryAction));
            this.secondaryButton.setVisibility(0);
        } else {
            this.secondaryButton.setVisibility(8);
        }
    }

    private void setImage(CardMessage message) {
        if (message.getPortraitImageData() != null || message.getLandscapeImageData() != null) {
            this.imageView.setVisibility(0);
        } else {
            this.imageView.setVisibility(8);
        }
    }

    private void setLayoutConfig(InAppMessageLayoutConfig config) {
        this.imageView.setMaxHeight(config.getMaxImageHeight());
        this.imageView.setMaxWidth(config.getMaxImageWidth());
    }

    private void setDismissListener(View.OnClickListener dismissListener) {
        this.dismissListener = dismissListener;
        this.cardRoot.setDismissListener(dismissListener);
    }

    @VisibleForTesting
    public void setLayoutListener(ViewTreeObserver.OnGlobalLayoutListener listener) {
        this.layoutListener = listener;
    }

    public class ScrollViewAdjustableListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        public void onGlobalLayout() {
            CardBindingWrapper.this.imageView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }
}

