/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.firestore;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.firestore.AggregateQuery;
import com.google.firebase.firestore.util.Preconditions;
import java.util.Objects;

class AggregateQuerySnapshot {
    private final long count;
    private final AggregateQuery query;

    AggregateQuerySnapshot(@NonNull AggregateQuery query, long count) {
        Preconditions.checkNotNull(query);
        this.query = query;
        this.count = count;
    }

    @NonNull
    public AggregateQuery getQuery() {
        return this.query;
    }

    @Nullable
    public Long getCount() {
        return this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AggregateQuerySnapshot)) {
            return false;
        }
        AggregateQuerySnapshot snapshot = (AggregateQuerySnapshot)o;
        return this.count == snapshot.count && this.query.equals(snapshot.query);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.query);
    }
}

