/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.encoders.json;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.encoders.DataEncoder;
import com.google.firebase.encoders.EncodingException;
import com.google.firebase.encoders.ObjectEncoder;
import com.google.firebase.encoders.ValueEncoder;
import com.google.firebase.encoders.ValueEncoderContext;
import com.google.firebase.encoders.config.Configurator;
import com.google.firebase.encoders.config.EncoderConfig;
import com.google.firebase.encoders.json.JsonDataEncoderBuilder$$Lambda$1;
import com.google.firebase.encoders.json.JsonDataEncoderBuilder$$Lambda$4;
import com.google.firebase.encoders.json.JsonValueObjectEncoderContext;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class JsonDataEncoderBuilder
implements EncoderConfig<JsonDataEncoderBuilder> {
    private final Map<Class<?>, ObjectEncoder<?>> objectEncoders = new HashMap();
    private final Map<Class<?>, ValueEncoder<?>> valueEncoders = new HashMap();
    private static final ValueEncoder<String> STRING_ENCODER = JsonDataEncoderBuilder$$Lambda$1.lambdaFactory$();
    private static final ValueEncoder<Boolean> BOOLEAN_ENCODER = JsonDataEncoderBuilder$$Lambda$4.lambdaFactory$();
    private static final TimestampEncoder TIMESTAMP_ENCODER = new TimestampEncoder();

    public JsonDataEncoderBuilder() {
        this.registerEncoder((Class)String.class, STRING_ENCODER);
        this.registerEncoder((Class)Boolean.class, BOOLEAN_ENCODER);
        this.registerEncoder((Class)Date.class, (ValueEncoder)TIMESTAMP_ENCODER);
    }

    @Override
    @NonNull
    public <T> JsonDataEncoderBuilder registerEncoder(@NonNull Class<T> clazz, @NonNull ObjectEncoder<? super T> objectEncoder) {
        if (this.objectEncoders.containsKey(clazz)) {
            throw new IllegalArgumentException("Encoder already registered for " + clazz.getName());
        }
        this.objectEncoders.put(clazz, objectEncoder);
        return this;
    }

    @Override
    @NonNull
    public <T> JsonDataEncoderBuilder registerEncoder(@NonNull Class<T> clazz, @NonNull ValueEncoder<? super T> encoder) {
        if (this.valueEncoders.containsKey(clazz)) {
            throw new IllegalArgumentException("Encoder already registered for " + clazz.getName());
        }
        this.valueEncoders.put(clazz, encoder);
        return this;
    }

    @NonNull
    public JsonDataEncoderBuilder configureWith(@NonNull Configurator config) {
        config.configure(this);
        return this;
    }

    @NonNull
    public DataEncoder build() {
        return new DataEncoder(){

            @Override
            public void encode(@NonNull Object o, @NonNull Writer writer) throws IOException, EncodingException {
                JsonValueObjectEncoderContext encoderContext = new JsonValueObjectEncoderContext(writer, JsonDataEncoderBuilder.this.objectEncoders, JsonDataEncoderBuilder.this.valueEncoders);
                encoderContext.add(o);
                encoderContext.close();
            }

            @Override
            public String encode(@NonNull Object o) throws EncodingException {
                StringWriter stringWriter = new StringWriter();
                try {
                    this.encode(o, stringWriter);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return stringWriter.toString();
            }
        };
    }

    static /* synthetic */ void lambda$static$1(Boolean o, ValueEncoderContext ctx) throws EncodingException, IOException {
        ctx.add(o);
    }

    static /* synthetic */ void lambda$static$0(String o, ValueEncoderContext ctx) throws EncodingException, IOException {
        ctx.add(o);
    }

    private static final class TimestampEncoder
    implements ValueEncoder<Date> {
        private static final DateFormat rfc339 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);

        private TimestampEncoder() {
        }

        @Override
        public void encode(@Nullable Date o, @NonNull ValueEncoderContext ctx) throws EncodingException, IOException {
            ctx.add(rfc339.format(o));
        }

        static {
            rfc339.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
    }
}

