/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.collection;

import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.firebase.database.collection.LLRBNode;
import com.google.firebase.database.collection.LLRBValueNode;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;

@KeepForSdk
public class ImmutableSortedMapIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private final Stack<LLRBValueNode<K, V>> zzi = new Stack();
    private final boolean zzj;

    ImmutableSortedMapIterator(LLRBNode<K, V> lLRBNode, K k, Comparator<K> comparator, boolean bl) {
        this.zzj = bl;
        LLRBNode<K, V> lLRBNode2 = lLRBNode;
        while (!lLRBNode2.isEmpty()) {
            int n = k != null ? (bl ? comparator.compare(k, lLRBNode2.getKey()) : comparator.compare(lLRBNode2.getKey(), k)) : 1;
            if (n < 0) {
                if (!bl) {
                    lLRBNode2 = lLRBNode2.getRight();
                    continue;
                }
            } else {
                if (n == 0) {
                    this.zzi.push((LLRBValueNode)lLRBNode2);
                    return;
                }
                this.zzi.push((LLRBValueNode)lLRBNode2);
                if (bl) {
                    lLRBNode2 = lLRBNode2.getRight();
                    continue;
                }
            }
            lLRBNode2 = lLRBNode2.getLeft();
        }
    }

    @Override
    @KeepForSdk
    public boolean hasNext() {
        return this.zzi.size() > 0;
    }

    @Override
    @KeepForSdk
    public Map.Entry<K, V> next() {
        try {
            LLRBValueNode<K, V> lLRBValueNode = this.zzi.pop();
            AbstractMap.SimpleEntry<K, V> simpleEntry = new AbstractMap.SimpleEntry<K, V>(lLRBValueNode.getKey(), lLRBValueNode.getValue());
            if (this.zzj) {
                LLRBNode<K, V> lLRBNode = lLRBValueNode.getLeft();
                while (!lLRBNode.isEmpty()) {
                    this.zzi.push((LLRBValueNode)lLRBNode);
                    lLRBNode = lLRBNode.getRight();
                }
            } else {
                LLRBNode<K, V> lLRBNode = lLRBValueNode.getRight();
                while (!lLRBNode.isEmpty()) {
                    this.zzi.push((LLRBValueNode)lLRBNode);
                    lLRBNode = lLRBNode.getLeft();
                }
            }
            return simpleEntry;
        }
        catch (EmptyStackException emptyStackException) {
            throw new NoSuchElementException();
        }
    }

    @Override
    @KeepForSdk
    public void remove() {
        throw new UnsupportedOperationException("remove called on immutable collection");
    }
}

