/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import androidx.annotation.NonNull;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.UserMetadata;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class MetaDataStore {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String USERDATA_FILENAME = "user-data";
    private static final String KEYDATA_FILENAME = "keys";
    private static final String INTERNAL_KEYDATA_FILENAME = "internal-keys";
    private static final String KEY_USER_ID = "userId";
    private final FileStore fileStore;

    public MetaDataStore(FileStore fileStore) {
        this.fileStore = fileStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUserData(String sessionId, UserMetadata data) {
        File f = this.getUserDataFileForSession(sessionId);
        BufferedWriter writer = null;
        try {
            String userDataString = MetaDataStore.userDataToJson(data);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), UTF_8));
            writer.write(userDataString);
            ((Writer)writer).flush();
            CommonUtils.closeOrLog(writer, "Failed to close user metadata file.");
        }
        catch (Exception e) {
            Logger.getLogger().e("Error serializing user metadata.", e);
        }
        finally {
            CommonUtils.closeOrLog(writer, "Failed to close user metadata file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserMetadata readUserData(String sessionId) {
        File f = this.getUserDataFileForSession(sessionId);
        if (!f.exists()) {
            return new UserMetadata();
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            UserMetadata userMetadata = MetaDataStore.jsonToUserData(CommonUtils.streamToString(is));
            return userMetadata;
        }
        catch (Exception e) {
            Logger.getLogger().e("Error deserializing user metadata.", e);
        }
        finally {
            CommonUtils.closeOrLog(is, "Failed to close user metadata file.");
        }
        return new UserMetadata();
    }

    public void writeKeyData(String sessionId, Map<String, String> keyData) {
        this.writeKeyData(sessionId, keyData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeKeyData(String sessionId, Map<String, String> keyData, boolean isInternal) {
        File f = isInternal ? this.getInternalKeysFileForSession(sessionId) : this.getKeysFileForSession(sessionId);
        BufferedWriter writer = null;
        try {
            String keyDataString = MetaDataStore.keysDataToJson(keyData);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), UTF_8));
            writer.write(keyDataString);
            ((Writer)writer).flush();
            CommonUtils.closeOrLog(writer, "Failed to close key/value metadata file.");
        }
        catch (Exception e) {
            Logger.getLogger().e("Error serializing key/value metadata.", e);
        }
        finally {
            CommonUtils.closeOrLog(writer, "Failed to close key/value metadata file.");
        }
    }

    public Map<String, String> readKeyData(String sessionId) {
        return this.readKeyData(sessionId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> readKeyData(String sessionId, boolean isInternal) {
        File f;
        File file = f = isInternal ? this.getInternalKeysFileForSession(sessionId) : this.getKeysFileForSession(sessionId);
        if (!f.exists()) {
            return Collections.emptyMap();
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(f);
            Map<String, String> map = MetaDataStore.jsonToKeysData(CommonUtils.streamToString(is));
            return map;
        }
        catch (Exception e) {
            Logger.getLogger().e("Error deserializing user metadata.", e);
        }
        finally {
            CommonUtils.closeOrLog(is, "Failed to close user metadata file.");
        }
        return Collections.emptyMap();
    }

    @NonNull
    public File getUserDataFileForSession(String sessionId) {
        return this.fileStore.getSessionFile(sessionId, USERDATA_FILENAME);
    }

    @NonNull
    public File getKeysFileForSession(String sessionId) {
        return this.fileStore.getSessionFile(sessionId, KEYDATA_FILENAME);
    }

    @NonNull
    public File getInternalKeysFileForSession(String sessionId) {
        return this.fileStore.getSessionFile(sessionId, INTERNAL_KEYDATA_FILENAME);
    }

    private static UserMetadata jsonToUserData(String json) throws JSONException {
        JSONObject dataObj = new JSONObject(json);
        UserMetadata metadata = new UserMetadata();
        metadata.setUserId(MetaDataStore.valueOrNull(dataObj, KEY_USER_ID));
        return metadata;
    }

    private static String userDataToJson(final UserMetadata userData) throws JSONException {
        return new JSONObject(){
            {
                this.put(MetaDataStore.KEY_USER_ID, userData.getUserId());
            }
        }.toString();
    }

    private static Map<String, String> jsonToKeysData(String json) throws JSONException {
        JSONObject dataObj = new JSONObject(json);
        HashMap<String, String> keyData = new HashMap<String, String>();
        Iterator keyIter = dataObj.keys();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            keyData.put(key, MetaDataStore.valueOrNull(dataObj, key));
        }
        return keyData;
    }

    private static String keysDataToJson(Map<String, String> keyData) throws JSONException {
        return new JSONObject(keyData).toString();
    }

    private static String valueOrNull(JSONObject json, String key) {
        return !json.isNull(key) ? json.optString(key, null) : null;
    }
}

