/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.unity;

import android.content.Context;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.unity.UnityVersionProvider;

public class ResourceUnityVersionProvider
implements UnityVersionProvider {
    private static final String UNITY_EDITOR_VERSION = "com.google.firebase.crashlytics.unity_version";
    private static boolean isUnityVersionSet = false;
    private static String unityVersion = null;
    private final Context context;

    public static synchronized String resolveUnityEditorVersion(Context context) {
        if (isUnityVersionSet) {
            return unityVersion;
        }
        int id = CommonUtils.getResourcesIdentifier(context, UNITY_EDITOR_VERSION, "string");
        if (id != 0) {
            unityVersion = context.getResources().getString(id);
            isUnityVersionSet = true;
            Logger.getLogger().v("Unity Editor version is: " + unityVersion);
        }
        return unityVersion;
    }

    public ResourceUnityVersionProvider(Context context) {
        this.context = context;
    }

    @Override
    public String getUnityVersion() {
        return ResourceUnityVersionProvider.resolveUnityEditorVersion(this.context);
    }
}

