/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import androidx.annotation.NonNull;
import com.google.firebase.crashlytics.internal.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class KeysMap {
    private final Map<String, String> keys = new HashMap<String, String>();
    private final int maxEntries;
    private final int maxEntryLength;

    public KeysMap(int maxEntries, int maxEntryLength) {
        this.maxEntries = maxEntries;
        this.maxEntryLength = maxEntryLength;
    }

    @NonNull
    public synchronized Map<String, String> getKeys() {
        return Collections.unmodifiableMap(new HashMap<String, String>(this.keys));
    }

    public synchronized void setKey(String key, String value) {
        String sanitizedKey = this.sanitizeKey(key);
        if (this.keys.size() < this.maxEntries || this.keys.containsKey(sanitizedKey)) {
            this.keys.put(sanitizedKey, value == null ? "" : this.sanitizeAttribute(value));
        } else {
            Logger.getLogger().w("Ignored entry \"" + key + "\" when adding custom keys. Maximum allowable: " + this.maxEntries);
        }
    }

    public synchronized void setKeys(Map<String, String> keysAndValues) {
        int nOverLimit = 0;
        for (Map.Entry<String, String> entry : keysAndValues.entrySet()) {
            String sanitizedKey = this.sanitizeKey(entry.getKey());
            if (this.keys.size() < this.maxEntries || this.keys.containsKey(sanitizedKey)) {
                String value = entry.getValue();
                this.keys.put(sanitizedKey, value == null ? "" : this.sanitizeAttribute(value));
                continue;
            }
            ++nOverLimit;
        }
        if (nOverLimit > 0) {
            Logger.getLogger().w("Ignored " + nOverLimit + " entries when adding custom keys. Maximum allowable: " + this.maxEntries);
        }
    }

    private String sanitizeKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Custom attribute key must not be null.");
        }
        return this.sanitizeAttribute(key);
    }

    public String sanitizeAttribute(String input) {
        if (input != null && (input = input.trim()).length() > this.maxEntryLength) {
            input = input.substring(0, this.maxEntryLength);
        }
        return input;
    }
}

