/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics;

import android.content.Context;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.crashlytics.AnalyticsDeferredProxy;
import com.google.firebase.crashlytics.CustomKeysAndValues;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponentDeferredProxy;
import com.google.firebase.crashlytics.internal.DevelopmentPlatformProvider;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.AppData;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.CrashlyticsCore;
import com.google.firebase.crashlytics.internal.common.DataCollectionArbiter;
import com.google.firebase.crashlytics.internal.common.ExecutorUtils;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.network.HttpRequestFactory;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import com.google.firebase.crashlytics.internal.settings.SettingsController;
import com.google.firebase.inject.Deferred;
import com.google.firebase.installations.FirebaseInstallationsApi;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class FirebaseCrashlytics {
    static final String FIREBASE_CRASHLYTICS_ANALYTICS_ORIGIN = "clx";
    static final String LEGACY_CRASH_ANALYTICS_ORIGIN = "crash";
    static final int APP_EXCEPTION_CALLBACK_TIMEOUT_MS = 500;
    @VisibleForTesting
    final CrashlyticsCore core;

    @Nullable
    static FirebaseCrashlytics init(@NonNull FirebaseApp app, @NonNull FirebaseInstallationsApi firebaseInstallationsApi, @NonNull Deferred<CrashlyticsNativeComponent> nativeComponent, @NonNull Deferred<AnalyticsConnector> analyticsConnector) {
        AppData appData;
        Context context = app.getApplicationContext();
        String appIdentifier = context.getPackageName();
        Logger.getLogger().i("Initializing Firebase Crashlytics " + CrashlyticsCore.getVersion() + " for " + appIdentifier);
        FileStore fileStore = new FileStore(context);
        DataCollectionArbiter arbiter = new DataCollectionArbiter(app);
        IdManager idManager = new IdManager(context, appIdentifier, firebaseInstallationsApi, arbiter);
        CrashlyticsNativeComponentDeferredProxy deferredNativeComponent = new CrashlyticsNativeComponentDeferredProxy(nativeComponent);
        AnalyticsDeferredProxy analyticsDeferredProxy = new AnalyticsDeferredProxy(analyticsConnector);
        ExecutorService crashHandlerExecutor = ExecutorUtils.buildSingleThreadExecutorService("Crashlytics Exception Handler");
        final CrashlyticsCore core = new CrashlyticsCore(app, idManager, deferredNativeComponent, arbiter, analyticsDeferredProxy.getDeferredBreadcrumbSource(), analyticsDeferredProxy.getAnalyticsEventLogger(), fileStore, crashHandlerExecutor);
        String googleAppId = app.getOptions().getApplicationId();
        String mappingFileId = CommonUtils.getMappingFileId(context);
        Logger.getLogger().d("Mapping file ID is: " + mappingFileId);
        DevelopmentPlatformProvider developmentPlatformProvider = new DevelopmentPlatformProvider(context);
        try {
            appData = AppData.create(context, idManager, googleAppId, mappingFileId, developmentPlatformProvider);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.getLogger().e("Error retrieving app package info.", e);
            return null;
        }
        Logger.getLogger().v("Installer package name is: " + appData.installerPackageName);
        ExecutorService threadPoolExecutor = ExecutorUtils.buildSingleThreadExecutorService("com.google.firebase.crashlytics.startup");
        final SettingsController settingsController = SettingsController.create(context, googleAppId, idManager, new HttpRequestFactory(), appData.versionCode, appData.versionName, fileStore, arbiter);
        settingsController.loadSettingsData(threadPoolExecutor).continueWith((Executor)threadPoolExecutor, (Continuation)new Continuation<Void, Object>(){

            public Object then(@NonNull Task<Void> task) throws Exception {
                if (!task.isSuccessful()) {
                    Logger.getLogger().e("Error fetching settings.", task.getException());
                }
                return null;
            }
        });
        final boolean finishCoreInBackground = core.onPreExecute(appData, settingsController);
        Tasks.call((Executor)threadPoolExecutor, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (finishCoreInBackground) {
                    core.doBackgroundInitializationAsync(settingsController);
                }
                return null;
            }
        });
        return new FirebaseCrashlytics(core);
    }

    private FirebaseCrashlytics(@NonNull CrashlyticsCore core) {
        this.core = core;
    }

    @NonNull
    public static FirebaseCrashlytics getInstance() {
        FirebaseApp app = FirebaseApp.getInstance();
        FirebaseCrashlytics instance = (FirebaseCrashlytics)app.get(FirebaseCrashlytics.class);
        if (instance == null) {
            throw new NullPointerException("FirebaseCrashlytics component is not present.");
        }
        return instance;
    }

    public void recordException(@NonNull Throwable throwable) {
        if (throwable == null) {
            Logger.getLogger().w("A null value was passed to recordException. Ignoring.");
            return;
        }
        this.core.logException(throwable);
    }

    public void log(@NonNull String message) {
        this.core.log(message);
    }

    public void setUserId(@NonNull String identifier) {
        this.core.setUserId(identifier);
    }

    public void setCustomKey(@NonNull String key, boolean value) {
        this.core.setCustomKey(key, Boolean.toString(value));
    }

    public void setCustomKey(@NonNull String key, double value) {
        this.core.setCustomKey(key, Double.toString(value));
    }

    public void setCustomKey(@NonNull String key, float value) {
        this.core.setCustomKey(key, Float.toString(value));
    }

    public void setCustomKey(@NonNull String key, int value) {
        this.core.setCustomKey(key, Integer.toString(value));
    }

    public void setCustomKey(@NonNull String key, long value) {
        this.core.setCustomKey(key, Long.toString(value));
    }

    public void setCustomKey(@NonNull String key, @NonNull String value) {
        this.core.setCustomKey(key, value);
    }

    public void setCustomKeys(@NonNull CustomKeysAndValues keysAndValues) {
        this.core.setCustomKeys(keysAndValues.keysAndValues);
    }

    @NonNull
    public Task<Boolean> checkForUnsentReports() {
        return this.core.checkForUnsentReports();
    }

    public void sendUnsentReports() {
        this.core.sendUnsentReports();
    }

    public void deleteUnsentReports() {
        this.core.deleteUnsentReports();
    }

    public boolean didCrashOnPreviousExecution() {
        return this.core.didCrashOnPreviousExecution();
    }

    public void setCrashlyticsCollectionEnabled(boolean enabled) {
        this.core.setCrashlyticsCollectionEnabled(enabled);
    }

    public void setCrashlyticsCollectionEnabled(@Nullable Boolean enabled) {
        this.core.setCrashlyticsCollectionEnabled(enabled);
    }
}

