/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.model;

import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.firebase.crashlytics.internal.model.AutoValue_StaticSessionData;
import com.google.firebase.crashlytics.internal.model.AutoValue_StaticSessionData_AppData;
import com.google.firebase.crashlytics.internal.model.AutoValue_StaticSessionData_DeviceData;
import com.google.firebase.crashlytics.internal.model.AutoValue_StaticSessionData_OsData;

@AutoValue
public abstract class StaticSessionData {
    public abstract AppData appData();

    public abstract OsData osData();

    public abstract DeviceData deviceData();

    public static StaticSessionData create(AppData appData, OsData osData, DeviceData deviceData) {
        return new AutoValue_StaticSessionData(appData, osData, deviceData);
    }

    @AutoValue
    public static abstract class DeviceData {
        public abstract int arch();

        public abstract String model();

        public abstract int availableProcessors();

        public abstract long totalRam();

        public abstract long diskSpace();

        public abstract boolean isEmulator();

        public abstract int state();

        public abstract String manufacturer();

        public abstract String modelClass();

        public static DeviceData create(int arch, String model, int availableProcessors, long totalRam, long diskSpace, boolean isEmulator, int state, String manufacturer, String modelClass) {
            return new AutoValue_StaticSessionData_DeviceData(arch, model, availableProcessors, totalRam, diskSpace, isEmulator, state, manufacturer, modelClass);
        }
    }

    @AutoValue
    public static abstract class OsData {
        public abstract String osRelease();

        public abstract String osCodeName();

        public abstract boolean isRooted();

        public static OsData create(String osRelease, String osCodeName, boolean isRooted) {
            return new AutoValue_StaticSessionData_OsData(osRelease, osCodeName, isRooted);
        }
    }

    @AutoValue
    public static abstract class AppData {
        public abstract String appIdentifier();

        public abstract String versionCode();

        public abstract String versionName();

        public abstract String installUuid();

        public abstract int deliveryMechanism();

        @Nullable
        public abstract String unityVersion();

        public static AppData create(String appIdentifier, String versionCode, String versionName, String installUuid, int deliveryMechanism, @Nullable String unityVersion) {
            return new AutoValue_StaticSessionData_AppData(appIdentifier, versionCode, versionName, installUuid, deliveryMechanism, unityVersion);
        }
    }
}

