/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.breadcrumbs.BreadcrumbSource;
import com.google.firebase.crashlytics.internal.common.AppData;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.CrashlyticsBackgroundWorker;
import com.google.firebase.crashlytics.internal.common.CrashlyticsController;
import com.google.firebase.crashlytics.internal.common.CrashlyticsFileMarker;
import com.google.firebase.crashlytics.internal.common.DataCollectionArbiter;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.common.SessionReportingCoordinator;
import com.google.firebase.crashlytics.internal.common.UserMetadata;
import com.google.firebase.crashlytics.internal.common.Utils;
import com.google.firebase.crashlytics.internal.log.LogFileManager;
import com.google.firebase.crashlytics.internal.persistence.FileStore;
import com.google.firebase.crashlytics.internal.persistence.FileStoreImpl;
import com.google.firebase.crashlytics.internal.settings.SettingsDataProvider;
import com.google.firebase.crashlytics.internal.settings.model.Settings;
import com.google.firebase.crashlytics.internal.stacktrace.MiddleOutFallbackStrategy;
import com.google.firebase.crashlytics.internal.stacktrace.RemoveRepeatsStrategy;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CrashlyticsCore {
    private static final String MISSING_BUILD_ID_MSG = "The Crashlytics build ID is missing. This occurs when Crashlytics tooling is absent from your app's build configuration. Please review Crashlytics onboarding instructions and ensure you have a valid Crashlytics account.";
    static final int MAX_STACK_SIZE = 1024;
    static final int NUM_STACK_REPETITIONS_ALLOWED = 10;
    static final String CRASHLYTICS_REQUIRE_BUILD_ID = "com.crashlytics.RequireBuildId";
    static final boolean CRASHLYTICS_REQUIRE_BUILD_ID_DEFAULT = true;
    static final int DEFAULT_MAIN_HANDLER_TIMEOUT_SEC = 4;
    private static final String INITIALIZATION_MARKER_FILE_NAME = "initialization_marker";
    static final String CRASH_MARKER_FILE_NAME = "crash_marker";
    private final Context context;
    private final FirebaseApp app;
    private final DataCollectionArbiter dataCollectionArbiter;
    private final long startTime;
    private CrashlyticsFileMarker initializationMarker;
    private CrashlyticsFileMarker crashMarker;
    private boolean didCrashOnPreviousExecution;
    private CrashlyticsController controller;
    private final IdManager idManager;
    private final BreadcrumbSource breadcrumbSource;
    private final AnalyticsEventLogger analyticsEventLogger;
    private final ExecutorService crashHandlerExecutor;
    private final CrashlyticsBackgroundWorker backgroundWorker;
    private final CrashlyticsNativeComponent nativeComponent;

    public CrashlyticsCore(FirebaseApp app, IdManager idManager, CrashlyticsNativeComponent nativeComponent, DataCollectionArbiter dataCollectionArbiter, BreadcrumbSource breadcrumbSource, AnalyticsEventLogger analyticsEventLogger, ExecutorService crashHandlerExecutor) {
        this.app = app;
        this.dataCollectionArbiter = dataCollectionArbiter;
        this.context = app.getApplicationContext();
        this.idManager = idManager;
        this.nativeComponent = nativeComponent;
        this.breadcrumbSource = breadcrumbSource;
        this.analyticsEventLogger = analyticsEventLogger;
        this.crashHandlerExecutor = crashHandlerExecutor;
        this.backgroundWorker = new CrashlyticsBackgroundWorker(crashHandlerExecutor);
        this.startTime = System.currentTimeMillis();
    }

    public boolean onPreExecute(AppData appData, SettingsDataProvider settingsProvider) {
        boolean requiresBuildId = CommonUtils.getBooleanResourceValue(this.context, CRASHLYTICS_REQUIRE_BUILD_ID, true);
        if (!CrashlyticsCore.isBuildIdValid(appData.buildId, requiresBuildId)) {
            throw new IllegalStateException(MISSING_BUILD_ID_MSG);
        }
        try {
            FileStoreImpl fileStore = new FileStoreImpl(this.context);
            this.crashMarker = new CrashlyticsFileMarker(CRASH_MARKER_FILE_NAME, fileStore);
            this.initializationMarker = new CrashlyticsFileMarker(INITIALIZATION_MARKER_FILE_NAME, fileStore);
            UserMetadata userMetadata = new UserMetadata();
            LogFileDirectoryProvider logFileDirectoryProvider = new LogFileDirectoryProvider(fileStore);
            LogFileManager logFileManager = new LogFileManager(this.context, logFileDirectoryProvider);
            MiddleOutFallbackStrategy stackTraceTrimmingStrategy = new MiddleOutFallbackStrategy(1024, new RemoveRepeatsStrategy(10));
            SessionReportingCoordinator sessionReportingCoordinator = SessionReportingCoordinator.create(this.context, this.idManager, fileStore, appData, logFileManager, userMetadata, stackTraceTrimmingStrategy, settingsProvider);
            this.controller = new CrashlyticsController(this.context, this.backgroundWorker, this.idManager, this.dataCollectionArbiter, fileStore, this.crashMarker, appData, userMetadata, logFileManager, logFileDirectoryProvider, sessionReportingCoordinator, this.nativeComponent, this.analyticsEventLogger);
            boolean initializeSynchronously = this.didPreviousInitializationFail();
            this.checkForPreviousCrash();
            this.controller.enableExceptionHandling(Thread.getDefaultUncaughtExceptionHandler(), settingsProvider);
            if (initializeSynchronously && CommonUtils.canTryConnection(this.context)) {
                Logger.getLogger().d("Crashlytics did not finish previous background initialization. Initializing synchronously.");
                this.finishInitSynchronously(settingsProvider);
                return false;
            }
        }
        catch (Exception e) {
            Logger.getLogger().e("Crashlytics was not started due to an exception during initialization", e);
            this.controller = null;
            return false;
        }
        Logger.getLogger().d("Successfully configured exception handler.");
        return true;
    }

    public Task<Void> doBackgroundInitializationAsync(final SettingsDataProvider settingsProvider) {
        return Utils.callTask(this.crashHandlerExecutor, new Callable<Task<Void>>(){

            @Override
            public Task<Void> call() throws Exception {
                return CrashlyticsCore.this.doBackgroundInitialization(settingsProvider);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> doBackgroundInitialization(SettingsDataProvider settingsProvider) {
        this.markInitializationStarted();
        try {
            this.breadcrumbSource.registerBreadcrumbHandler(this::log);
            Settings settingsData = settingsProvider.getSettings();
            if (!settingsData.getFeaturesData().collectReports) {
                Logger.getLogger().d("Collection of crash reports disabled in Crashlytics settings.");
                Task task = Tasks.forException((Exception)new RuntimeException("Collection of crash reports disabled in Crashlytics settings."));
                return task;
            }
            if (!this.controller.finalizeSessions()) {
                Logger.getLogger().w("Previous sessions could not be finalized.");
            }
            Task<Void> task = this.controller.submitAllReports(settingsProvider.getAppSettings());
            return task;
        }
        catch (Exception e) {
            Logger.getLogger().e("Crashlytics encountered a problem during asynchronous initialization.", e);
            Task task = Tasks.forException((Exception)e);
            return task;
        }
        finally {
            this.markInitializationComplete();
        }
    }

    public void setCrashlyticsCollectionEnabled(@Nullable Boolean enabled) {
        this.dataCollectionArbiter.setCrashlyticsDataCollectionEnabled(enabled);
    }

    @NonNull
    public Task<Boolean> checkForUnsentReports() {
        return this.controller.checkForUnsentReports();
    }

    public Task<Void> sendUnsentReports() {
        return this.controller.sendUnsentReports();
    }

    public Task<Void> deleteUnsentReports() {
        return this.controller.deleteUnsentReports();
    }

    public static String getVersion() {
        return "18.0.1";
    }

    public void logException(@NonNull Throwable throwable) {
        this.controller.writeNonFatalException(Thread.currentThread(), throwable);
    }

    public void log(String msg) {
        long timestamp = System.currentTimeMillis() - this.startTime;
        this.controller.writeToLog(timestamp, msg);
    }

    public void setUserId(String identifier) {
        this.controller.setUserId(identifier);
    }

    public void setCustomKey(String key, String value) {
        this.controller.setCustomKey(key, value);
    }

    public void setCustomKeys(Map<String, String> keysAndValues) {
        this.controller.setCustomKeys(keysAndValues);
    }

    CrashlyticsController getController() {
        return this.controller;
    }

    private void finishInitSynchronously(final SettingsDataProvider settingsDataProvider) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CrashlyticsCore.this.doBackgroundInitialization(settingsDataProvider);
            }
        };
        Future<?> future = this.crashHandlerExecutor.submit(runnable);
        Logger.getLogger().d("Crashlytics detected incomplete initialization on previous app launch. Will initialize synchronously.");
        try {
            future.get(4L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.getLogger().e("Crashlytics was interrupted during initialization.", e);
        }
        catch (ExecutionException e) {
            Logger.getLogger().e("Crashlytics encountered a problem during initialization.", e);
        }
        catch (TimeoutException e) {
            Logger.getLogger().e("Crashlytics timed out during initialization.", e);
        }
    }

    void markInitializationStarted() {
        this.backgroundWorker.checkRunningOnThread();
        this.initializationMarker.create();
        Logger.getLogger().v("Initialization marker file was created.");
    }

    void markInitializationComplete() {
        this.backgroundWorker.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    boolean removed = CrashlyticsCore.this.initializationMarker.remove();
                    if (!removed) {
                        Logger.getLogger().w("Initialization marker file was not properly removed.");
                    }
                    return removed;
                }
                catch (Exception e) {
                    Logger.getLogger().e("Problem encountered deleting Crashlytics initialization marker.", e);
                    return false;
                }
            }
        });
    }

    boolean didPreviousInitializationFail() {
        return this.initializationMarker.isPresent();
    }

    private void checkForPreviousCrash() {
        Boolean result;
        Task<Boolean> task = this.backgroundWorker.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CrashlyticsCore.this.controller.didCrashOnPreviousExecution();
            }
        });
        try {
            result = Utils.awaitEvenIfOnMainThread(task);
        }
        catch (Exception e) {
            this.didCrashOnPreviousExecution = false;
            return;
        }
        this.didCrashOnPreviousExecution = Boolean.TRUE.equals(result);
    }

    public boolean didCrashOnPreviousExecution() {
        return this.didCrashOnPreviousExecution;
    }

    static boolean isBuildIdValid(String buildId, boolean requiresBuildId) {
        if (!requiresBuildId) {
            Logger.getLogger().v("Configured not to require a build ID.");
            return true;
        }
        if (!TextUtils.isEmpty((CharSequence)buildId)) {
            return true;
        }
        Log.e((String)"FirebaseCrashlytics", (String)".");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  | ");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".   \\ |  | /");
        Log.e((String)"FirebaseCrashlytics", (String)".    \\    /");
        Log.e((String)"FirebaseCrashlytics", (String)".     \\  /");
        Log.e((String)"FirebaseCrashlytics", (String)".      \\/");
        Log.e((String)"FirebaseCrashlytics", (String)".");
        Log.e((String)"FirebaseCrashlytics", (String)MISSING_BUILD_ID_MSG);
        Log.e((String)"FirebaseCrashlytics", (String)".");
        Log.e((String)"FirebaseCrashlytics", (String)".      /\\");
        Log.e((String)"FirebaseCrashlytics", (String)".     /  \\");
        Log.e((String)"FirebaseCrashlytics", (String)".    /    \\");
        Log.e((String)"FirebaseCrashlytics", (String)".   / |  | \\");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".");
        return false;
    }

    private static final class LogFileDirectoryProvider
    implements LogFileManager.DirectoryProvider {
        private static final String LOG_FILES_DIR = "log-files";
        private final FileStore rootFileStore;

        public LogFileDirectoryProvider(FileStore rootFileStore) {
            this.rootFileStore = rootFileStore;
        }

        @Override
        public File getLogFileDir() {
            File logFileDir = new File(this.rootFileStore.getFilesDir(), LOG_FILES_DIR);
            if (!logFileDir.exists()) {
                logFileDir.mkdirs();
            }
            return logFileDir;
        }
    }
}

