/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.persistence;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CrashlyticsReportWithSessionId;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import com.google.firebase.crashlytics.internal.model.ImmutableList;
import com.google.firebase.crashlytics.internal.model.serialization.CrashlyticsReportJsonTransform;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$Lambda$1;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$Lambda$2;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$Lambda$3;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$Lambda$4;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$Lambda$5;
import com.google.firebase.crashlytics.internal.persistence.CrashlyticsReportPersistence$$Lambda$6;
import com.google.firebase.crashlytics.internal.settings.SettingsDataProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class CrashlyticsReportPersistence {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final int MAX_OPEN_SESSIONS = 8;
    private static final String WORKING_DIRECTORY_NAME = "report-persistence";
    private static final String OPEN_SESSIONS_DIRECTORY_NAME = "sessions";
    private static final String PRIORITY_REPORTS_DIRECTORY = "priority-reports";
    private static final String NATIVE_REPORTS_DIRECTORY = "native-reports";
    private static final String REPORTS_DIRECTORY = "reports";
    private static final String REPORT_FILE_NAME = "report";
    private static final String USER_FILE_NAME = "user";
    private static final String EVENT_FILE_NAME_PREFIX = "event";
    private static final int EVENT_COUNTER_WIDTH = 10;
    private static final String EVENT_COUNTER_FORMAT = "%010d";
    private static final int EVENT_NAME_LENGTH = "event".length() + 10;
    private static final String PRIORITY_EVENT_SUFFIX = "_";
    private static final String NORMAL_EVENT_SUFFIX = "";
    private static final CrashlyticsReportJsonTransform TRANSFORM = new CrashlyticsReportJsonTransform();
    private static final Comparator<? super File> LATEST_SESSION_ID_FIRST_COMPARATOR = CrashlyticsReportPersistence$$Lambda$5.lambdaFactory$();
    private static final FilenameFilter EVENT_FILE_FILTER = CrashlyticsReportPersistence$$Lambda$6.lambdaFactory$();
    @NonNull
    private final AtomicInteger eventCounter = new AtomicInteger(0);
    @NonNull
    private final File openSessionsDirectory;
    @NonNull
    private final File priorityReportsDirectory;
    @NonNull
    private final File reportsDirectory;
    @NonNull
    private final File nativeReportsDirectory;
    @NonNull
    private final SettingsDataProvider settingsDataProvider;

    public CrashlyticsReportPersistence(@NonNull File rootDirectory, @NonNull SettingsDataProvider settingsDataProvider) {
        File workingDirectory = new File(rootDirectory, WORKING_DIRECTORY_NAME);
        this.openSessionsDirectory = new File(workingDirectory, OPEN_SESSIONS_DIRECTORY_NAME);
        this.priorityReportsDirectory = new File(workingDirectory, PRIORITY_REPORTS_DIRECTORY);
        this.reportsDirectory = new File(workingDirectory, REPORTS_DIRECTORY);
        this.nativeReportsDirectory = new File(workingDirectory, NATIVE_REPORTS_DIRECTORY);
        this.settingsDataProvider = settingsDataProvider;
    }

    public void persistReport(@NonNull CrashlyticsReport report) {
        CrashlyticsReport.Session session = report.getSession();
        if (session == null) {
            Logger.getLogger().d("Could not get session for report");
            return;
        }
        String sessionId = session.getIdentifier();
        try {
            File sessionDirectory = CrashlyticsReportPersistence.prepareDirectory(this.getSessionDirectoryById(sessionId));
            String json = TRANSFORM.reportToJson(report);
            CrashlyticsReportPersistence.writeTextFile(new File(sessionDirectory, REPORT_FILE_NAME), json);
        }
        catch (IOException e) {
            Logger.getLogger().d("Could not persist report for session " + sessionId, e);
        }
    }

    public void persistEvent(@NonNull CrashlyticsReport.Session.Event event, @NonNull String sessionId) {
        this.persistEvent(event, sessionId, false);
    }

    public void persistEvent(@NonNull CrashlyticsReport.Session.Event event, @NonNull String sessionId, boolean isHighPriority) {
        int maxEventsToKeep = this.settingsDataProvider.getSettings().getSessionData().maxCustomExceptionEvents;
        File sessionDirectory = this.getSessionDirectoryById(sessionId);
        String json = TRANSFORM.eventToJson(event);
        String fileName = CrashlyticsReportPersistence.generateEventFilename(this.eventCounter.getAndIncrement(), isHighPriority);
        try {
            CrashlyticsReportPersistence.writeTextFile(new File(sessionDirectory, fileName), json);
        }
        catch (IOException e) {
            Logger.getLogger().d("Could not persist event for session " + sessionId, e);
        }
        CrashlyticsReportPersistence.trimEvents(sessionDirectory, maxEventsToKeep);
    }

    public void persistUserIdForSession(@NonNull String userId, @NonNull String sessionId) {
        File sessionDirectory = this.getSessionDirectoryById(sessionId);
        try {
            CrashlyticsReportPersistence.writeTextFile(new File(sessionDirectory, USER_FILE_NAME), userId);
        }
        catch (IOException e) {
            Logger.getLogger().d("Could not persist user ID for session " + sessionId, e);
        }
    }

    public void deleteAllReports() {
        for (File reportFile : this.getAllFinalizedReportFiles()) {
            reportFile.delete();
        }
    }

    public void deleteFinalizedReport(String sessionId) {
        FilenameFilter filter = CrashlyticsReportPersistence$$Lambda$1.lambdaFactory$(sessionId);
        List<File> filteredReports = CrashlyticsReportPersistence.combineReportFiles(CrashlyticsReportPersistence.getFilesInDirectory(this.priorityReportsDirectory, filter), CrashlyticsReportPersistence.getFilesInDirectory(this.nativeReportsDirectory, filter), CrashlyticsReportPersistence.getFilesInDirectory(this.reportsDirectory, filter));
        for (File reportFile : filteredReports) {
            reportFile.delete();
        }
    }

    public void finalizeReports(@Nullable String currentSessionId, long sessionEndTime) {
        List<File> sessionDirectories = this.capAndGetOpenSessions(currentSessionId);
        for (File sessionDirectory : sessionDirectories) {
            Logger.getLogger().d("Finalizing report for session " + sessionDirectory.getName());
            this.synthesizeReport(sessionDirectory, sessionEndTime);
            CrashlyticsReportPersistence.recursiveDelete(sessionDirectory);
        }
        this.capFinalizedReports();
    }

    public void finalizeSessionWithNativeEvent(@NonNull String previousSessionId, @NonNull CrashlyticsReport.FilesPayload ndkPayload) {
        File reportFile = new File(this.getSessionDirectoryById(previousSessionId), REPORT_FILE_NAME);
        CrashlyticsReportPersistence.synthesizeNativeReportFile(reportFile, this.nativeReportsDirectory, ndkPayload, previousSessionId);
    }

    @NonNull
    public List<CrashlyticsReportWithSessionId> loadFinalizedReports() {
        List<File> allReportFiles = this.getAllFinalizedReportFiles();
        ArrayList<CrashlyticsReportWithSessionId> allReports = new ArrayList<CrashlyticsReportWithSessionId>();
        allReports.ensureCapacity(allReportFiles.size());
        for (File reportFile : this.getAllFinalizedReportFiles()) {
            try {
                CrashlyticsReport jsonReport = TRANSFORM.reportFromJson(CrashlyticsReportPersistence.readTextFile(reportFile));
                allReports.add(CrashlyticsReportWithSessionId.create(jsonReport, reportFile.getName()));
            }
            catch (IOException e) {
                Logger.getLogger().d("Could not load report file " + reportFile + "; deleting", e);
                reportFile.delete();
            }
        }
        return allReports;
    }

    @NonNull
    private List<File> capAndGetOpenSessions(@Nullable String currentSessionId) {
        FileFilter sessionDirectoryFilter = CrashlyticsReportPersistence$$Lambda$2.lambdaFactory$(currentSessionId);
        List<File> openSessionDirectories = CrashlyticsReportPersistence.getFilesInDirectory(this.openSessionsDirectory, sessionDirectoryFilter);
        Collections.sort(openSessionDirectories, LATEST_SESSION_ID_FIRST_COMPARATOR);
        if (openSessionDirectories.size() <= 8) {
            return openSessionDirectories;
        }
        List<File> openSessionDirectoriesToRemove = openSessionDirectories.subList(8, openSessionDirectories.size());
        for (File openSessionDirectory : openSessionDirectoriesToRemove) {
            CrashlyticsReportPersistence.recursiveDelete(openSessionDirectory);
        }
        return openSessionDirectories.subList(0, 8);
    }

    private void capFinalizedReports() {
        int maxReportsToKeep = this.settingsDataProvider.getSettings().getSessionData().maxCompleteSessionsCount;
        List<File> finalizedReportFiles = this.getAllFinalizedReportFiles();
        int fileCount = finalizedReportFiles.size();
        if (fileCount <= maxReportsToKeep) {
            return;
        }
        List<File> filesToRemove = finalizedReportFiles.subList(maxReportsToKeep, fileCount);
        for (File reportFile : filesToRemove) {
            reportFile.delete();
        }
    }

    @NonNull
    private List<File> getAllFinalizedReportFiles() {
        return CrashlyticsReportPersistence.sortAndCombineReportFiles(CrashlyticsReportPersistence.combineReportFiles(CrashlyticsReportPersistence.getAllFilesInDirectory(this.priorityReportsDirectory), CrashlyticsReportPersistence.getAllFilesInDirectory(this.nativeReportsDirectory)), CrashlyticsReportPersistence.getAllFilesInDirectory(this.reportsDirectory));
    }

    @NonNull
    private File getSessionDirectoryById(@NonNull String sessionId) {
        return new File(this.openSessionsDirectory, sessionId);
    }

    private void synthesizeReport(@NonNull File sessionDirectory, long sessionEndTime) {
        List<File> eventFiles = CrashlyticsReportPersistence.getFilesInDirectory(sessionDirectory, EVENT_FILE_FILTER);
        if (eventFiles.isEmpty()) {
            Logger.getLogger().d("Session " + sessionDirectory.getName() + " has no events.");
            return;
        }
        Collections.sort(eventFiles);
        ArrayList<CrashlyticsReport.Session.Event> events = new ArrayList<CrashlyticsReport.Session.Event>();
        boolean isHighPriorityReport = false;
        for (File eventFile : eventFiles) {
            try {
                events.add(TRANSFORM.eventFromJson(CrashlyticsReportPersistence.readTextFile(eventFile)));
                isHighPriorityReport = isHighPriorityReport || CrashlyticsReportPersistence.isHighPriorityEventFile(eventFile.getName());
            }
            catch (IOException e) {
                Logger.getLogger().d("Could not add event to report for " + eventFile, e);
            }
        }
        String userId = null;
        File userIdFile = new File(sessionDirectory, USER_FILE_NAME);
        if (userIdFile.isFile()) {
            try {
                userId = CrashlyticsReportPersistence.readTextFile(userIdFile);
            }
            catch (IOException e) {
                Logger.getLogger().d("Could not read user ID file in " + sessionDirectory.getName(), e);
            }
        }
        File reportFile = new File(sessionDirectory, REPORT_FILE_NAME);
        File outputDirectory = isHighPriorityReport ? this.priorityReportsDirectory : this.reportsDirectory;
        CrashlyticsReportPersistence.synthesizeReportFile(reportFile, outputDirectory, events, sessionEndTime, isHighPriorityReport, userId);
    }

    private static void synthesizeNativeReportFile(@NonNull File reportFile, @NonNull File outputDirectory, @NonNull CrashlyticsReport.FilesPayload ndkPayload, @NonNull String previousSessionId) {
        try {
            CrashlyticsReport report = TRANSFORM.reportFromJson(CrashlyticsReportPersistence.readTextFile(reportFile)).withNdkPayload(ndkPayload);
            CrashlyticsReportPersistence.writeTextFile(new File(CrashlyticsReportPersistence.prepareDirectory(outputDirectory), previousSessionId), TRANSFORM.reportToJson(report));
        }
        catch (IOException e) {
            Logger.getLogger().d("Could not synthesize final native report file for " + reportFile, e);
        }
    }

    private static void synthesizeReportFile(@NonNull File reportFile, @NonNull File outputDirectory, @NonNull List<CrashlyticsReport.Session.Event> events, long sessionEndTime, boolean isCrashed, @Nullable String userId) {
        try {
            CrashlyticsReport report = TRANSFORM.reportFromJson(CrashlyticsReportPersistence.readTextFile(reportFile)).withSessionEndFields(sessionEndTime, isCrashed, userId).withEvents(ImmutableList.from(events));
            CrashlyticsReport.Session session = report.getSession();
            if (session == null) {
                return;
            }
            CrashlyticsReportPersistence.writeTextFile(new File(CrashlyticsReportPersistence.prepareDirectory(outputDirectory), session.getIdentifier()), TRANSFORM.reportToJson(report));
        }
        catch (IOException e) {
            Logger.getLogger().d("Could not synthesize final report file for " + reportFile, e);
        }
    }

    @NonNull
    private static List<File> sortAndCombineReportFiles(List<File> ... reports) {
        for (List<File> reportList : reports) {
            Collections.sort(reportList, LATEST_SESSION_ID_FIRST_COMPARATOR);
        }
        return CrashlyticsReportPersistence.combineReportFiles(reports);
    }

    @NonNull
    private static List<File> combineReportFiles(List<File> ... reports) {
        ArrayList<File> allReportsFiles = new ArrayList<File>();
        int totalReports = 0;
        for (List<File> reportList : reports) {
            totalReports += reportList.size();
        }
        allReportsFiles.ensureCapacity(totalReports);
        for (List<File> reportList : reports) {
            allReportsFiles.addAll(reportList);
        }
        return allReportsFiles;
    }

    private static boolean isHighPriorityEventFile(@NonNull String fileName) {
        return fileName.startsWith(EVENT_FILE_NAME_PREFIX) && fileName.endsWith(PRIORITY_EVENT_SUFFIX);
    }

    private static boolean isNormalPriorityEventFile(@NonNull File dir, @NonNull String name) {
        return name.startsWith(EVENT_FILE_NAME_PREFIX) && !name.endsWith(PRIORITY_EVENT_SUFFIX);
    }

    @NonNull
    private static String generateEventFilename(int eventNumber, boolean isHighPriority) {
        String paddedEventNumber = String.format(Locale.US, EVENT_COUNTER_FORMAT, eventNumber);
        String prioritySuffix = isHighPriority ? PRIORITY_EVENT_SUFFIX : NORMAL_EVENT_SUFFIX;
        return EVENT_FILE_NAME_PREFIX + paddedEventNumber + prioritySuffix;
    }

    private static int trimEvents(@NonNull File sessionDirectory, int maximum) {
        List<File> normalPriorityEventFiles = CrashlyticsReportPersistence.getFilesInDirectory(sessionDirectory, CrashlyticsReportPersistence$$Lambda$3.lambdaFactory$());
        Collections.sort(normalPriorityEventFiles, CrashlyticsReportPersistence$$Lambda$4.lambdaFactory$());
        return CrashlyticsReportPersistence.capFilesCount(normalPriorityEventFiles, maximum);
    }

    @NonNull
    private static String getEventNameWithoutPriority(@NonNull String eventFileName) {
        return eventFileName.substring(0, EVENT_NAME_LENGTH);
    }

    private static int oldestEventFileFirst(@NonNull File f1, @NonNull File f2) {
        String name1 = CrashlyticsReportPersistence.getEventNameWithoutPriority(f1.getName());
        String name2 = CrashlyticsReportPersistence.getEventNameWithoutPriority(f2.getName());
        return name1.compareTo(name2);
    }

    @NonNull
    private static List<File> getAllFilesInDirectory(@NonNull File directory) {
        return CrashlyticsReportPersistence.getFilesInDirectory(directory, (FileFilter)null);
    }

    @NonNull
    private static List<File> getFilesInDirectory(@NonNull File directory, @Nullable FilenameFilter filter) {
        if (!directory.isDirectory()) {
            return Collections.emptyList();
        }
        File[] files = filter == null ? directory.listFiles() : directory.listFiles(filter);
        return files != null ? Arrays.asList(files) : Collections.emptyList();
    }

    @NonNull
    private static List<File> getFilesInDirectory(@NonNull File directory, @Nullable FileFilter filter) {
        if (!directory.isDirectory()) {
            return Collections.emptyList();
        }
        File[] files = filter == null ? directory.listFiles() : directory.listFiles(filter);
        return files != null ? Arrays.asList(files) : Collections.emptyList();
    }

    @NonNull
    private static File prepareDirectory(@NonNull File directory) throws IOException {
        if (!CrashlyticsReportPersistence.makeDirectory(directory)) {
            throw new IOException("Could not create directory " + directory);
        }
        return directory;
    }

    private static boolean makeDirectory(@NonNull File directory) {
        return directory.exists() || directory.mkdirs();
    }

    private static void writeTextFile(File file, String text) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF_8);
        try {
            writer.write(text);
        }
        catch (Throwable throwable) {
            try {
                writer.close();
            }
            catch (Throwable throwable2) {
            }
            throw throwable;
        }
        writer.close();
    }

    @NonNull
    private static String readTextFile(@NonNull File file) throws IOException {
        String string;
        byte[] readBuffer = new byte[8192];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileInputStream fileInput = new FileInputStream(file);
        try {
            int read;
            while ((read = fileInput.read(readBuffer)) > 0) {
                bos.write(readBuffer, 0, read);
            }
            string = new String(bos.toByteArray(), UTF_8);
        }
        catch (Throwable throwable) {
            try {
                fileInput.close();
            }
            catch (Throwable throwable2) {
            }
            throw throwable;
        }
        fileInput.close();
        return string;
    }

    private static int capFilesCount(List<File> files, int maximum) {
        int numRetained = files.size();
        for (File f : files) {
            if (numRetained <= maximum) {
                return numRetained;
            }
            CrashlyticsReportPersistence.recursiveDelete(f);
            --numRetained;
        }
        return numRetained;
    }

    private static void recursiveDelete(@Nullable File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                CrashlyticsReportPersistence.recursiveDelete(f);
            }
        }
        file.delete();
    }

    static /* synthetic */ boolean lambda$capAndGetOpenSessions$3(String currentSessionId, File f) {
        return f.isDirectory() && !f.getName().equals(currentSessionId);
    }

    static /* synthetic */ boolean lambda$deleteFinalizedReport$2(String sessionId, File d, String f) {
        return f.startsWith(sessionId);
    }

    static /* synthetic */ boolean lambda$static$1(File f, String name) {
        return name.startsWith(EVENT_FILE_NAME_PREFIX);
    }

    static /* synthetic */ int lambda$static$0(File f1, File f2) {
        return f2.getName().compareTo(f1.getName());
    }

    static /* synthetic */ boolean access$lambda$0(File file, String string) {
        return CrashlyticsReportPersistence.isNormalPriorityEventFile(file, string);
    }

    static /* synthetic */ int access$lambda$1(File file, File file2) {
        return CrashlyticsReportPersistence.oldestEventFileFirst(file, file2);
    }
}

