/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.analytics;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventLogger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsEventReceiver;
import com.google.firebase.crashlytics.internal.analytics.CrashlyticsOriginAnalyticsEventLogger;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class BlockingAnalyticsEventLogger
implements AnalyticsEventReceiver,
AnalyticsEventLogger {
    static final String APP_EXCEPTION_EVENT_NAME = "_ae";
    private final CrashlyticsOriginAnalyticsEventLogger baseAnalyticsEventLogger;
    private final int timeout;
    private final TimeUnit timeUnit;
    private final Object latchLock = new Object();
    private CountDownLatch eventLatch;
    private boolean callbackReceived = false;

    public BlockingAnalyticsEventLogger(@NonNull CrashlyticsOriginAnalyticsEventLogger baseAnalyticsEventLogger, int timeout, TimeUnit timeUnit) {
        this.baseAnalyticsEventLogger = baseAnalyticsEventLogger;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logEvent(@NonNull String name, @Nullable Bundle params) {
        Object object = this.latchLock;
        synchronized (object) {
            Logger.getLogger().d("Logging Crashlytics event to Firebase");
            this.eventLatch = new CountDownLatch(1);
            this.callbackReceived = false;
            this.baseAnalyticsEventLogger.logEvent(name, params);
            Logger.getLogger().d("Awaiting app exception callback from FA...");
            try {
                if (this.eventLatch.await(this.timeout, this.timeUnit)) {
                    this.callbackReceived = true;
                    Logger.getLogger().d("App exception callback received from FA listener.");
                } else {
                    Logger.getLogger().d("Timeout exceeded while awaiting app exception callback from FA listener.");
                }
            }
            catch (InterruptedException ie) {
                Logger.getLogger().d("Interrupted while awaiting app exception callback from FA listener.");
            }
            this.eventLatch = null;
        }
    }

    @Override
    public void onEvent(@NonNull String name, @NonNull Bundle params) {
        CountDownLatch eventLatch = this.eventLatch;
        if (eventLatch == null) {
            return;
        }
        if (APP_EXCEPTION_EVENT_NAME.equals(name)) {
            eventLatch.countDown();
        }
    }

    boolean isCallbackReceived() {
        return this.callbackReceived;
    }
}

