/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.common;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.common.NativeSessionFile;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;

class BytesBackedNativeSessionFile
implements NativeSessionFile {
    @Nullable
    private final byte[] bytes;
    @NonNull
    private final String dataTransportFilename;
    @NonNull
    private final String reportsEndpointFilename;

    BytesBackedNativeSessionFile(@NonNull String dataTransportFilename, @NonNull String reportsEndpointFilename, @Nullable byte[] bytes) {
        this.dataTransportFilename = dataTransportFilename;
        this.reportsEndpointFilename = reportsEndpointFilename;
        this.bytes = bytes;
    }

    @Override
    @NonNull
    public String getReportsEndpointFilename() {
        return this.reportsEndpointFilename;
    }

    @Override
    @Nullable
    public InputStream getStream() {
        return this.isEmpty() ? null : new ByteArrayInputStream(this.bytes);
    }

    @Override
    @Nullable
    public CrashlyticsReport.FilesPayload.File asFilePayload() {
        byte[] gzippedBytes = this.asGzippedBytes();
        return gzippedBytes == null ? null : CrashlyticsReport.FilesPayload.File.builder().setContents(gzippedBytes).setFilename(this.dataTransportFilename).build();
    }

    private boolean isEmpty() {
        return this.bytes == null || this.bytes.length == 0;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private byte[] asGzippedBytes() {
        if (this.isEmpty()) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                byte[] byArray;
                GZIPOutputStream gos = new GZIPOutputStream(bos);
                Throwable throwable2 = null;
                try {
                    gos.write(this.bytes);
                    gos.finish();
                    byArray = bos.toByteArray();
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            BytesBackedNativeSessionFile.$closeResource(throwable2, gos);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                BytesBackedNativeSessionFile.$closeResource(throwable2, gos);
                return byArray;
            }
            finally {
                BytesBackedNativeSessionFile.$closeResource(throwable, bos);
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    private static /* synthetic */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
            }
        } else {
            x1.close();
        }
    }
}

