/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.log;

import android.content.Context;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.log.FileLogStore;
import com.google.firebase.crashlytics.internal.log.QueueFileLogStore;
import java.io.File;
import java.util.Set;

public class LogFileManager {
    private static final String COLLECT_CUSTOM_LOGS = "com.crashlytics.CollectCustomLogs";
    private static final String LOGFILE_EXT = ".temp";
    private static final String LOGFILE_PREFIX = "crashlytics-userlog-";
    private static final NoopLogStore NOOP_LOG_STORE = new NoopLogStore();
    static final int MAX_LOG_SIZE = 65536;
    private final Context context;
    private final DirectoryProvider directoryProvider;
    private FileLogStore currentLog;

    public LogFileManager(Context context, DirectoryProvider directoryProvider) {
        this(context, directoryProvider, null);
    }

    public LogFileManager(Context context, DirectoryProvider directoryProvider, String currentSessionId) {
        this.context = context;
        this.directoryProvider = directoryProvider;
        this.currentLog = NOOP_LOG_STORE;
        this.setCurrentSession(currentSessionId);
    }

    public final void setCurrentSession(String sessionId) {
        this.currentLog.closeLogFile();
        this.currentLog = NOOP_LOG_STORE;
        if (sessionId == null) {
            return;
        }
        boolean isLoggingEnabled = CommonUtils.getBooleanResourceValue(this.context, COLLECT_CUSTOM_LOGS, true);
        if (!isLoggingEnabled) {
            Logger.getLogger().d("FirebaseCrashlytics", "Preferences requested no custom logs. Aborting log file creation.");
            return;
        }
        this.setLogFile(this.getWorkingFileForSession(sessionId), 65536);
    }

    public void writeToLog(long timestamp, String msg) {
        this.currentLog.writeToLog(timestamp, msg);
    }

    public byte[] getBytesForLog() {
        return this.currentLog.getLogAsBytes();
    }

    public String getLogString() {
        return this.currentLog.getLogAsString();
    }

    public void clearLog() {
        this.currentLog.deleteLogFile();
    }

    public void discardOldLogFiles(Set<String> sessionIdsToKeep) {
        File[] logFiles = this.directoryProvider.getLogFileDir().listFiles();
        if (logFiles != null) {
            for (File file : logFiles) {
                if (sessionIdsToKeep.contains(this.getSessionIdForFile(file))) continue;
                file.delete();
            }
        }
    }

    void setLogFile(File workingFile, int maxLogSize) {
        this.currentLog = new QueueFileLogStore(workingFile, maxLogSize);
    }

    private File getWorkingFileForSession(String sessionId) {
        String fileName = LOGFILE_PREFIX + sessionId + LOGFILE_EXT;
        return new File(this.directoryProvider.getLogFileDir(), fileName);
    }

    private String getSessionIdForFile(File workingFile) {
        String filename = workingFile.getName();
        int indexOfExtension = filename.lastIndexOf(LOGFILE_EXT);
        if (indexOfExtension == -1) {
            return filename;
        }
        return filename.substring(LOGFILE_PREFIX.length(), indexOfExtension);
    }

    private static final class NoopLogStore
    implements FileLogStore {
        private NoopLogStore() {
        }

        @Override
        public void writeToLog(long timestamp, String msg) {
        }

        @Override
        public byte[] getLogAsBytes() {
            return null;
        }

        @Override
        public String getLogAsString() {
            return null;
        }

        @Override
        public void closeLogFile() {
        }

        @Override
        public void deleteLogFile() {
        }
    }

    public static interface DirectoryProvider {
        public File getLogFileDir();
    }
}

