/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.core;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.crashlytics.core.CrashlyticsBackgroundWorker;
import com.google.firebase.crashlytics.core.CrashlyticsController;
import com.google.firebase.crashlytics.core.CrashlyticsFileMarker;
import com.google.firebase.crashlytics.core.Utils;
import com.google.firebase.crashlytics.internal.CrashlyticsNativeComponent;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.analytics.AnalyticsConnectorReceiver;
import com.google.firebase.crashlytics.internal.common.AppData;
import com.google.firebase.crashlytics.internal.common.CommonUtils;
import com.google.firebase.crashlytics.internal.common.DataCollectionArbiter;
import com.google.firebase.crashlytics.internal.common.ExecutorUtils;
import com.google.firebase.crashlytics.internal.common.IdManager;
import com.google.firebase.crashlytics.internal.network.HttpRequestFactory;
import com.google.firebase.crashlytics.internal.persistence.FileStoreImpl;
import com.google.firebase.crashlytics.internal.settings.SettingsDataProvider;
import com.google.firebase.crashlytics.internal.settings.model.Settings;
import com.google.firebase.crashlytics.internal.unity.ResourceUnityVersionProvider;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CrashlyticsCore {
    private static final String MISSING_BUILD_ID_MSG = "The Crashlytics build ID is missing. This occurs when Crashlytics tooling is absent from your app's build configuration. Please review Crashlytics onboarding instructions and ensure you have a valid Crashlytics account.";
    private static final float CLS_DEFAULT_PROCESS_DELAY = 1.0f;
    static final String CRASHLYTICS_REQUIRE_BUILD_ID = "com.crashlytics.RequireBuildId";
    static final boolean CRASHLYTICS_REQUIRE_BUILD_ID_DEFAULT = true;
    static final int DEFAULT_MAIN_HANDLER_TIMEOUT_SEC = 4;
    private static final String INITIALIZATION_MARKER_FILE_NAME = "initialization_marker";
    static final String CRASH_MARKER_FILE_NAME = "crash_marker";
    private final Context context;
    private final FirebaseApp app;
    private final DataCollectionArbiter dataCollectionArbiter;
    private final long startTime;
    private CrashlyticsFileMarker initializationMarker;
    private CrashlyticsFileMarker crashMarker;
    private boolean didCrashOnPreviousExecution;
    private CrashlyticsController controller;
    private final IdManager idManager;
    private final AnalyticsConnector analyticsConnector;
    private ExecutorService crashHandlerExecutor;
    private CrashlyticsBackgroundWorker backgroundWorker;
    private CrashlyticsNativeComponent nativeComponent;

    public CrashlyticsCore(FirebaseApp app, IdManager idManager, CrashlyticsNativeComponent nativeComponent, DataCollectionArbiter dataCollectionArbiter, AnalyticsConnector analyticsConnector) {
        this(app, idManager, nativeComponent, dataCollectionArbiter, analyticsConnector, ExecutorUtils.buildSingleThreadExecutorService("Crashlytics Exception Handler"));
    }

    CrashlyticsCore(FirebaseApp app, IdManager idManager, CrashlyticsNativeComponent nativeComponent, DataCollectionArbiter dataCollectionArbiter, AnalyticsConnector analyticsConnector, ExecutorService crashHandlerExecutor) {
        this.app = app;
        this.dataCollectionArbiter = dataCollectionArbiter;
        this.context = app.getApplicationContext();
        this.idManager = idManager;
        this.nativeComponent = nativeComponent;
        this.analyticsConnector = analyticsConnector;
        this.crashHandlerExecutor = crashHandlerExecutor;
        this.backgroundWorker = new CrashlyticsBackgroundWorker(crashHandlerExecutor);
        this.startTime = System.currentTimeMillis();
    }

    public boolean onPreExecute(SettingsDataProvider settingsProvider) {
        String mappingFileId = CommonUtils.getMappingFileId(this.context);
        Logger.getLogger().d("FirebaseCrashlytics", "Mapping file id is: " + mappingFileId);
        boolean requiresBuildId = CommonUtils.getBooleanResourceValue(this.context, CRASHLYTICS_REQUIRE_BUILD_ID, true);
        if (!CrashlyticsCore.isBuildIdValid(mappingFileId, requiresBuildId)) {
            throw new IllegalStateException(MISSING_BUILD_ID_MSG);
        }
        String googleAppId = this.app.getOptions().getApplicationId();
        try {
            Logger.getLogger().i("FirebaseCrashlytics", "Initializing Crashlytics " + CrashlyticsCore.getVersion());
            FileStoreImpl fileStore = new FileStoreImpl(this.context);
            this.crashMarker = new CrashlyticsFileMarker(CRASH_MARKER_FILE_NAME, fileStore);
            this.initializationMarker = new CrashlyticsFileMarker(INITIALIZATION_MARKER_FILE_NAME, fileStore);
            HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
            AppData appData = AppData.create(this.context, this.idManager, googleAppId, mappingFileId);
            ResourceUnityVersionProvider unityVersionProvider = new ResourceUnityVersionProvider(this.context);
            AnalyticsConnectorReceiver analyticsReceiver = new AnalyticsConnectorReceiver(this.analyticsConnector, new AnalyticsConnectorReceiver.BreadcrumbHandler(){

                @Override
                public void dropBreadcrumb(String breadcrumb) {
                    CrashlyticsCore.this.log(breadcrumb);
                }
            });
            Logger.getLogger().d("FirebaseCrashlytics", "Installer package name is: " + appData.installerPackageName);
            this.controller = new CrashlyticsController(this.context, this.backgroundWorker, httpRequestFactory, this.idManager, this.dataCollectionArbiter, fileStore, this.crashMarker, appData, null, null, this.nativeComponent, unityVersionProvider, analyticsReceiver, this.analyticsConnector);
            boolean initializeSynchronously = this.didPreviousInitializationFail();
            this.checkForPreviousCrash();
            this.controller.enableExceptionHandling(Thread.getDefaultUncaughtExceptionHandler(), settingsProvider);
            if (initializeSynchronously && CommonUtils.canTryConnection(this.context)) {
                Logger.getLogger().d("FirebaseCrashlytics", "Crashlytics did not finish previous background initialization. Initializing synchronously.");
                this.finishInitSynchronously(settingsProvider);
                return false;
            }
        }
        catch (Exception e) {
            Logger.getLogger().e("FirebaseCrashlytics", "Crashlytics was not started due to an exception during initialization", e);
            this.controller = null;
            return false;
        }
        Logger.getLogger().d("FirebaseCrashlytics", "Exception handling initialization successful");
        return true;
    }

    public Task<Void> doBackgroundInitializationAsync(final SettingsDataProvider settingsProvider) {
        return Utils.callTask(this.crashHandlerExecutor, new Callable<Task<Void>>(){

            @Override
            public Task<Void> call() throws Exception {
                return CrashlyticsCore.this.doBackgroundInitialization(settingsProvider);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> doBackgroundInitialization(SettingsDataProvider settingsProvider) {
        this.markInitializationStarted();
        this.controller.cleanInvalidTempFiles();
        try {
            this.controller.registerAnalyticsListener();
            Settings settingsData = settingsProvider.getSettings();
            if (!settingsData.getFeaturesData().collectReports) {
                Logger.getLogger().d("FirebaseCrashlytics", "Collection of crash reports disabled in Crashlytics settings.");
                Task task = Tasks.forException((Exception)new RuntimeException("Collection of crash reports disabled in Crashlytics settings."));
                return task;
            }
            if (!this.controller.finalizeNativeSessions()) {
                Logger.getLogger().d("FirebaseCrashlytics", "Could not finalize native sessions.");
            }
            if (!this.controller.finalizeSessions(settingsData.getSessionData().maxCustomExceptionEvents)) {
                Logger.getLogger().d("FirebaseCrashlytics", "Could not finalize previous sessions.");
            }
            Task<Void> task = this.controller.submitAllReports(1.0f, settingsProvider.getAppSettings());
            return task;
        }
        catch (Exception e) {
            Logger.getLogger().e("FirebaseCrashlytics", "Crashlytics encountered a problem during asynchronous initialization.", e);
            Task task = Tasks.forException((Exception)e);
            return task;
        }
        finally {
            this.markInitializationComplete();
        }
    }

    public void setCrashlyticsCollectionEnabled(boolean enabled) {
        this.dataCollectionArbiter.setCrashlyticsDataCollectionEnabled(enabled);
    }

    @NonNull
    public Task<Boolean> checkForUnsentReports() {
        return this.controller.checkForUnsentReports();
    }

    public Task<Void> sendUnsentReports() {
        return this.controller.sendUnsentReports();
    }

    public Task<Void> deleteUnsentReports() {
        return this.controller.deleteUnsentReports();
    }

    public static String getVersion() {
        return "17.0.0-beta02";
    }

    public void logException(Throwable throwable) {
        if (throwable == null) {
            Logger.getLogger().log(5, "FirebaseCrashlytics", "Crashlytics is ignoring a request to log a null exception.");
            return;
        }
        this.controller.writeNonFatalException(Thread.currentThread(), throwable);
    }

    public void log(String msg) {
        long timestamp = System.currentTimeMillis() - this.startTime;
        this.controller.writeToLog(timestamp, msg);
    }

    public void setUserId(String identifier) {
        this.controller.setUserId(identifier);
    }

    public void setCustomKey(String key, String value) {
        this.controller.setCustomKey(key, value);
    }

    CrashlyticsController getController() {
        return this.controller;
    }

    private void finishInitSynchronously(final SettingsDataProvider settingsDataProvider) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CrashlyticsCore.this.doBackgroundInitialization(settingsDataProvider);
            }
        };
        Future<?> future = this.crashHandlerExecutor.submit(runnable);
        Logger.getLogger().d("FirebaseCrashlytics", "Crashlytics detected incomplete initialization on previous app launch. Will initialize synchronously.");
        try {
            future.get(4L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.getLogger().e("FirebaseCrashlytics", "Crashlytics was interrupted during initialization.", e);
        }
        catch (ExecutionException e) {
            Logger.getLogger().e("FirebaseCrashlytics", "Problem encountered during Crashlytics initialization.", e);
        }
        catch (TimeoutException e) {
            Logger.getLogger().e("FirebaseCrashlytics", "Crashlytics timed out during initialization.", e);
        }
    }

    void markInitializationStarted() {
        this.backgroundWorker.checkRunningOnThread();
        this.initializationMarker.create();
        Logger.getLogger().d("FirebaseCrashlytics", "Initialization marker file created.");
    }

    void markInitializationComplete() {
        this.backgroundWorker.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    boolean removed = CrashlyticsCore.this.initializationMarker.remove();
                    Logger.getLogger().d("FirebaseCrashlytics", "Initialization marker file removed: " + removed);
                    return removed;
                }
                catch (Exception e) {
                    Logger.getLogger().e("FirebaseCrashlytics", "Problem encountered deleting Crashlytics initialization marker.", e);
                    return false;
                }
            }
        });
    }

    boolean didPreviousInitializationFail() {
        return this.initializationMarker.isPresent();
    }

    private void checkForPreviousCrash() {
        Boolean result;
        Task<Boolean> task = this.backgroundWorker.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return CrashlyticsCore.this.controller.didCrashOnPreviousExecution();
            }
        });
        try {
            result = Utils.awaitEvenIfOnMainThread(task);
        }
        catch (Exception e) {
            this.didCrashOnPreviousExecution = false;
            return;
        }
        this.didCrashOnPreviousExecution = Boolean.TRUE.equals(result);
    }

    public boolean didCrashOnPreviousExecution() {
        return this.didCrashOnPreviousExecution;
    }

    static boolean isBuildIdValid(String buildId, boolean requiresBuildId) {
        if (!requiresBuildId) {
            Logger.getLogger().d("FirebaseCrashlytics", "Configured not to require a build ID.");
            return true;
        }
        if (!CommonUtils.isNullOrEmpty(buildId)) {
            return true;
        }
        Log.e((String)"FirebaseCrashlytics", (String)".");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  | ");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".   \\ |  | /");
        Log.e((String)"FirebaseCrashlytics", (String)".    \\    /");
        Log.e((String)"FirebaseCrashlytics", (String)".     \\  /");
        Log.e((String)"FirebaseCrashlytics", (String)".      \\/");
        Log.e((String)"FirebaseCrashlytics", (String)".");
        Log.e((String)"FirebaseCrashlytics", (String)MISSING_BUILD_ID_MSG);
        Log.e((String)"FirebaseCrashlytics", (String)".");
        Log.e((String)"FirebaseCrashlytics", (String)".      /\\");
        Log.e((String)"FirebaseCrashlytics", (String)".     /  \\");
        Log.e((String)"FirebaseCrashlytics", (String)".    /    \\");
        Log.e((String)"FirebaseCrashlytics", (String)".   / |  | \\");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".     |  |");
        Log.e((String)"FirebaseCrashlytics", (String)".");
        return false;
    }
}

