/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.internal.breadcrumbs;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.crashlytics.internal.Logger;
import com.google.firebase.crashlytics.internal.breadcrumbs.BreadcrumbsReceiver;
import org.json.JSONException;
import org.json.JSONObject;

public class AnalyticsConnectorBreadcrumbsReceiver
implements AnalyticsConnector.AnalyticsConnectorListener,
BreadcrumbsReceiver {
    static final String CRASH_ORIGIN = "crash";
    private static final String EVENT_NAME_KEY = "name";
    private static final String EVENT_PARAMS_KEY = "params";
    private static final String BREADCRUMB_PARAMS_KEY = "parameters";
    private static final String BREADCRUMB_PREFIX = "$A$:";
    private final AnalyticsConnector analyticsConnector;
    private final BreadcrumbHandler breadcrumbHandler;
    private AnalyticsConnector.AnalyticsConnectorHandle analyticsConnectorHandle;

    public AnalyticsConnectorBreadcrumbsReceiver(AnalyticsConnector analyticsConnector, BreadcrumbHandler breadcrumbHandler) {
        this.analyticsConnector = analyticsConnector;
        this.breadcrumbHandler = breadcrumbHandler;
    }

    @Override
    public boolean register() {
        if (this.analyticsConnector == null) {
            Logger.getLogger().d("FirebaseCrashlytics", "Firebase Analytics is not present; you will not see automatic logging of events before a crash occurs.");
            return false;
        }
        this.analyticsConnectorHandle = this.analyticsConnector.registerAnalyticsConnectorListener(CRASH_ORIGIN, (AnalyticsConnector.AnalyticsConnectorListener)this);
        return this.analyticsConnectorHandle != null;
    }

    @Override
    public void unregister() {
        if (this.analyticsConnectorHandle != null) {
            this.analyticsConnectorHandle.unregister();
        }
    }

    public void onMessageTriggered(int id, @Nullable Bundle extras) {
        if (extras == null) {
            return;
        }
        String name = extras.getString(EVENT_NAME_KEY);
        if (name == null) {
            return;
        }
        Bundle params = extras.getBundle(EVENT_PARAMS_KEY);
        if (params == null) {
            params = new Bundle();
        }
        try {
            String serializedEvent = BREADCRUMB_PREFIX + AnalyticsConnectorBreadcrumbsReceiver.serializeEvent(name, params);
            this.breadcrumbHandler.dropBreadcrumb(serializedEvent);
        }
        catch (JSONException e) {
            Logger.getLogger().w("FirebaseCrashlytics", "Unable to serialize Firebase Analytics event.");
        }
    }

    private static String serializeEvent(@NonNull String name, @NonNull Bundle params) throws JSONException {
        JSONObject enclosingObject = new JSONObject();
        JSONObject paramsObject = new JSONObject();
        for (String key : params.keySet()) {
            paramsObject.put(key, params.get(key));
        }
        enclosingObject.put(EVENT_NAME_KEY, (Object)name);
        enclosingObject.put(BREADCRUMB_PARAMS_KEY, (Object)paramsObject);
        return enclosingObject.toString();
    }

    public static interface BreadcrumbHandler {
        public void dropBreadcrumb(String var1);
    }
}

