/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.core;

import com.google.firebase.crashlytics.internal.Logger;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class UserMetadata {
    static final int MAX_ATTRIBUTES = 64;
    static final int MAX_ATTRIBUTE_SIZE = 1024;
    private String userId = null;
    private final ConcurrentHashMap<String, String> attributes = new ConcurrentHashMap();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String identifier) {
        this.userId = UserMetadata.sanitizeAttribute(identifier);
    }

    public Map<String, String> getCustomKeys() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setCustomKey(String key, String value) {
        if (key == null) {
            throw new IllegalArgumentException("Custom attribute key must not be null.");
        }
        key = UserMetadata.sanitizeAttribute(key);
        if (this.attributes.size() >= 64 && !this.attributes.containsKey(key)) {
            Logger.getLogger().d("FirebaseCrashlytics", "Exceeded maximum number of custom attributes (64)");
            return;
        }
        value = value == null ? "" : UserMetadata.sanitizeAttribute(value);
        this.attributes.put(key, value);
    }

    private static String sanitizeAttribute(String input) {
        if (input != null && (input = input.trim()).length() > 1024) {
            input = input.substring(0, 1024);
        }
        return input;
    }
}

