/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.utils;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;

public class PropertiesUtils {
    public static final String OPT_HELP = "help";
    public static final String OPT_PROPERTIES_PATH = "properties";

    public static Properties read(File propertiesFile) throws IOException {
        Properties properties;
        InputStreamReader in = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(propertiesFile), "UTF-8");
            properties = PropertiesUtils.read(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)in);
        return properties;
    }

    public static Properties read(Reader reader) throws IOException {
        Properties props = new Properties();
        props.load(reader);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File propertiesFile, Properties props, String comment) throws IOException {
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(propertiesFile), "UTF-8");
            props.store(out, comment);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
    }

    public static void write(Writer writer, Properties props, String comments) throws IOException {
        props.store(writer, comments);
    }

    public static Properties processArgs(String mainClassName, String[] args, Options options) {
        Properties properties = null;
        try {
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(options, args);
            if (line.hasOption(OPT_HELP)) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(mainClassName, options);
            } else {
                properties = PropertiesUtils.getProperties(line);
            }
            return properties;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException((Object)((Object)e) + "\nUse -help to list available options");
        }
    }

    private static Properties getProperties(CommandLine line) {
        Properties propertiesFromDisk = new Properties();
        File propertiesFile = null;
        if (line.hasOption(OPT_PROPERTIES_PATH)) {
            propertiesFile = new File(line.getOptionValue(OPT_PROPERTIES_PATH));
            try {
                propertiesFromDisk = PropertiesUtils.read(propertiesFile);
            }
            catch (IOException io) {
                propertiesFromDisk = new Properties();
            }
        }
        Properties optionsProperties = new Properties();
        for (Option opt : line.getOptions()) {
            if (opt.hasArgs()) {
                if (opt.getValues() == null) continue;
                optionsProperties.put(opt.getOpt(), Joiner.on((String)":").join((Object[])opt.getValues()));
                continue;
            }
            if (opt.getValue() != null) {
                optionsProperties.put(opt.getOpt(), opt.getValue());
                continue;
            }
            optionsProperties.put(opt.getOpt(), "true");
        }
        propertiesFromDisk.putAll((Map<?, ?>)optionsProperties);
        return propertiesFromDisk;
    }

    public static String toString(Properties properties, Set<String> keysToSkip) {
        StringBuilder argsStr = new StringBuilder();
        for (Map.Entry<Object, Object> argEntry : properties.entrySet()) {
            if (keysToSkip.contains(argEntry.getKey())) continue;
            argsStr.append("\n-" + argEntry.getKey() + " " + argEntry.getValue());
        }
        return argsStr.toString();
    }

    public static String toString(Properties properties) {
        return PropertiesUtils.toString(properties, Collections.EMPTY_SET);
    }

    public static Properties resolveEdits(Properties originalProps, Properties editedProps, Set<String> deletedKeys) {
        Properties merged = new Properties();
        for (String key : originalProps.stringPropertyNames()) {
            if (deletedKeys.contains(key) || editedProps.containsKey(key)) continue;
            merged.setProperty(key, originalProps.getProperty(key));
        }
        for (String key : editedProps.stringPropertyNames()) {
            if (deletedKeys.contains(key)) continue;
            merged.setProperty(key, editedProps.getProperty(key));
        }
        return merged;
    }
}

