/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor;

import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DWAttribute;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.DWForm;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.AttributeProcessor;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.CompilationUnitContext;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.ReferenceBytesConverter;

public class CompileUnitAttributeProcessor
implements AttributeProcessor<CompilationUnitContext.EntryData> {
    private final ReferenceBytesConverter referenceBytesConverter;
    private long lowPc;
    private long stmtList;

    public CompileUnitAttributeProcessor(ReferenceBytesConverter referenceBytesConverter) {
        this.referenceBytesConverter = referenceBytesConverter;
    }

    @Override
    public void processAttribute(DWAttribute attribute, DWForm form, byte[] value) {
        switch (attribute) {
            case STMT_LIST: {
                this.stmtList = this.referenceBytesConverter.asLongValue(value);
                break;
            }
        }
    }

    @Override
    public void processAttribute(DWAttribute attribute, long value) {
        switch (attribute) {
            case LOW_PC: {
                this.lowPc = value;
                break;
            }
            case STMT_LIST: {
                this.stmtList = value;
                break;
            }
        }
    }

    @Override
    public void processAttribute(DWAttribute attribute, String value) {
    }

    @Override
    public CompilationUnitContext.EntryData finishProcessingAttributes() {
        return new CompilationUnitContext.EntryData(this.lowPc, this.stmtList);
    }
}

