/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor;

import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.NamedRange;
import com.google.firebase.crashlytics.buildtools.ndk.internal.dwarf.processor.NamedRangesResolver;
import com.google.firebase.crashlytics.buildtools.utils.io.ByteReader;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DefaultNamedRangesResolver
implements NamedRangesResolver {
    private final ByteReader byteReader;
    private final int addressSize;
    private final long rangesSectionOffset;

    public DefaultNamedRangesResolver(ByteReader byteReader, int addressSize, long rangesSectionOffset) {
        this.byteReader = byteReader;
        this.addressSize = addressSize;
        this.rangesSectionOffset = rangesSectionOffset;
    }

    @Override
    public List<NamedRange> resolveNamedRanges(long offset, String name, long baseAddress) {
        LinkedList<NamedRange> namedRanges = new LinkedList<NamedRange>();
        try {
            long originalOffset = this.byteReader.getCurrentOffset();
            this.byteReader.seek(this.rangesSectionOffset + offset);
            long currentBaseAddress = baseAddress;
            while (true) {
                long beginAddress = this.byteReader.readLong(this.addressSize);
                long endAddress = this.byteReader.readLong(this.addressSize);
                if (beginAddress == 0L && endAddress == 0L) break;
                if (beginAddress == -1L) {
                    currentBaseAddress = endAddress;
                    continue;
                }
                if (beginAddress >= endAddress) continue;
                namedRanges.add(new NamedRange(name, beginAddress += currentBaseAddress, endAddress += currentBaseAddress));
            }
            this.byteReader.seek(originalOffset);
        }
        catch (IOException e) {
            Buildtools.logE("Could not properly resolve range entries", e);
            return Collections.emptyList();
        }
        return namedRanges;
    }
}

