/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools.ndk.internal.csym;

import com.google.firebase.crashlytics.buildtools.Buildtools;
import com.google.firebase.crashlytics.buildtools.ndk.NativeSymbolGenerator;
import com.google.firebase.crashlytics.buildtools.ndk.internal.CodeMappingException;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.AndroidCSymIdStrategy;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSym;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSymException;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSymFactory;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSymFileWriter;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.CSymIdStrategy;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.ElfCSymFactory;
import com.google.firebase.crashlytics.buildtools.ndk.internal.csym.StandardCSymFileWriter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class NdkCSymGenerator
implements NativeSymbolGenerator {
    public static final String CSYM_SUFFIX = ".cSYM";
    private static final String NDKOUT_INCORRECT_CONFIG_MSG = "Is the -androidNdkOut setting configured correctly?";
    private static final String LIB_PREFIX = "lib";
    private static final String SO_FILE_SUFFIX = ".so";
    private static IOFileFilter SO_FILE_FILTER = FileFilterUtils.suffixFileFilter((String)".so", (IOCase)IOCase.INSENSITIVE);
    private final File outputDir;

    public NdkCSymGenerator(File outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public void generateFromDirectories(File unstrippedDir, File strippedDir) throws IOException, CodeMappingException {
        AndroidCSymIdStrategy idStrategy = new AndroidCSymIdStrategy(strippedDir);
        ElfCSymFactory cSymFactory = new ElfCSymFactory(true);
        StandardCSymFileWriter cSymFileWriter = new StandardCSymFileWriter();
        this.generateCodeMappings(this.outputDir, unstrippedDir, idStrategy, (CSymFactory)cSymFactory, (CSymFileWriter)cSymFileWriter);
    }

    @Override
    public void generateFromLibPair(File unstrippedLib, File strippedLib) throws IOException, CodeMappingException {
        ElfCSymFactory cSymFactory = new ElfCSymFactory(true);
        StandardCSymFileWriter cSymFileWriter = new StandardCSymFileWriter();
        String csymId = AndroidCSymIdStrategy.createSha1Hex(strippedLib);
        this.generateCodeMappings(this.outputDir, unstrippedLib, csymId, (CSymFactory)cSymFactory, (CSymFileWriter)cSymFileWriter);
    }

    void generateCodeMappings(File outputDir, File ndkDebugOutDir, CSymIdStrategy idStrategy, CSymFactory cSymFactory, CSymFileWriter cSymFileWriter) throws IOException, CodeMappingException {
        String soDirPath = ndkDebugOutDir.getCanonicalPath();
        if (!ndkDebugOutDir.isDirectory()) {
            throw new CodeMappingException(String.format("Crashlytics could not find NDK output directory '%s'. %s", soDirPath, NDKOUT_INCORRECT_CONFIG_MSG));
        }
        Collection soFiles = FileUtils.listFiles((File)ndkDebugOutDir, (IOFileFilter)SO_FILE_FILTER, (IOFileFilter)TrueFileFilter.INSTANCE);
        if (soFiles.isEmpty()) {
            Buildtools.logW(String.format("Crashlytics found no object files in %s. %s", soDirPath, NDKOUT_INCORRECT_CONFIG_MSG), null);
            return;
        }
        Buildtools.logD("Crashlytics generating cSYM files from object files in " + soDirPath + ":");
        com.google.firebase.crashlytics.buildtools.utils.FileUtils.verifyDirectory(outputDir);
        for (File soFile : soFiles) {
            String releaseUUID = idStrategy.createCSymIdForLibrary(soFile);
            this.generateCodeMappings(outputDir, soFile, releaseUUID, cSymFactory, cSymFileWriter);
        }
    }

    void generateCodeMappings(File outputDir, File unstrippedLibrary, String csymId, CSymFactory cSymFactory, CSymFileWriter cSymFileWriter) throws IOException, CodeMappingException {
        CSym cSym;
        Buildtools.logD("Generating symbols for " + unstrippedLibrary);
        com.google.firebase.crashlytics.buildtools.utils.FileUtils.verifyDirectory(outputDir);
        try {
            cSym = cSymFactory.createCSymFromFile(unstrippedLibrary, csymId);
        }
        catch (CSymException e) {
            throw new CodeMappingException(e);
        }
        if (cSym.getSymbols().isEmpty()) {
            Buildtools.logD("Crashlytics found no symbols for " + unstrippedLibrary + ", skipping.");
            return;
        }
        String filename = NdkCSymGenerator.getCSymFilename(cSym, unstrippedLibrary.getName());
        cSymFileWriter.writeCSymFile(cSym, new File(outputDir, filename));
    }

    private static String getCSymFilename(CSym cSym, String binFilename) {
        String moduleName = FilenameUtils.removeExtension((String)binFilename);
        if (moduleName.startsWith(LIB_PREFIX)) {
            moduleName = moduleName.substring(LIB_PREFIX.length());
        }
        return String.format("%s-%s-%s%s", moduleName, cSym.getArchitecture(), cSym.getUUID(), CSYM_SUFFIX);
    }
}

