/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.buildtools;

import com.google.firebase.crashlytics.buildtools.Buildtools;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;

public class ApiKeyValidator {
    public static final String TEST_API_KEY = "testkey";
    protected static final String STRINGS_API_KEY = "@string/api_key";
    private static final String OPEN_SOURCE_API_KEY_PATTERN = "^0[0]*$";
    private static final Pattern HEX_PATTERN = Pattern.compile("[0-9a-f]+");

    public static boolean isValidApiKeyFormat(String apiKey) {
        if (apiKey == null) {
            return false;
        }
        if (apiKey.equals(TEST_API_KEY) || apiKey.equals(STRINGS_API_KEY)) {
            Buildtools.logD("ApiKey is " + apiKey);
            return true;
        }
        return apiKey.length() == 40 && HEX_PATTERN.matcher(apiKey).matches();
    }

    public static boolean isOpenSourceApiKeyFormat(String apiKey) {
        return apiKey != null && apiKey.matches(OPEN_SOURCE_API_KEY_PATTERN);
    }

    public static boolean isValidBuildSecretFormat(String secret) {
        return secret != null && secret.length() == 64 && HEX_PATTERN.matcher(secret).matches();
    }

    private ApiKeyValidator() {
    }

    public static String transformGoogleAppIdToApiKey(String appId) {
        return DigestUtils.sha256Hex((String)appId).substring(0, 40);
    }
}

