/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.internal;

import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigValue;
import com.google.firebase.remoteconfig.internal.ConfigGetParameterHandler;

public class FirebaseRemoteConfigValueImpl
implements FirebaseRemoteConfigValue {
    private static final String ILLEGAL_ARGUMENT_STRING_FORMAT = "[Value: %s] cannot be converted to a %s.";
    private final String value;
    private final int source;

    FirebaseRemoteConfigValueImpl(String value, int source) {
        this.value = value;
        this.source = source;
    }

    @Override
    public long asLong() {
        if (this.source == 0) {
            return 0L;
        }
        String valueAsString = this.asTrimmedString();
        try {
            return Long.valueOf(valueAsString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format(ILLEGAL_ARGUMENT_STRING_FORMAT, valueAsString, "long"), e);
        }
    }

    @Override
    public double asDouble() {
        if (this.source == 0) {
            return 0.0;
        }
        String valueAsString = this.asTrimmedString();
        try {
            return Double.valueOf(valueAsString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format(ILLEGAL_ARGUMENT_STRING_FORMAT, valueAsString, "double"), e);
        }
    }

    @Override
    public String asString() {
        if (this.source == 0) {
            return "";
        }
        this.throwIfNullValue();
        return this.value;
    }

    @Override
    public byte[] asByteArray() {
        if (this.source == 0) {
            return FirebaseRemoteConfig.DEFAULT_VALUE_FOR_BYTE_ARRAY;
        }
        return this.value.getBytes(ConfigGetParameterHandler.FRC_BYTE_ARRAY_ENCODING);
    }

    @Override
    public boolean asBoolean() throws IllegalArgumentException {
        if (this.source == 0) {
            return false;
        }
        String valueAsString = this.asTrimmedString();
        if (ConfigGetParameterHandler.TRUE_REGEX.matcher(valueAsString).matches()) {
            return true;
        }
        if (ConfigGetParameterHandler.FALSE_REGEX.matcher(valueAsString).matches()) {
            return false;
        }
        throw new IllegalArgumentException(String.format(ILLEGAL_ARGUMENT_STRING_FORMAT, valueAsString, "boolean"));
    }

    @Override
    public int getSource() {
        return this.source;
    }

    private void throwIfNullValue() {
        if (this.value == null) {
            throw new IllegalArgumentException("Value is null, and cannot be converted to the desired type.");
        }
    }

    private String asTrimmedString() {
        return this.asString().trim();
    }
}

