/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.internal.zzz;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.internal.zzanq;
import com.google.android.gms.internal.zzanr;
import com.google.android.gms.internal.zzans;
import com.google.android.gms.internal.zzant;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.GetTokenResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> aVT = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> aVU = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> aVV = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final List<String> aVW = Arrays.asList(new String[0]);
    private static final Set<String> aVX = Collections.emptySet();
    private static final Object zzaox = new Object();
    static final Map<String, FirebaseApp> aic = new ArrayMap();
    private final Context zzatc;
    private final String mName;
    private final FirebaseOptions aVY;
    private final AtomicBoolean aVZ = new AtomicBoolean(false);
    private final AtomicBoolean aWa = new AtomicBoolean();
    private final List<zza> aWb = new CopyOnWriteArrayList<zza>();
    private final List<zzb> aWc = new CopyOnWriteArrayList<zzb>();
    private final List<Object> aWd = new CopyOnWriteArrayList<Object>();
    private zzans aWe;

    @NonNull
    public Context getApplicationContext() {
        this.zzcnt();
        return this.zzatc;
    }

    @NonNull
    public String getName() {
        this.zzcnt();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zzcnt();
        return this.aVY;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)object).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return zzz.zzx((Object)this).zzg("name", (Object)this.mName).zzg("options", (Object)this.aVY).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FirebaseApp> getApps(Context context) {
        zzanr zzanr2 = zzanr.zzeu(context);
        Object object = zzaox;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(aic.values());
            Set<String> set = zzanr.P().Q();
            set.removeAll(aic.keySet());
            for (String string : set) {
                FirebaseOptions firebaseOptions = zzanr2.zztz(string);
                FirebaseApp firebaseApp = FirebaseApp.initializeApp(context, null, string);
                arrayList.add(firebaseApp);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp getInstance() {
        Object object = zzaox;
        synchronized (object) {
            FirebaseApp firebaseApp = aic.get(DEFAULT_APP_NAME);
            if (firebaseApp == null) {
                String string = String.valueOf(zzt.zzayz());
                throw new IllegalStateException(new StringBuilder(116 + String.valueOf(string).length()).append("Default FirebaseApp is not initialized in this process ").append(string).append(". Make sure to call FirebaseApp.initializeApp(Context) first.").toString());
            }
            return firebaseApp;
        }
    }

    public static FirebaseApp getInstance(@NonNull String string) {
        Object object = zzaox;
        synchronized (object) {
            String string2;
            FirebaseApp firebaseApp = aic.get(FirebaseApp.zzrq(string));
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> list = FirebaseApp.zzcnw();
            if (list.isEmpty()) {
                string2 = "";
            } else {
                String string3 = String.valueOf(zzx.zzia((String)", ").zzb(list));
                string2 = string3.length() != 0 ? "Available app names: ".concat(string3) : new String("Available app names: ");
            }
            String string4 = String.format("FirebaseApp with name %s doesn't exist. %s", string, string2);
            throw new IllegalStateException(string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp initializeApp(Context context) {
        Object object = zzaox;
        synchronized (object) {
            if (aic.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                return null;
            }
            return FirebaseApp.initializeApp(context, firebaseOptions);
        }
    }

    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions) {
        return FirebaseApp.initializeApp(context, firebaseOptions, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions, String string) {
        FirebaseApp firebaseApp;
        zzanr zzanr2 = zzanr.zzeu(context);
        FirebaseApp.zzem(context);
        String string2 = FirebaseApp.zzrq(string);
        Context context2 = context instanceof Application ? context : context.getApplicationContext();
        Object object = zzaox;
        synchronized (object) {
            zzaa.zza((!aic.containsKey(string2) ? 1 : 0) != 0, (Object)new StringBuilder(33 + String.valueOf(string2).length()).append("FirebaseApp name ").append(string2).append(" already exists!").toString());
            zzaa.zzb((Object)context2, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(context2, string2, firebaseOptions);
            aic.put(string2, firebaseApp);
        }
        zzanr2.zzg(firebaseApp);
        firebaseApp.zza(FirebaseApp.class, firebaseApp, aVT);
        if (firebaseApp.zzcnu()) {
            firebaseApp.zza(FirebaseApp.class, firebaseApp, aVU);
            firebaseApp.zza(Context.class, firebaseApp.getApplicationContext(), aVV);
        }
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzcr(boolean bl) {
        Object object = zzaox;
        synchronized (object) {
            for (FirebaseApp firebaseApp : new ArrayList<FirebaseApp>(aic.values())) {
                if (!firebaseApp.aVZ.get()) continue;
                firebaseApp.zzcs(bl);
            }
        }
    }

    public void zza(@NonNull zzans zzans2) {
        this.aWe = (zzans)zzaa.zzy((Object)zzans2);
    }

    public Task<GetTokenResult> getToken(boolean bl) {
        this.zzcnt();
        if (this.aWe == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.aWe.zzct(bl);
    }

    public void setAutomaticResourceManagementEnabled(boolean bl) {
        this.zzcnt();
        boolean bl2 = this.aVZ.compareAndSet(!bl, bl);
        if (bl2) {
            boolean bl3 = zzanq.N().O();
            if (bl && bl3) {
                this.zzcs(true);
            } else if (!bl && bl3) {
                this.zzcs(false);
            }
        }
    }

    protected FirebaseApp(Context context, String string, FirebaseOptions firebaseOptions) {
        this.zzatc = (Context)zzaa.zzy((Object)context);
        this.mName = zzaa.zzib((String)string);
        this.aVY = (FirebaseOptions)zzaa.zzy((Object)firebaseOptions);
    }

    private void zzcnt() {
        zzaa.zza((!this.aWa.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    public boolean zzcnu() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @UiThread
    public void zza(@NonNull zzant zzant2) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        for (zza zza2 : this.aWb) {
            zza2.zzb(zzant2);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private void zzcs(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        for (zzb zzb2 : this.aWc) {
            zzb2.zzcr(bl);
        }
    }

    public void zza(@NonNull zza zza2) {
        this.zzcnt();
        zzaa.zzy((Object)zza2);
        this.aWb.add(zza2);
    }

    public void zza(zzb zzb2) {
        this.zzcnt();
        if (this.aVZ.get() && zzanq.N().O()) {
            zzb2.zzcr(true);
        }
        this.aWc.add(zzb2);
    }

    public String zzcnv() {
        String string = String.valueOf(com.google.android.gms.common.util.zzc.zzs((byte[])this.getName().getBytes()));
        String string2 = String.valueOf(com.google.android.gms.common.util.zzc.zzs((byte[])this.getOptions().getApplicationId().getBytes()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("+").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzcnw() {
        com.google.android.gms.common.util.zza zza2 = new com.google.android.gms.common.util.zza();
        ArrayList<String> arrayList = zzaox;
        synchronized (arrayList) {
            for (FirebaseApp firebaseApp : aic.values()) {
                zza2.add(firebaseApp.getName());
            }
            zzanr zzanr2 = zzanr.P();
            if (zzanr2 != null) {
                zza2.addAll(zzanr2.Q());
            }
        }
        arrayList = new ArrayList<String>((Collection<String>)zza2);
        Collections.sort(arrayList);
        return arrayList;
    }

    private void zzcnx() {
        this.zza(FirebaseApp.class, this, aVT);
        if (this.zzcnu()) {
            this.zza(FirebaseApp.class, this, aVU);
            this.zza(Context.class, this.zzatc, aVV);
        }
    }

    private <T> void zza(Class<T> clazz, T t, Iterable<String> iterable) {
        boolean bl = ContextCompat.isDeviceProtectedStorage((Context)this.zzatc);
        if (bl) {
            zzc.zzen(this.zzatc);
        }
        for (String string : iterable) {
            try {
                Class<?> clazz2;
                Method method;
                int n;
                if (bl && !aVW.contains(string) || !Modifier.isPublic(n = (method = (clazz2 = Class.forName(string)).getMethod("getInstance", clazz)).getModifiers()) || !Modifier.isStatic(n)) continue;
                method.invoke(null, t);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (aVX.contains(string)) {
                    throw new IllegalStateException(String.valueOf(string).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d((String)"FirebaseApp", (String)String.valueOf(string).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(String.valueOf(string).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string2 = String.valueOf(string);
                Log.wtf((String)"FirebaseApp", (String)(string2.length() != 0 ? "Failed to initialize ".concat(string2) : new String("Failed to initialize ")), (Throwable)illegalAccessException);
            }
        }
    }

    private static String zzrq(@NonNull String string) {
        return string.trim();
    }

    @TargetApi(value=14)
    private static void zzem(Context context) {
        if (zzs.zzayq() && context.getApplicationContext() instanceof Application) {
            Application application = (Application)context.getApplicationContext();
            zzanq.zza(application);
        }
    }

    @TargetApi(value=24)
    private static class zzc
    extends BroadcastReceiver {
        private static AtomicReference<zzc> aWf = new AtomicReference();
        private final Context zzatc;

        public zzc(Context context) {
            this.zzatc = context;
        }

        private static void zzen(Context context) {
            zzc zzc2;
            if (aWf.get() == null && aWf.compareAndSet(null, zzc2 = new zzc(context))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                intentFilter.addDataScheme("package");
                context.registerReceiver((BroadcastReceiver)zzc2, intentFilter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Object object = zzaox;
            synchronized (object) {
                for (FirebaseApp firebaseApp : aic.values()) {
                    firebaseApp.zzcnx();
                }
            }
            this.unregister();
        }

        public void unregister() {
            this.zzatc.unregisterReceiver((BroadcastReceiver)this);
        }
    }

    public static interface zzb {
        public void zzcr(boolean var1);
    }

    public static interface zza {
        public void zzb(@NonNull zzant var1);
    }
}

