/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.util.Strings;
import com.google.firebase.annotations.PublicApi;

@PublicApi
public final class FirebaseOptions {
    private final String zza;
    private final String zzb;
    private final String zzc;
    private final String zzd;
    private final String zze;
    private final String zzf;
    private final String zzg;

    /*
     * WARNING - void declaration
     */
    private FirebaseOptions(@NonNull String applicationId, @NonNull String apiKey, @Nullable String databaseUrl, @Nullable String gaTrackingId, @Nullable String gcmSenderId, @Nullable String storageBucket, @Nullable String projectId) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkState((!Strings.isEmptyOrWhitespace((String)applicationId) ? 1 : 0) != 0, (Object)"ApplicationId must be set.");
        this.zzb = var1_1;
        this.zza = var2_2;
        this.zzc = var3_3;
        this.zzd = gaTrackingId;
        this.zze = gcmSenderId;
        this.zzf = storageBucket;
        this.zzg = projectId;
    }

    @PublicApi
    public static FirebaseOptions fromResource(Context context) {
        Context context2;
        String string = (context2 = new StringResourceValueReader(context2)).getString("google_app_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        return new FirebaseOptions(string, context2.getString("google_api_key"), context2.getString("firebase_database_url"), context2.getString("ga_trackingId"), context2.getString("gcm_defaultSenderId"), context2.getString("google_storage_bucket"), context2.getString("project_id"));
    }

    @PublicApi
    public final String getApiKey() {
        return this.zza;
    }

    @PublicApi
    public final String getApplicationId() {
        return this.zzb;
    }

    @PublicApi
    public final String getDatabaseUrl() {
        return this.zzc;
    }

    @KeepForSdk
    public final String getGaTrackingId() {
        return this.zzd;
    }

    @PublicApi
    public final String getGcmSenderId() {
        return this.zze;
    }

    @PublicApi
    public final String getStorageBucket() {
        return this.zzf;
    }

    @PublicApi
    public final String getProjectId() {
        return this.zzg;
    }

    public final boolean equals(Object o) {
        FirebaseOptions firebaseOptions;
        if (!(o instanceof FirebaseOptions)) {
            return false;
        }
        firebaseOptions = firebaseOptions;
        return Objects.equal((Object)this.zzb, (Object)firebaseOptions.zzb) && Objects.equal((Object)this.zza, (Object)firebaseOptions.zza) && Objects.equal((Object)this.zzc, (Object)firebaseOptions.zzc) && Objects.equal((Object)this.zzd, (Object)firebaseOptions.zzd) && Objects.equal((Object)this.zze, (Object)firebaseOptions.zze) && Objects.equal((Object)this.zzf, (Object)firebaseOptions.zzf) && Objects.equal((Object)this.zzg, (Object)firebaseOptions.zzg);
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzb, this.zza, this.zzc, this.zzd, this.zze, this.zzf, this.zzg});
    }

    public final String toString() {
        return Objects.toStringHelper((Object)this).add("applicationId", (Object)this.zzb).add("apiKey", (Object)this.zza).add("databaseUrl", (Object)this.zzc).add("gcmSenderId", (Object)this.zze).add("storageBucket", (Object)this.zzf).add("projectId", (Object)this.zzg).toString();
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ FirebaseOptions(String x0, String x1, String x2, String x3, String x4, String x5, String x6, byte by) {
        this((String)var1_1, (String)var2_2, (String)var3_3, x3, x4, x5, x6);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @PublicApi
    public static final class Builder {
        private String zza;
        private String zzb;
        private String zzc;
        private String zzd;
        private String zze;
        private String zzf;
        private String zzg;

        @PublicApi
        public Builder() {
        }

        /*
         * WARNING - void declaration
         */
        @PublicApi
        public Builder(FirebaseOptions options) {
            void var1_1;
            this.zzb = options.zzb;
            this.zza = options.zza;
            this.zzc = options.zzc;
            this.zzd = options.zzd;
            this.zze = options.zze;
            this.zzf = options.zzf;
            this.zzg = ((FirebaseOptions)var1_1).zzg;
        }

        /*
         * WARNING - void declaration
         */
        @PublicApi
        public final Builder setApiKey(@NonNull String apiKey) {
            void var1_1;
            this.zza = Preconditions.checkNotEmpty((String)var1_1, (Object)"ApiKey must be set.");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @PublicApi
        public final Builder setApplicationId(@NonNull String applicationId) {
            void var1_1;
            this.zzb = Preconditions.checkNotEmpty((String)var1_1, (Object)"ApplicationId must be set.");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @PublicApi
        public final Builder setDatabaseUrl(@Nullable String databaseUrl) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        public final Builder setGaTrackingId(@Nullable String gaTrackingId) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @PublicApi
        public final Builder setGcmSenderId(@Nullable String gcmSenderId) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @PublicApi
        public final Builder setStorageBucket(@Nullable String storageBucket) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @PublicApi
        public final Builder setProjectId(@Nullable String projectId) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        @PublicApi
        public final FirebaseOptions build() {
            return new FirebaseOptions(this.zzb, this.zza, this.zzc, this.zzd, this.zze, this.zzf, this.zzg, 0);
        }
    }
}

