/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.firebase.components.ComponentDiscoveryService;
import com.google.firebase.components.ComponentRegistrar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class zzc<T> {
    private final T zza;
    private final zzb<T> zzb;

    public static zzc<Context> zza(Context context) {
        return new zzc<Context>(context, new zza(0));
    }

    @VisibleForTesting
    private zzc(T t, zzb<T> zzb2) {
        this.zza = t;
        this.zzb = zzb2;
    }

    public final List<ComponentRegistrar> zza() {
        return zzc.zza(this.zzb.zza(this.zza));
    }

    private static List<ComponentRegistrar> zza(List<String> object) {
        ArrayList<ComponentRegistrar> arrayList = new ArrayList<ComponentRegistrar>();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            try {
                Class<?> clazz = Class.forName(string);
                if (!ComponentRegistrar.class.isAssignableFrom(clazz)) {
                    Log.w((String)"ComponentDiscovery", (String)String.format("Class %s is not an instance of %s", string, "com.google.firebase.components.ComponentRegistrar"));
                    continue;
                }
                arrayList.add((ComponentRegistrar)clazz.newInstance());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.w((String)"ComponentDiscovery", (String)String.format("Class %s is not an found.", string), (Throwable)classNotFoundException);
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.w((String)"ComponentDiscovery", (String)String.format("Could not instantiate %s.", string), (Throwable)illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                Log.w((String)"ComponentDiscovery", (String)String.format("Could not instantiate %s.", string), (Throwable)instantiationException);
            }
        }
        return arrayList;
    }

    static final class zza
    implements zzb<Context> {
        private zza() {
        }

        private static Bundle zza(Context context) {
            try {
                PackageManager packageManager = context.getPackageManager();
                if (packageManager == null) {
                    Log.w((String)"ComponentDiscovery", (String)"Context has no PackageManager.");
                    return null;
                }
                if ((context = packageManager.getServiceInfo(new ComponentName(context, ComponentDiscoveryService.class), 128)) == null) {
                    Log.w((String)"ComponentDiscovery", (String)"ComponentDiscoveryService has no service info.");
                    return null;
                }
                return context.metaData;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w((String)"ComponentDiscovery", (String)"Application info not found.");
                return null;
            }
        }

        @Override
        public final /* synthetic */ List zza(Object object) {
            object = (Context)object;
            if ((object = com.google.firebase.components.zzc$zza.zza((Context)object)) == null) {
                Log.w((String)"ComponentDiscovery", (String)"Could not retrieve metadata, returning empty list of registrars.");
                return Collections.emptyList();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : object.keySet()) {
                Object object2 = object.get(string);
                if (!"com.google.firebase.components.ComponentRegistrar".equals(object2) || !string.startsWith("com.google.firebase.components:")) continue;
                arrayList.add(string.substring(31));
            }
            return arrayList;
        }

        /* synthetic */ zza(byte by) {
            this();
        }
    }

    @VisibleForTesting
    static interface zzb<T> {
        public List<String> zza(T var1);
    }
}

