/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzbh;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.internal.aer;
import com.google.android.gms.internal.aes;
import com.google.android.gms.internal.aet;
import com.google.android.gms.internal.aeu;
import com.google.android.gms.internal.zzbci;
import com.google.android.gms.internal.zzbcj;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.GetTokenResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final List<String> zzbWT = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> zzbWU = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> zzbWV = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final List<String> zzbWW = Arrays.asList(new String[0]);
    private static final Set<String> zzbWX = Collections.emptySet();
    private static final Object zzuI = new Object();
    static final Map<String, FirebaseApp> zzbgU = new ArrayMap();
    private final Context mApplicationContext;
    private final String mName;
    private final FirebaseOptions zzbWY;
    private final AtomicBoolean zzbWZ = new AtomicBoolean(false);
    private final AtomicBoolean zzbXa = new AtomicBoolean();
    private final List<zza> zzbXb = new CopyOnWriteArrayList<zza>();
    private final List<zzc> zzbXc = new CopyOnWriteArrayList<zzc>();
    private final List<Object> zzbXd = new CopyOnWriteArrayList<Object>();
    private aet zzbXe;
    private zzb zzbXf;

    @NonNull
    public Context getApplicationContext() {
        this.zzEr();
        return this.mApplicationContext;
    }

    @NonNull
    public String getName() {
        this.zzEr();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.zzEr();
        return this.zzbWY;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)object).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return zzbh.zzt((Object)this).zzg("name", (Object)this.mName).zzg("options", (Object)this.zzbWY).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FirebaseApp> getApps(Context context) {
        aes.zzbL(context);
        Object object = zzuI;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzbgU.values());
            aes.zzKo();
            Set<String> set = aes.zzKp();
            set.removeAll(zzbgU.keySet());
            for (String string : set) {
                aes.zzhP(string);
                FirebaseApp firebaseApp = FirebaseApp.initializeApp(context, null, string);
                arrayList.add(firebaseApp);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp getInstance() {
        Object object = zzuI;
        synchronized (object) {
            FirebaseApp firebaseApp = zzbgU.get(DEFAULT_APP_NAME);
            if (firebaseApp == null) {
                String string = String.valueOf(zzt.zzse());
                throw new IllegalStateException(new StringBuilder(116 + String.valueOf(string).length()).append("Default FirebaseApp is not initialized in this process ").append(string).append(". Make sure to call FirebaseApp.initializeApp(Context) first.").toString());
            }
            return firebaseApp;
        }
    }

    public static FirebaseApp getInstance(@NonNull String string) {
        Object object = zzuI;
        synchronized (object) {
            String string2;
            FirebaseApp firebaseApp = zzbgU.get(string.trim());
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> list = FirebaseApp.zzEu();
            if (list.isEmpty()) {
                string2 = "";
            } else {
                String string3 = String.valueOf(TextUtils.join((CharSequence)", ", list));
                string2 = string3.length() != 0 ? "Available app names: ".concat(string3) : new String("Available app names: ");
            }
            String string4 = string2;
            String string5 = String.format("FirebaseApp with name %s doesn't exist. %s", string, string4);
            throw new IllegalStateException(string5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static FirebaseApp initializeApp(Context context) {
        Object object = zzuI;
        synchronized (object) {
            if (zzbgU.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                return null;
            }
            return FirebaseApp.initializeApp(context, firebaseOptions);
        }
    }

    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions) {
        return FirebaseApp.initializeApp(context, firebaseOptions, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(Context context, FirebaseOptions firebaseOptions, String string) {
        FirebaseApp firebaseApp;
        aes.zzbL(context);
        Context context2 = context;
        if (context2.getApplicationContext() instanceof Application) {
            zzbci.zza((Application)((Application)context2.getApplicationContext()));
            zzbci.zzpt().zza((zzbcj)new com.google.firebase.zza());
        }
        String string2 = string.trim();
        Context context3 = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Object object = zzuI;
        synchronized (object) {
            zzbr.zza((!zzbgU.containsKey(string2) ? 1 : 0) != 0, (Object)new StringBuilder(33 + String.valueOf(string2).length()).append("FirebaseApp name ").append(string2).append(" already exists!").toString());
            zzbr.zzb((Object)context3, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(context3, string2, firebaseOptions);
            zzbgU.put(string2, firebaseApp);
        }
        aes.zze(firebaseApp);
        firebaseApp.zza(FirebaseApp.class, firebaseApp, zzbWT);
        if (firebaseApp.zzEs()) {
            firebaseApp.zza(FirebaseApp.class, firebaseApp, zzbWU);
            firebaseApp.zza(Context.class, firebaseApp.getApplicationContext(), zzbWV);
        }
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzac(boolean bl) {
        Object object = zzuI;
        synchronized (object) {
            ArrayList<FirebaseApp> arrayList = new ArrayList<FirebaseApp>(zzbgU.values());
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                FirebaseApp firebaseApp = arrayList.get(i);
                FirebaseApp firebaseApp2 = firebaseApp;
                if (!firebaseApp.zzbWZ.get()) continue;
                firebaseApp2.zzav(bl);
            }
            return;
        }
    }

    public final void zza(@NonNull aet aet2) {
        this.zzbXe = (aet)zzbr.zzu((Object)aet2);
    }

    public final Task<GetTokenResult> getToken(boolean bl) {
        this.zzEr();
        if (this.zzbXe == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.zzbXe.zzaw(bl);
    }

    public void setAutomaticResourceManagementEnabled(boolean bl) {
        this.zzEr();
        if (this.zzbWZ.compareAndSet(!bl, bl)) {
            boolean bl2 = zzbci.zzpt().zzpu();
            if (bl && bl2) {
                this.zzav(true);
                return;
            }
            if (!bl && bl2) {
                this.zzav(false);
            }
        }
    }

    private FirebaseApp(Context context, String string, FirebaseOptions firebaseOptions) {
        this.mApplicationContext = (Context)zzbr.zzu((Object)context);
        this.mName = zzbr.zzcF((String)string);
        this.zzbWY = (FirebaseOptions)zzbr.zzu((Object)firebaseOptions);
        this.zzbXf = new aer();
    }

    private final void zzEr() {
        zzbr.zza((!this.zzbXa.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    public final boolean zzEs() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @UiThread
    public final void zza(@NonNull aeu aeu2) {
        Log.d((String)"FirebaseApp", (String)"Notifying auth state listeners.");
        int n = 0;
        Iterator<zza> iterator = this.zzbXb.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzb(aeu2);
            ++n;
        }
        Log.d((String)"FirebaseApp", (String)String.format("Notified %d auth state listeners.", n));
    }

    private final void zzav(boolean bl) {
        Log.d((String)"FirebaseApp", (String)"Notifying background state change listeners.");
        Iterator<zzc> iterator = this.zzbXc.iterator();
        while (iterator.hasNext()) {
            iterator.next().zzac(bl);
        }
    }

    public final void zza(@NonNull zza zza2) {
        this.zzEr();
        zzbr.zzu((Object)zza2);
        this.zzbXb.add(zza2);
        this.zzbXb.size();
    }

    public final void zza(zzc zzc2) {
        this.zzEr();
        if (this.zzbWZ.get() && zzbci.zzpt().zzpu()) {
            zzc2.zzac(true);
        }
        this.zzbXc.add(zzc2);
    }

    public final String zzEt() {
        String string = String.valueOf(com.google.android.gms.common.util.zzd.zzi((byte[])this.getName().getBytes()));
        String string2 = String.valueOf(com.google.android.gms.common.util.zzd.zzi((byte[])this.getOptions().getApplicationId().getBytes()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("+").append(string2).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> zzEu() {
        com.google.android.gms.common.util.zzb zzb2 = new com.google.android.gms.common.util.zzb();
        ArrayList<String> arrayList = zzuI;
        synchronized (arrayList) {
            for (FirebaseApp firebaseApp : zzbgU.values()) {
                zzb2.add(firebaseApp.getName());
            }
            if (aes.zzKo() != null) {
                zzb2.addAll(aes.zzKp());
            }
        }
        arrayList = new ArrayList<String>((Collection<String>)zzb2);
        Collections.sort(arrayList);
        return arrayList;
    }

    private final void zzEv() {
        this.zza(FirebaseApp.class, this, zzbWT);
        if (this.zzEs()) {
            this.zza(FirebaseApp.class, this, zzbWU);
            this.zza(Context.class, this.mApplicationContext, zzbWV);
        }
    }

    private final <T> void zza(Class<T> clazz, T t, Iterable<String> iterable) {
        boolean bl = ContextCompat.isDeviceProtectedStorage((Context)this.mApplicationContext);
        if (bl) {
            zzd.zzbB(this.mApplicationContext);
        }
        for (String string : iterable) {
            try {
                Method method;
                int n;
                if (bl && !zzbWW.contains(string) || !Modifier.isPublic(n = (method = Class.forName(string).getMethod("getInstance", clazz)).getModifiers()) || !Modifier.isStatic(n)) continue;
                method.invoke(null, t);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (zzbWX.contains(string)) {
                    throw new IllegalStateException(String.valueOf(string).concat(" is missing, but is required. Check if it has been removed by Proguard."));
                }
                Log.d((String)"FirebaseApp", (String)String.valueOf(string).concat(" is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalStateException(String.valueOf(string).concat("#getInstance has been removed by Proguard. Add keep rule to prevent it."));
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.wtf((String)"FirebaseApp", (String)"Firebase API initialization failure.", (Throwable)invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                String string2 = String.valueOf(string);
                Log.wtf((String)"FirebaseApp", (String)(string2.length() != 0 ? "Failed to initialize ".concat(string2) : new String("Failed to initialize ")), (Throwable)illegalAccessException);
            }
        }
    }

    @TargetApi(value=24)
    static final class zzd
    extends BroadcastReceiver {
        private static AtomicReference<zzd> zzbXg = new AtomicReference();
        private final Context mApplicationContext;

        private zzd(Context context) {
            this.mApplicationContext = context;
        }

        private static void zzbB(Context context) {
            zzd zzd2;
            if (zzbXg.get() == null && zzbXg.compareAndSet(null, zzd2 = new zzd(context))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                context.registerReceiver((BroadcastReceiver)zzd2, intentFilter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onReceive(Context context, Intent intent) {
            Object object = zzuI;
            synchronized (object) {
                Iterator<FirebaseApp> iterator = zzbgU.values().iterator();
                while (iterator.hasNext()) {
                    iterator.next().zzEv();
                }
            }
            zzd zzd2 = this;
            zzd2.mApplicationContext.unregisterReceiver((BroadcastReceiver)zzd2);
        }
    }

    public static interface zzc {
        public void zzac(boolean var1);
    }

    public static interface zzb {
    }

    public static interface zza {
        public void zzb(@NonNull aeu var1);
    }
}

