/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base.internal;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Finalizer
implements Runnable {
    private static final Logger logger = Logger.getLogger(Finalizer.class.getName());
    private final WeakReference<Class<?>> zzbWP;
    private final PhantomReference<Object> zzbWQ;
    private final ReferenceQueue<Object> zzbWR;
    private static final Field zzbWS = Finalizer.zzEq();

    public static void startFinalizer(Class<?> clazz, ReferenceQueue<Object> referenceQueue, PhantomReference<Object> phantomReference) {
        if (!clazz.getName().equals("com.google.common.base.FinalizableReference")) {
            throw new IllegalArgumentException("Expected com.google.common.base.FinalizableReference.");
        }
        Finalizer finalizer = new Finalizer(clazz, referenceQueue, phantomReference);
        Thread thread = new Thread(finalizer);
        thread.setName(Finalizer.class.getName());
        thread.setDaemon(true);
        try {
            if (zzbWS != null) {
                zzbWS.set(thread, null);
            }
        }
        catch (Throwable throwable) {
            logger.logp(Level.INFO, "com.google.common.base.internal.Finalizer", "startFinalizer", "Failed to clear thread local values inherited by reference finalizer thread.", throwable);
        }
        thread.start();
    }

    private Finalizer(Class<?> clazz, ReferenceQueue<Object> referenceQueue, PhantomReference<Object> phantomReference) {
        this.zzbWR = referenceQueue;
        this.zzbWP = new WeakReference(clazz);
        this.zzbWQ = phantomReference;
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (this.zza(this.zzbWR.remove())) {
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private final boolean zza(Reference<?> reference) {
        Method method = this.zzEp();
        if (method == null) {
            return false;
        }
        do {
            reference.clear();
            if (reference == this.zzbWQ) {
                return false;
            }
            try {
                method.invoke(reference, new Object[0]);
            }
            catch (Throwable throwable) {
                logger.logp(Level.SEVERE, "com.google.common.base.internal.Finalizer", "cleanUp", "Error cleaning up after reference.", throwable);
            }
        } while ((reference = this.zzbWR.poll()) != null);
        return true;
    }

    private final Method zzEp() {
        Class clazz = (Class)this.zzbWP.get();
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.getMethod("finalizeReferent", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }

    private static Field zzEq() {
        try {
            Field field = Thread.class.getDeclaredField("inheritableThreadLocals");
            field.setAccessible(true);
            return field;
        }
        catch (Throwable throwable) {
            logger.logp(Level.INFO, "com.google.common.base.internal.Finalizer", "getInheritableThreadLocalsField", "Couldn't access Thread.inheritableThreadLocals. Reference finalizer threads will inherit thread local values.");
            return null;
        }
    }
}

