/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.firebase_auth.zzcz;
import com.google.android.gms.internal.firebase_auth.zzdj;
import com.google.android.gms.internal.firebase_auth.zzjn;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FirebaseAuthSettings;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.api.internal.zzao;
import com.google.firebase.auth.api.internal.zzds;
import com.google.firebase.auth.api.internal.zzed;
import com.google.firebase.auth.api.internal.zzef;
import com.google.firebase.auth.api.internal.zzeg;
import com.google.firebase.auth.api.internal.zzem;
import com.google.firebase.auth.internal.InternalAuthProvider;
import com.google.firebase.auth.internal.zzaa;
import com.google.firebase.auth.internal.zzad;
import com.google.firebase.auth.internal.zzae;
import com.google.firebase.auth.internal.zzag;
import com.google.firebase.auth.internal.zzah;
import com.google.firebase.auth.internal.zzf;
import com.google.firebase.auth.internal.zzk;
import com.google.firebase.auth.internal.zzl;
import com.google.firebase.auth.internal.zzw;
import com.google.firebase.auth.internal.zzz;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzm;
import com.google.firebase.auth.zzn;
import com.google.firebase.auth.zzo;
import com.google.firebase.internal.InternalTokenResult;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements InternalAuthProvider {
    private FirebaseApp zzgm;
    private final List<IdTokenListener> zzgn;
    private final List<com.google.firebase.auth.internal.IdTokenListener> zzgo;
    private List<AuthStateListener> zzgp;
    private zzao zzgq;
    private FirebaseUser zzgr;
    private zzk zzgs;
    private final Object zzgt;
    private String zzgu;
    private final Object zzgv;
    private String zzgw;
    private final zzad zzgx;
    private final zzz zzgy;
    private zzae zzgz;
    private zzag zzha;

    @Keep
    public static FirebaseAuth getInstance() {
        return (FirebaseAuth)FirebaseApp.getInstance().get(FirebaseAuth.class);
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return (FirebaseAuth)firebaseApp.get(FirebaseAuth.class);
    }

    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        zzef zzef2 = new zzeg(firebaseApp2.getOptions().getApiKey()).zzdk();
        this(firebaseApp, zzed.zza(firebaseApp2.getApplicationContext(), zzef2), new zzad(firebaseApp.getApplicationContext(), firebaseApp.getPersistenceKey()), zzz.zzem());
    }

    @VisibleForTesting
    private FirebaseAuth(FirebaseApp firebaseApp, zzao zzao2, zzad zzad2, zzz zzz2) {
        zzcz zzcz2;
        this.zzgt = new Object();
        this.zzgv = new Object();
        this.zzgm = (FirebaseApp)Preconditions.checkNotNull((Object)firebaseApp);
        this.zzgq = (zzao)Preconditions.checkNotNull((Object)zzao2);
        this.zzgx = (zzad)Preconditions.checkNotNull((Object)zzad2);
        this.zzgs = new zzk();
        this.zzgy = (zzz)Preconditions.checkNotNull((Object)zzz2);
        this.zzgn = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzgo = new CopyOnWriteArrayList<com.google.firebase.auth.internal.IdTokenListener>();
        this.zzgp = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzha = zzag.zzeq();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzgr = firebaseAuth.zzgx.zzeo();
        if (firebaseAuth.zzgr != null && (zzcz2 = firebaseAuth.zzgx.zzh(firebaseAuth.zzgr)) != null) {
            firebaseAuth.zza(firebaseAuth.zzgr, zzcz2, false);
        }
        firebaseAuth.zzgy.zzg(firebaseAuth);
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzgr;
    }

    @Nullable
    public String getUid() {
        if (this.zzgr == null) {
            return null;
        }
        return this.zzgr.getUid();
    }

    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzcz zzcz2, boolean bl) {
        boolean bl2;
        boolean bl3;
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)zzcz2);
        if (this.zzgr == null) {
            bl3 = true;
            bl2 = true;
        } else {
            String string;
            String string2 = this.zzgr.zzcg().zzdw();
            boolean bl4 = !string2.equals(string = zzcz2.zzdw());
            boolean bl5 = this.zzgr.getUid().equals(firebaseUser.getUid());
            bl3 = !bl5 || bl4;
            bl2 = !bl5;
        }
        boolean bl6 = bl2;
        boolean bl7 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        Preconditions.checkNotNull((Object)firebaseUser2);
        if (firebaseAuth.zzgr == null) {
            firebaseAuth.zzgr = firebaseUser2;
        } else {
            firebaseAuth.zzgr.zza(firebaseUser2.getProviderData());
            if (!firebaseUser2.isAnonymous()) {
                firebaseAuth.zzgr.zzce();
            }
        }
        if (bl7) {
            firebaseAuth.zzgx.zzg(firebaseAuth.zzgr);
        }
        if (bl3) {
            if (this.zzgr != null) {
                this.zzgr.zza(zzcz2);
            }
            this.zzb(this.zzgr);
        }
        if (bl6) {
            this.zzc(this.zzgr);
        }
        if (bl) {
            this.zzgx.zza(firebaseUser, zzcz2);
        }
        firebaseAuth = this;
        firebaseAuth.zzcb().zzc(firebaseAuth.zzgr.zzcg());
    }

    public final void zzca() {
        if (this.zzgr != null) {
            FirebaseUser firebaseUser = this.zzgr;
            zzad zzad2 = this.zzgx;
            Preconditions.checkNotNull((Object)firebaseUser);
            zzad2.clear(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzgr = null;
        }
        this.zzgx.clear("com.google.firebase.auth.FIREBASE_USER");
        this.zzb(null);
        this.zzc((FirebaseUser)null);
    }

    @VisibleForTesting
    private final synchronized void zza(zzae zzae2) {
        this.zzgz = zzae2;
        this.zzgm.setIdTokenListenersCountChangedListener((FirebaseApp.IdTokenListenersCountChangedListener)zzae2);
    }

    @VisibleForTesting
    private final synchronized zzae zzcb() {
        if (this.zzgz == null) {
            this.zza(new zzae(this.zzgm));
        }
        return this.zzgz;
    }

    public FirebaseApp getApp() {
        return this.zzgm;
    }

    public final FirebaseApp zzcc() {
        return this.zzgm;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzgn.add(idTokenListener);
        this.zzha.execute(new zzi(this, idTokenListener));
    }

    @KeepForSdk
    public void addIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener idTokenListener) {
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzgo.add(idTokenListener);
        this.zzcb().zzf(this.zzgo.size());
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzgn.remove(idTokenListener);
    }

    @KeepForSdk
    public void removeIdTokenListener(@NonNull com.google.firebase.auth.internal.IdTokenListener idTokenListener) {
        Preconditions.checkNotNull((Object)idTokenListener);
        this.zzgo.remove(idTokenListener);
        this.zzcb().zzf(this.zzgo.size());
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzgp.add(authStateListener);
        this.zzha.execute(new zzj(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzgp.remove(authStateListener);
    }

    private final void zzb(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzci() : null;
        InternalTokenResult internalTokenResult = new InternalTokenResult(string);
        this.zzha.execute(new com.google.firebase.auth.zzk(this, internalTokenResult));
    }

    private final void zzc(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzha.execute(new com.google.firebase.auth.zzl(this));
    }

    @NonNull
    public Task<GetTokenResult> getAccessToken(boolean bl) {
        return this.zza(this.zzgr, bl);
    }

    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzds.zzb(new Status(17495)));
        }
        zzcz zzcz2 = firebaseUser.zzcg();
        if (zzcz2.isValid() && !bl) {
            return Tasks.forResult((Object)zzaa.zzcu(zzcz2.zzdw()));
        }
        return this.zzgq.zza(this.zzgm, firebaseUser, zzcz2.zzr(), (zzah)((Object)new zzm(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if (!emailAuthCredential.zzbz()) {
                return this.zzgq.zzb(this.zzgm, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), this.zzgw, new zza());
            }
            return this.zzgq.zza(this.zzgm, emailAuthCredential, (com.google.firebase.auth.internal.zza)new zza());
        }
        if (authCredential instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            return this.zzgq.zza(this.zzgm, phoneAuthCredential, this.zzgw, (com.google.firebase.auth.internal.zza)new zza());
        }
        return this.zzgq.zza(this.zzgm, authCredential, this.zzgw, (com.google.firebase.auth.internal.zza)new zza());
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zzgq.zza(this.zzgm, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), firebaseUser.zzcf(), (zzah)((Object)new zzb()));
            }
            return this.zzgq.zza(this.zzgm, firebaseUser, emailAuthCredential, (zzah)((Object)new zzb()));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzgq.zza(this.zzgm, firebaseUser, (PhoneAuthCredential)authCredential, this.zzgw, (zzah)((Object)new zzb()));
        }
        return this.zzgq.zza(this.zzgm, firebaseUser, authCredential, firebaseUser.zzcf(), (zzah)((Object)new zzb()));
    }

    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zzgq.zzb(this.zzgm, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), firebaseUser.zzcf(), (zzah)((Object)new zzb()));
            }
            return this.zzgq.zzb(this.zzgm, firebaseUser, emailAuthCredential, (zzah)((Object)new zzb()));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzgq.zzb(this.zzgm, firebaseUser, (PhoneAuthCredential)authCredential, this.zzgw, (zzah)((Object)new zzb()));
        }
        return this.zzgq.zzb(this.zzgm, firebaseUser, authCredential, firebaseUser.zzcf(), (zzah)((Object)new zzb()));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzgq.zza(this.zzgm, string, (com.google.firebase.auth.internal.zza)new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zzgq.zzb(this.zzgm, string, string2, this.zzgw, new zza());
    }

    @NonNull
    public Task<AuthResult> signInWithEmailLink(@NonNull String string, @NonNull String string2) {
        return this.signInWithCredential(EmailAuthProvider.getCredentialWithLink(string, string2));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzgr != null && this.zzgr.isAnonymous()) {
            zzl zzl2 = (zzl)this.zzgr;
            zzl2.zzr(false);
            return Tasks.forResult((Object)new zzf(zzl2));
        }
        return this.zzgq.zza(this.zzgm, new zza(), this.zzgw);
    }

    @NonNull
    public final void zza(@NonNull String string, long l, TimeUnit timeUnit, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable Activity activity, @NonNull Executor executor, boolean bl) {
        long l2 = TimeUnit.SECONDS.convert(l, timeUnit);
        if (l2 < 0L || l2 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        zzdj zzdj2 = new zzdj(string, l2, bl, this.zzgu, this.zzgw);
        if (this.zzgs.zzee() && string.equals(this.zzgs.getPhoneNumber())) {
            PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks2 = onVerificationStateChangedCallbacks;
            FirebaseAuth firebaseAuth = this;
            onVerificationStateChangedCallbacks = new zzn(firebaseAuth, onVerificationStateChangedCallbacks2);
        }
        this.zzgq.zza(this.zzgm, zzdj2, onVerificationStateChangedCallbacks, activity, executor);
    }

    public Task<Void> updateCurrentUser(@NonNull FirebaseUser firebaseUser) {
        if (firebaseUser == null) {
            throw new IllegalArgumentException("Cannot update current user with null user!");
        }
        if (this.zzgr != null && !firebaseUser.zzcf().equals(this.zzgw)) {
            return Tasks.forException((Exception)zzds.zzb(new Status(17072)));
        }
        String string = firebaseUser.zzcc().getOptions().getApiKey();
        String string2 = this.zzgm.getOptions().getApiKey();
        if (firebaseUser.zzcg().isValid() && string2.equals(string)) {
            FirebaseUser firebaseUser2 = zzl.zza(this.zzgm, firebaseUser);
            this.zza(firebaseUser2, firebaseUser.zzcg(), true);
            return Tasks.forResult(null);
        }
        return this.zza(firebaseUser, (zzah)((Object)new zzc(this)));
    }

    public final Task<Void> zzd(@NonNull FirebaseUser firebaseUser) {
        return this.zza(firebaseUser, (zzah)((Object)new zzb()));
    }

    @NonNull
    private final Task<Void> zza(@NonNull FirebaseUser firebaseUser, zzah zzah2) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzgq.zza(this.zzgm, firebaseUser, zzah2);
    }

    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        Preconditions.checkNotNull((Object)((Object)authCredential));
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzgq.zza(this.zzgm, firebaseUser, authCredential, (zzah)((Object)new zzb()));
    }

    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzgq.zzd(this.zzgm, firebaseUser, string, (zzah)((Object)new zzb()));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zzgq.zza(this.zzgm, string, string2, this.zzgw, new zza());
    }

    @Deprecated
    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzgq.zza(this.zzgm, string, this.zzgw);
    }

    @NonNull
    public Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzgq.zzb(this.zzgm, string, this.zzgw);
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)((Object)userProfileChangeRequest));
        return this.zzgq.zza(this.zzgm, firebaseUser, userProfileChangeRequest, (zzah)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zzgq.zzb(this.zzgm, firebaseUser, string, (zzah)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotNull((Object)phoneAuthCredential);
        return this.zzgq.zza(this.zzgm, firebaseUser, phoneAuthCredential, (zzah)((Object)new zzb()));
    }

    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        Preconditions.checkNotNull((Object)firebaseUser);
        Preconditions.checkNotEmpty((String)string);
        return this.zzgq.zzc(this.zzgm, firebaseUser, string, (zzah)((Object)new zzb()));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.sendPasswordResetEmail(string, null);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.zzbs();
        }
        if (this.zzgu != null) {
            actionCodeSettings.zzbm(this.zzgu);
        }
        actionCodeSettings.zza(zzjn.zzaee);
        return this.zzgq.zza(this.zzgm, string, actionCodeSettings, this.zzgw);
    }

    public Task<Void> sendSignInLinkToEmail(@NonNull String string, @NonNull ActionCodeSettings actionCodeSettings) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)actionCodeSettings));
        if (!actionCodeSettings.canHandleCodeInApp()) {
            throw new IllegalArgumentException("You must set canHandleCodeInApp in your ActionCodeSettings to true for Email-Link Sign-in.");
        }
        if (this.zzgu != null) {
            actionCodeSettings.zzbm(this.zzgu);
        }
        return this.zzgq.zzb(this.zzgm, string, actionCodeSettings, this.zzgw);
    }

    public boolean isSignInWithEmailLink(@NonNull String string) {
        return EmailAuthCredential.isSignInWithEmailLink(string);
    }

    @NonNull
    public final Task<Void> zza(@Nullable ActionCodeSettings actionCodeSettings, @NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        if (this.zzgu != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.zzbs();
            }
            actionCodeSettings.zzbm(this.zzgu);
        }
        return this.zzgq.zza(this.zzgm, actionCodeSettings, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzgq.zzc(this.zzgm, string, this.zzgw);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzgq.zzd(this.zzgm, string, this.zzgw);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zzgq.zze(this.zzgm, string, this.zzgw);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        return this.zzgq.zza(this.zzgm, string, string2, this.zzgw);
    }

    @NonNull
    public final Task<Void> zze(@NonNull FirebaseUser firebaseUser) {
        Preconditions.checkNotNull((Object)firebaseUser);
        return this.zzgq.zza(firebaseUser, new zzo(this, firebaseUser));
    }

    public void signOut() {
        this.zzca();
        if (this.zzgz != null) {
            this.zzgz.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguageCode(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Object object = this.zzgt;
        synchronized (object) {
            this.zzgu = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLanguageCode() {
        Object object = this.zzgt;
        synchronized (object) {
            return this.zzgu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzc(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        Object object = this.zzgv;
        synchronized (object) {
            this.zzgw = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAppLanguage() {
        Object object = this.zzgt;
        synchronized (object) {
            this.zzgu = zzem.zzdo();
            return;
        }
    }

    public FirebaseAuthSettings getFirebaseAuthSettings() {
        return this.zzgs;
    }

    public Task<Void> setFirebaseUIVersion(@Nullable String string) {
        return this.zzgq.setFirebaseUIVersion(string);
    }

    static /* synthetic */ FirebaseApp zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzgm;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzgo;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzgn;
    }

    static /* synthetic */ List zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzgp;
    }

    static /* synthetic */ zzk zze(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzgs;
    }

    static /* synthetic */ FirebaseUser zzf(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzgr;
    }

    final class zzc
    extends zza
    implements com.google.firebase.auth.internal.zza,
    zzw {
        zzc(FirebaseAuth firebaseAuth) {
        }

        @Override
        public final void zza(Status status) {
        }
    }

    @VisibleForTesting
    final class zzb
    extends zza
    implements com.google.firebase.auth.internal.zza,
    zzw {
        zzb() {
        }

        @Override
        public final void zza(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005) {
                FirebaseAuth.this.signOut();
            }
        }
    }

    @VisibleForTesting
    class zza
    implements com.google.firebase.auth.internal.zza {
        zza() {
        }

        @Override
        public final void zza(@NonNull zzcz zzcz2, @NonNull FirebaseUser firebaseUser) {
            Preconditions.checkNotNull((Object)zzcz2);
            Preconditions.checkNotNull((Object)firebaseUser);
            firebaseUser.zza(zzcz2);
            FirebaseAuth.this.zza(firebaseUser, zzcz2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

