/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzed;
import com.google.android.gms.internal.firebase_auth.zzfu;
import com.google.android.gms.internal.firebase_auth.zzga;
import com.google.android.gms.internal.firebase_auth.zzhm;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzef
extends zzed<Boolean>
implements zzga<Boolean>,
zzhm,
RandomAccess {
    private static final zzef zzsm = new zzef();
    private boolean[] zzsn;
    private int size;

    zzef() {
        this(new boolean[10], 0);
    }

    private zzef(boolean[] blArray, int n) {
        this.zzsn = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzew();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzsn, n2, this.zzsn, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzef)) {
            return super.equals(object);
        }
        zzef zzef2 = (zzef)object;
        if (this.size != zzef2.size) {
            return false;
        }
        boolean[] blArray = zzef2.zzsn;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzsn[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzfu.zzu(this.zzsn[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zza(this.size, bl);
    }

    private final void zza(int n, boolean bl) {
        this.zzew();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
        if (this.size < this.zzsn.length) {
            System.arraycopy(this.zzsn, n, this.zzsn, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzsn, 0, blArray, 0, n);
            System.arraycopy(this.zzsn, n, blArray, n + 1, this.size - n);
            this.zzsn = blArray;
        }
        this.zzsn[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzew();
        zzfu.checkNotNull(collection);
        if (!(collection instanceof zzef)) {
            return super.addAll(collection);
        }
        zzef zzef2 = (zzef)collection;
        if (zzef2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzef2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzef2.size;
        if (n > this.zzsn.length) {
            this.zzsn = Arrays.copyOf(this.zzsn, n);
        }
        System.arraycopy(zzef2.zzsn, 0, this.zzsn, this.size, zzef2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzew();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzsn[i])) continue;
            System.arraycopy(this.zzsn, i + 1, this.zzsn, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzef zzef2 = this;
        zzef2.zzew();
        zzef2.zzh(n);
        boolean bl3 = zzef2.zzsn[n];
        zzef2.zzsn[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzef zzef2 = this;
        zzef2.zzew();
        zzef2.zzh(n);
        boolean bl = zzef2.zzsn[n];
        if (n < zzef2.size - 1) {
            System.arraycopy(zzef2.zzsn, n + 1, zzef2.zzsn, n, zzef2.size - n);
        }
        --zzef2.size;
        ++zzef2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zza(n, bl);
    }

    @Override
    public final /* synthetic */ zzga zzj(int n) {
        int n2 = n;
        zzef zzef2 = this;
        if (n2 < zzef2.size) {
            throw new IllegalArgumentException();
        }
        return new zzef(Arrays.copyOf(zzef2.zzsn, n2), zzef2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzef zzef2 = this;
        zzef2.zzh(n);
        return zzef2.zzsn[n];
    }

    static {
        zzsm.zzev();
    }
}

