/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution;

import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.firebase.appdistribution.CliRuntime;
import java.io.IOException;

public class RequestBuilder {
    public static final String X_APP_DISTRO_API_CLIENT_ID = "X-APP-DISTRO-API-CLIENT-ID";
    public static final String X_APP_DISTRO_API_CLIENT_VERSION = "X-APP-DISTRO-API-CLIENT-VERSION";
    public static final String X_APP_DISTRO_API_CLIENT_TYPE = "X-APP-DISTRO-API-CLIENT-TYPE";
    private static String USER_AGENT_FORMAT = "Firebase App Distro Client/%s";
    private final CliRuntime runtimeProperties = CliRuntime.getInstance();
    private final HttpRequest request;

    RequestBuilder(HttpRequest request) {
        this.request = request;
    }

    public RequestBuilder setContent(HttpContent content) {
        this.request.setContent(content);
        return this;
    }

    public RequestBuilder setHeader(String headerName, String value) {
        this.request.getHeaders().set(headerName, (Object)value);
        return this;
    }

    public HttpResponse execute() throws IOException {
        this.addHeaders(this.request.getHeaders());
        this.request.setSuppressUserAgentSuffix(true);
        return this.request.execute();
    }

    private void addHeaders(HttpHeaders headers) {
        headers.setUserAgent(String.format(USER_AGENT_FORMAT, this.runtimeProperties.getClientVersion()));
        headers.set(X_APP_DISTRO_API_CLIENT_ID, (Object)this.runtimeProperties.getClientId());
        headers.set(X_APP_DISTRO_API_CLIENT_TYPE, (Object)this.runtimeProperties.getClientType());
        headers.set(X_APP_DISTRO_API_CLIENT_VERSION, (Object)this.runtimeProperties.getClientVersion());
    }
}

