/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.firebase.appdistribution.ApiEndpoints;
import com.google.firebase.appdistribution.AppDistributionException;
import com.google.firebase.appdistribution.AppDistributionLogger;
import com.google.firebase.appdistribution.AppDistributionLoggerHelper;
import com.google.firebase.appdistribution.AuthenticatedHttpClient;
import com.google.firebase.appdistribution.BinaryType;
import com.google.firebase.appdistribution.models.App;
import com.google.firebase.appdistribution.models.UploadStatusResponse;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;

class ApiService {
    AppDistributionLogger LOGGER = AppDistributionLoggerHelper.getLogger();
    private final AuthenticatedHttpClient httpClient;
    private final String appId;

    ApiService(AuthenticatedHttpClient httpClient, String appId) {
        this.httpClient = httpClient;
        this.appId = appId;
    }

    UploadStatusResponse getUploadStatus(String releaseHash, BinaryType binaryType) throws AppDistributionException {
        GenericUrl endpoint = ApiEndpoints.getUploadStatusEndpoint(this.appId, releaseHash);
        try {
            HttpResponse response = this.httpClient.newGetRequest(endpoint).execute();
            return (UploadStatusResponse)new Gson().fromJson(response.parseAsString(), UploadStatusResponse.class);
        }
        catch (HttpResponseException e) {
            throw AppDistributionException.fromHttpResponseException(AppDistributionException.Reason.processingBinaryError(binaryType), e);
        }
        catch (IOException e) {
            throw AppDistributionException.fromIoException(AppDistributionException.Reason.processingBinaryError(binaryType), e);
        }
    }

    boolean createReleaseNotes(String releaseId, String releaseNotes) throws IOException {
        JsonObject jsonBody = this.buildCreateReleaseNotesJson(releaseId, releaseNotes);
        ByteArrayContent content = new ByteArrayContent("application/json", jsonBody.toString().getBytes(StandardCharsets.UTF_8));
        HttpResponse createReleaseNotesResponse = this.httpClient.newPostRequest(ApiEndpoints.getCreateReleaseNotesEndpoint(this.appId, releaseId), (HttpContent)content).execute();
        if (createReleaseNotesResponse.isSuccessStatusCode()) {
            this.LOGGER.info("Added release notes successfully %s", createReleaseNotesResponse.getStatusCode());
            return true;
        }
        this.LOGGER.info("Unable to add release notes. Response code: %s", createReleaseNotesResponse.getStatusCode());
        return false;
    }

    boolean enableAccess(String releaseId, List<String> emails, List<String> groupIds) throws IOException {
        JsonObject jsonBody = this.buildEnableAccessJson(releaseId, emails, groupIds);
        ByteArrayContent content = new ByteArrayContent("application/json", jsonBody.toString().getBytes(StandardCharsets.UTF_8));
        HttpResponse enableAccessResponse = this.httpClient.newPostRequest(ApiEndpoints.getEnableAccessOnReleaseEndpoint(this.appId, releaseId), (HttpContent)content).execute();
        if (enableAccessResponse.isSuccessStatusCode()) {
            this.LOGGER.info("Added testers/groups successfully %s", enableAccessResponse.getStatusCode());
            return true;
        }
        this.LOGGER.info("Unable to add testers/groups. Response code: %s", enableAccessResponse.getStatusCode());
        return false;
    }

    App getApp(AppView appView) throws IOException {
        HttpResponse appResponse = this.httpClient.newGetRequest(ApiEndpoints.getAppEndpoint(this.appId, appView.toString())).execute();
        return (App)new Gson().fromJson(appResponse.parseAsString(), App.class);
    }

    protected JsonObject buildCreateReleaseNotesJson(String releaseId, String releaseNotes) {
        JsonObject jsonBody = new JsonObject();
        jsonBody.add("releaseId", (JsonElement)new JsonPrimitive(releaseId));
        JsonObject releaseNotesJson = new JsonObject();
        releaseNotesJson.add("releaseNotes", (JsonElement)new JsonPrimitive(releaseNotes));
        jsonBody.add("releaseNotes", (JsonElement)releaseNotesJson);
        return jsonBody;
    }

    protected JsonObject buildEnableAccessJson(String releaseId, List<String> emails, List<String> groupIds) {
        JsonObject jsonBody = new JsonObject();
        jsonBody.add("releaseId", (JsonElement)new JsonPrimitive(releaseId));
        JsonArray emailsArray = new JsonArray();
        for (String email : emails) {
            emailsArray.add(email);
        }
        jsonBody.add("emails", (JsonElement)emailsArray);
        JsonArray groupIdsArray = new JsonArray();
        for (String groupId : groupIds) {
            groupIdsArray.add(groupId);
        }
        jsonBody.add("groupIds", (JsonElement)groupIdsArray);
        return jsonBody;
    }

    public static enum AppView {
        BASIC,
        FULL;

    }
}

