/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution;

import com.google.api.client.http.GenericUrl;
import com.google.common.collect.ImmutableList;
import com.google.common.net.UrlEscapers;
import java.util.List;

public class ApiEndpoints {
    static final String PROP_FIREBASE_APP_DISTRIBUTION_API_SCHEME = "FIREBASE_APP_DISTRIBUTION_API_SCHEME";
    static final String PROP_FIREBASE_APP_DISTRIBUTION_API_HOST = "FIREBASE_APP_DISTRIBUTION_API_HOST";
    private static final String SCHEME = System.getProperty("FIREBASE_APP_DISTRIBUTION_API_SCHEME", "https");
    private static final String API_HOST = System.getProperty("FIREBASE_APP_DISTRIBUTION_API_HOST", "firebaseappdistribution.googleapis.com");
    public static final List<String> SCOPES = ImmutableList.of((Object)"https://www.googleapis.com/auth/cloud-platform");

    static GenericUrl getEnableAccessOnReleaseEndpoint(String appId, String releaseId) {
        return new GenericUrl(String.format("%s://%s/v1alpha/apps/%s/releases/%s/enable_access", SCHEME, API_HOST, appId, releaseId));
    }

    static GenericUrl getCreateReleaseNotesEndpoint(String appId, String releaseId) {
        return new GenericUrl(String.format("%s://%s/v1alpha/apps/%s/releases/%s/notes", SCHEME, API_HOST, appId, releaseId));
    }

    static GenericUrl getUploadStatusEndpoint(String appId, String statusToken) {
        String escapedStatusToken = UrlEscapers.urlPathSegmentEscaper().escape(statusToken);
        return new GenericUrl(String.format("%s://%s/v1alpha/apps/%s/upload_status/%s", SCHEME, API_HOST, appId, escapedStatusToken));
    }

    static GenericUrl getAppEndpoint(String appId, String appView) {
        return new GenericUrl(String.format("%s://%s/v1alpha/apps/%s?app_view=%s", SCHEME, API_HOST, appId, appView));
    }

    static GenericUrl getScottyUploadEndpoint(String appId) {
        return new GenericUrl(String.format("%s://%s/app-binary-uploads?app_id=%s", SCHEME, API_HOST, appId));
    }
}

