/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.googleapis.batch.BatchCallback;
import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.ObjectParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.ErrorCode;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.IncomingHttpResponse;
import com.google.firebase.OutgoingHttpRequest;
import com.google.firebase.internal.AbstractPlatformErrorHandler;
import com.google.firebase.internal.ApiClientUtils;
import com.google.firebase.internal.ErrorHandlingHttpClient;
import com.google.firebase.internal.HttpRequestInfo;
import com.google.firebase.internal.SdkUtils;
import com.google.firebase.messaging.BatchResponse;
import com.google.firebase.messaging.BatchResponseImpl;
import com.google.firebase.messaging.FirebaseMessagingClient;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.SendResponse;
import com.google.firebase.messaging.internal.MessagingServiceErrorResponse;
import com.google.firebase.messaging.internal.MessagingServiceResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class FirebaseMessagingClientImpl
implements FirebaseMessagingClient {
    private static final String FCM_URL = "https://fcm.googleapis.com/v1/projects/%s/messages:send";
    private static final Map<String, String> COMMON_HEADERS = ImmutableMap.of((Object)"X-GOOG-API-FORMAT-VERSION", (Object)"2", (Object)"X-Firebase-Client", (Object)("fire-admin-java/" + SdkUtils.getVersion()));
    private final String fcmSendUrl;
    private final HttpRequestFactory requestFactory;
    private final HttpRequestFactory childRequestFactory;
    private final JsonFactory jsonFactory;
    private final HttpResponseInterceptor responseInterceptor;
    private final MessagingErrorHandler errorHandler;
    private final ErrorHandlingHttpClient<FirebaseMessagingException> httpClient;
    private final MessagingBatchClient batchClient;

    private FirebaseMessagingClientImpl(Builder builder) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)builder.projectId) ? 1 : 0) != 0);
        this.fcmSendUrl = String.format(FCM_URL, builder.projectId);
        this.requestFactory = (HttpRequestFactory)Preconditions.checkNotNull((Object)builder.requestFactory);
        this.childRequestFactory = (HttpRequestFactory)Preconditions.checkNotNull((Object)builder.childRequestFactory);
        this.jsonFactory = (JsonFactory)Preconditions.checkNotNull((Object)builder.jsonFactory);
        this.responseInterceptor = builder.responseInterceptor;
        this.errorHandler = new MessagingErrorHandler(this.jsonFactory);
        this.httpClient = new ErrorHandlingHttpClient<FirebaseMessagingException>(this.requestFactory, this.jsonFactory, this.errorHandler).setInterceptor(this.responseInterceptor);
        this.batchClient = new MessagingBatchClient(this.requestFactory.getTransport(), this.jsonFactory);
    }

    @VisibleForTesting
    String getFcmSendUrl() {
        return this.fcmSendUrl;
    }

    @VisibleForTesting
    HttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @VisibleForTesting
    HttpRequestFactory getChildRequestFactory() {
        return this.childRequestFactory;
    }

    @VisibleForTesting
    JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    @Override
    public String send(Message message, boolean dryRun) throws FirebaseMessagingException {
        return this.sendSingleRequest(message, dryRun);
    }

    @Override
    public BatchResponse sendAll(List<Message> messages, boolean dryRun) throws FirebaseMessagingException {
        return this.sendBatchRequest(messages, dryRun);
    }

    private String sendSingleRequest(Message message, boolean dryRun) throws FirebaseMessagingException {
        HttpRequestInfo request = HttpRequestInfo.buildJsonPostRequest(this.fcmSendUrl, message.wrapForTransport(dryRun)).addAllHeaders(COMMON_HEADERS);
        MessagingServiceResponse parsed = this.httpClient.sendAndParse(request, MessagingServiceResponse.class);
        return parsed.getMessageId();
    }

    private BatchResponse sendBatchRequest(List<Message> messages, boolean dryRun) throws FirebaseMessagingException {
        MessagingBatchCallback callback = new MessagingBatchCallback();
        try {
            BatchRequest batch = this.newBatchRequest(messages, dryRun, callback);
            batch.execute();
            return new BatchResponseImpl(callback.getResponses());
        }
        catch (HttpResponseException e) {
            OutgoingHttpRequest req = new OutgoingHttpRequest("POST", MessagingBatchClient.FCM_BATCH_URL);
            IncomingHttpResponse resp = new IncomingHttpResponse(e, req);
            throw (FirebaseMessagingException)this.errorHandler.handleHttpResponseException(e, resp);
        }
        catch (IOException e) {
            throw (FirebaseMessagingException)this.errorHandler.handleIOException(e);
        }
    }

    private BatchRequest newBatchRequest(List<Message> messages, boolean dryRun, MessagingBatchCallback callback) throws IOException {
        BatchRequest batch = this.batchClient.batch(this.getBatchRequestInitializer());
        JsonObjectParser jsonParser = new JsonObjectParser(this.jsonFactory);
        GenericUrl sendUrl = new GenericUrl(this.fcmSendUrl);
        for (Message message : messages) {
            HttpRequest request = this.childRequestFactory.buildPostRequest(sendUrl, (HttpContent)new JsonHttpContent(this.jsonFactory, message.wrapForTransport(dryRun)));
            request.setParser((ObjectParser)jsonParser);
            request.getHeaders().putAll(COMMON_HEADERS);
            batch.queue(request, MessagingServiceResponse.class, MessagingServiceErrorResponse.class, (BatchCallback)callback);
        }
        return batch;
    }

    private HttpRequestInitializer getBatchRequestInitializer() {
        return new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                HttpRequestInitializer initializer = FirebaseMessagingClientImpl.this.requestFactory.getInitializer();
                if (initializer != null) {
                    initializer.initialize(request);
                }
                request.setResponseInterceptor(FirebaseMessagingClientImpl.this.responseInterceptor);
            }
        };
    }

    static FirebaseMessagingClientImpl fromApp(FirebaseApp app) {
        String projectId = ImplFirebaseTrampolines.getProjectId(app);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Project ID is required to access messaging service. Use a service account credential or set the project ID explicitly via FirebaseOptions. Alternatively you can also set the project ID via the GOOGLE_CLOUD_PROJECT environment variable.");
        return FirebaseMessagingClientImpl.builder().setProjectId(projectId).setRequestFactory(ApiClientUtils.newAuthorizedRequestFactory(app)).setChildRequestFactory(ApiClientUtils.newUnauthorizedRequestFactory(app)).setJsonFactory(app.getOptions().getJsonFactory()).build();
    }

    static Builder builder() {
        return new Builder();
    }

    private static class MessagingBatchClient
    extends AbstractGoogleJsonClient {
        private static final String FCM_ROOT_URL = "https://fcm.googleapis.com";
        private static final String FCM_BATCH_PATH = "batch";
        private static final String FCM_BATCH_URL = String.format("%s/%s", "https://fcm.googleapis.com", "batch");

        MessagingBatchClient(HttpTransport transport, JsonFactory jsonFactory) {
            super((AbstractGoogleJsonClient.Builder)new Builder(transport, jsonFactory));
        }

        private MessagingBatchClient(Builder builder) {
            super((AbstractGoogleJsonClient.Builder)builder);
        }

        private static class Builder
        extends AbstractGoogleJsonClient.Builder {
            Builder(HttpTransport transport, JsonFactory jsonFactory) {
                super(transport, jsonFactory, MessagingBatchClient.FCM_ROOT_URL, "", null, false);
                this.setBatchPath(MessagingBatchClient.FCM_BATCH_PATH);
                this.setApplicationName("fire-admin-java");
            }

            public AbstractGoogleJsonClient build() {
                return new MessagingBatchClient(this);
            }
        }
    }

    private static class MessagingErrorHandler
    extends AbstractPlatformErrorHandler<FirebaseMessagingException> {
        private MessagingErrorHandler(JsonFactory jsonFactory) {
            super(jsonFactory);
        }

        @Override
        protected FirebaseMessagingException createException(FirebaseException base) {
            String response = this.getResponse(base);
            MessagingServiceErrorResponse parsed = this.safeParse(response);
            return FirebaseMessagingException.withMessagingErrorCode(base, parsed.getMessagingErrorCode());
        }

        private String getResponse(FirebaseException base) {
            if (base.getHttpResponse() == null) {
                return null;
            }
            return base.getHttpResponse().getContent();
        }

        private MessagingServiceErrorResponse safeParse(String response) {
            if (!Strings.isNullOrEmpty((String)response)) {
                try {
                    return (MessagingServiceErrorResponse)((Object)this.jsonFactory.createJsonParser(response).parseAndClose(MessagingServiceErrorResponse.class));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new MessagingServiceErrorResponse();
        }
    }

    private static class MessagingBatchCallback
    implements BatchCallback<MessagingServiceResponse, MessagingServiceErrorResponse> {
        private final ImmutableList.Builder<SendResponse> responses = ImmutableList.builder();

        private MessagingBatchCallback() {
        }

        public void onSuccess(MessagingServiceResponse response, HttpHeaders responseHeaders) {
            this.responses.add((Object)SendResponse.fromMessageId(response.getMessageId()));
        }

        public void onFailure(MessagingServiceErrorResponse error, HttpHeaders responseHeaders) {
            FirebaseException base = this.createFirebaseException(error);
            FirebaseMessagingException exception = FirebaseMessagingException.withMessagingErrorCode(base, error.getMessagingErrorCode());
            this.responses.add((Object)SendResponse.fromException(exception));
        }

        List<SendResponse> getResponses() {
            return this.responses.build();
        }

        private FirebaseException createFirebaseException(MessagingServiceErrorResponse error) {
            String status = error.getStatus();
            ErrorCode errorCode = Strings.isNullOrEmpty((String)status) ? ErrorCode.UNKNOWN : Enum.valueOf(ErrorCode.class, status);
            String msg = error.getErrorMessage();
            if (Strings.isNullOrEmpty((String)msg)) {
                msg = String.format("Unexpected HTTP response: %s", error.toString());
            }
            return new FirebaseException(errorCode, msg, null);
        }
    }

    static final class Builder {
        private String projectId;
        private HttpRequestFactory requestFactory;
        private HttpRequestFactory childRequestFactory;
        private JsonFactory jsonFactory;
        private HttpResponseInterceptor responseInterceptor;

        private Builder() {
        }

        Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        Builder setRequestFactory(HttpRequestFactory requestFactory) {
            this.requestFactory = requestFactory;
            return this;
        }

        Builder setChildRequestFactory(HttpRequestFactory childRequestFactory) {
            this.childRequestFactory = childRequestFactory;
            return this;
        }

        Builder setJsonFactory(JsonFactory jsonFactory) {
            this.jsonFactory = jsonFactory;
            return this;
        }

        Builder setResponseInterceptor(HttpResponseInterceptor responseInterceptor) {
            this.responseInterceptor = responseInterceptor;
            return this;
        }

        FirebaseMessagingClientImpl build() {
            return new FirebaseMessagingClientImpl(this);
        }
    }
}

